<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Listar ServiceType
 * @subpackage Services
 */
class Listar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListarEstados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarEstados $parameters
     * @return \StructType\ListarEstadosResponse|bool
     */
    public function ListarEstados(\StructType\ListarEstados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarEstados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListarCidades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListarCidades $parameters
     * @return \StructType\ListarCidadesResponse|bool
     */
    public function ListarCidades(\StructType\ListarCidades $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ListarCidades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListarCidadesResponse|\StructType\ListarEstadosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
