<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incluir ServiceType
 * @subpackage Services
 */
class Incluir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IncluirConversa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirConversa $parameters
     * @return \StructType\IncluirConversaResponse|bool
     */
    public function IncluirConversa(\StructType\IncluirConversa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirConversa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirEventoChekout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirEventoChekout $parameters
     * @return \StructType\IncluirEventoChekoutResponse|bool
     */
    public function IncluirEventoChekout(\StructType\IncluirEventoChekout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirEventoChekout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirBoletos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirBoletos $parameters
     * @return \StructType\IncluirBoletosResponse|bool
     */
    public function IncluirBoletos(\StructType\IncluirBoletos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirBoletos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirSPC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirSPC $parameters
     * @return \StructType\IncluirSPCResponse|bool
     */
    public function IncluirSPC(\StructType\IncluirSPC $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirSPC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirEvento $parameters
     * @return \StructType\IncluirEventoResponse|bool
     */
    public function IncluirEvento(\StructType\IncluirEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * IncluirCanaisdeAtendimentoPorCPFCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirCanaisdeAtendimentoPorCPFCNPJ $parameters
     * @return \StructType\IncluirCanaisdeAtendimentoPorCPFCNPJResponse|bool
     */
    public function IncluirCanaisdeAtendimentoPorCPFCNPJ(\StructType\IncluirCanaisdeAtendimentoPorCPFCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirCanaisdeAtendimentoPorCPFCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirAcordo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirAcordo $parameters
     * @return \StructType\IncluirAcordoResponse|bool
     */
    public function IncluirAcordo(\StructType\IncluirAcordo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirAcordo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirContrato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirContrato $parameters
     * @return \StructType\IncluirContratoResponse|bool
     */
    public function IncluirContrato(\StructType\IncluirContrato $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirContrato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirEmail $parameters
     * @return \StructType\IncluirEmailResponse|bool
     */
    public function IncluirEmail(\StructType\IncluirEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirTelefone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirTelefone $parameters
     * @return \StructType\IncluirTelefoneResponse|bool
     */
    public function IncluirTelefone(\StructType\IncluirTelefone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirTelefone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IncluirEndereco
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirEndereco $parameters
     * @return \StructType\IncluirEnderecoResponse|bool
     */
    public function IncluirEndereco(\StructType\IncluirEndereco $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncluirEndereco($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncluirAcordoResponse|\StructType\IncluirBoletosResponse|\StructType\IncluirCanaisdeAtendimentoPorCPFCNPJResponse|\StructType\IncluirContratoResponse|\StructType\IncluirConversaResponse|\StructType\IncluirEmailResponse|\StructType\IncluirEnderecoResponse|\StructType\IncluirEventoChekoutResponse|\StructType\IncluirEventoResponse|\StructType\IncluirSPCResponse|\StructType\IncluirTelefoneResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
