<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Health ServiceType
 * @subpackage Services
 */
class Health extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named HealthCheckRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\HealthCheckRoute $parameters
     * @return \StructType\HealthCheckRouteResponse|bool
     */
    public function HealthCheckRoute(\StructType\HealthCheckRoute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->HealthCheckRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\HealthCheckRouteResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
