<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Estornar ServiceType
 * @subpackage Services
 */
class Estornar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EstornarPagamentoCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarPagamentoCheckout $parameters
     * @return \StructType\EstornarPagamentoCheckoutResponse|bool
     */
    public function EstornarPagamentoCheckout(\StructType\EstornarPagamentoCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstornarPagamentoCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EstornarPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EstornarPagamento $parameters
     * @return \StructType\EstornarPagamentoResponse|bool
     */
    public function EstornarPagamento(\StructType\EstornarPagamento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EstornarPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EstornarPagamentoCheckoutResponse|\StructType\EstornarPagamentoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
