<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Devolver ServiceType
 * @subpackage Services
 */
class Devolver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DevolverContratoPorPagamentos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolverContratoPorPagamentos $parameters
     * @return \StructType\DevolverContratoPorPagamentosResponse|bool
     */
    public function DevolverContratoPorPagamentos(\StructType\DevolverContratoPorPagamentos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DevolverContratoPorPagamentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DevolverContratoPorPagamentoDireto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolverContratoPorPagamentoDireto $parameters
     * @return \StructType\DevolverContratoPorPagamentoDiretoResponse|bool
     */
    public function DevolverContratoPorPagamentoDireto(\StructType\DevolverContratoPorPagamentoDireto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DevolverContratoPorPagamentoDireto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DevolverContrato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolverContrato $parameters
     * @return \StructType\DevolverContratoResponse|bool
     */
    public function DevolverContrato(\StructType\DevolverContrato $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DevolverContrato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DevolverContratoMotivo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolverContratoMotivo $parameters
     * @return \StructType\DevolverContratoMotivoResponse|bool
     */
    public function DevolverContratoMotivo(\StructType\DevolverContratoMotivo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DevolverContratoMotivo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * DevolverContratoPorDevolucoesParciais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolverContratoPorDevolucoesParciais $parameters
     * @return \StructType\DevolverContratoPorDevolucoesParciaisResponse|bool
     */
    public function DevolverContratoPorDevolucoesParciais(\StructType\DevolverContratoPorDevolucoesParciais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DevolverContratoPorDevolucoesParciais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DevolverContratoMotivoResponse|\StructType\DevolverContratoPorDevolucoesParciaisResponse|\StructType\DevolverContratoPorPagamentoDiretoResponse|\StructType\DevolverContratoPorPagamentosResponse|\StructType\DevolverContratoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
