<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Contratos ServiceType
 * @subpackage Services
 */
class Contratos extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ContratosDistribuidos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContratosDistribuidos $parameters
     * @return \StructType\ContratosDistribuidosResponse|bool
     */
    public function ContratosDistribuidos(\StructType\ContratosDistribuidos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ContratosDistribuidos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ContratosDistribuidosPorData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ContratosDistribuidosPorData $parameters
     * @return \StructType\ContratosDistribuidosPorDataResponse|bool
     */
    public function ContratosDistribuidosPorData(\StructType\ContratosDistribuidosPorData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ContratosDistribuidosPorData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ContratosDistribuidosPorDataResponse|\StructType\ContratosDistribuidosResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
