<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaDadosCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDadosCheckout $parameters
     * @return \StructType\ConsultaDadosCheckoutResponse|bool
     */
    public function ConsultaDadosCheckout(\StructType\ConsultaDadosCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDadosCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaURLCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaURLCheckout $parameters
     * @return \StructType\ConsultaURLCheckoutResponse|bool
     */
    public function ConsultaURLCheckout(\StructType\ConsultaURLCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaURLCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaURLCheckoutCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaURLCheckoutCobChat $parameters
     * @return \StructType\ConsultaURLCheckoutCobChatResponse|bool
     */
    public function ConsultaURLCheckoutCobChat(\StructType\ConsultaURLCheckoutCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaURLCheckoutCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaPixCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaPixCobChat $parameters
     * @return \StructType\ConsultaPixCobChatResponse|bool
     */
    public function ConsultaPixCobChat(\StructType\ConsultaPixCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaPixCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaParcelasAbertas30dias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaParcelasAbertas30dias $parameters
     * @return \StructType\ConsultaParcelasAbertas30diasResponse|bool
     */
    public function ConsultaParcelasAbertas30dias(\StructType\ConsultaParcelasAbertas30dias $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaParcelasAbertas30dias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaParcelasAbertasPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaParcelasAbertasPortal $parameters
     * @return \StructType\ConsultaParcelasAbertasPortalResponse|bool
     */
    public function ConsultaParcelasAbertasPortal(\StructType\ConsultaParcelasAbertasPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaParcelasAbertasPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaContratosMarcador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaContratosMarcador $parameters
     * @return \StructType\ConsultaContratosMarcadorResponse|bool
     */
    public function ConsultaContratosMarcador(\StructType\ConsultaContratosMarcador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaContratosMarcador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaBoletosOriginais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaBoletosOriginais $parameters
     * @return \StructType\ConsultaBoletosOriginaisResponse|bool
     */
    public function ConsultaBoletosOriginais(\StructType\ConsultaBoletosOriginais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaBoletosOriginais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultaParcelasAbertasCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaParcelasAbertasCobChat $parameters
     * @return \StructType\ConsultaParcelasAbertasCobChatResponse|bool
     */
    public function ConsultaParcelasAbertasCobChat(\StructType\ConsultaParcelasAbertasCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaParcelasAbertasCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaBoletosOriginaisResponse|\StructType\ConsultaContratosMarcadorResponse|\StructType\ConsultaDadosCheckoutResponse|\StructType\ConsultaParcelasAbertas30diasResponse|\StructType\ConsultaParcelasAbertasCobChatResponse|\StructType\ConsultaParcelasAbertasPortalResponse|\StructType\ConsultaPixCobChatResponse|\StructType\ConsultaURLCheckoutCobChatResponse|\StructType\ConsultaURLCheckoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
