<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cadastra ServiceType
 * @subpackage Services
 */
class Cadastra extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CadastraProposta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastraProposta $parameters
     * @return \StructType\CadastraPropostaResponse|bool
     */
    public function CadastraProposta(\StructType\CadastraProposta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastraProposta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CadastraPropostaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
