<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'ArrayOfstring' => '\\ArrayType\\ArrayOfstring',
            'ParcelaCalculoRequest' => '\\StructType\\ParcelaCalculoRequest',
            'ArrayOfParcelaCalculoType' => '\\ArrayType\\ArrayOfParcelaCalculoType',
            'ParcelaCalculoType' => '\\StructType\\ParcelaCalculoType',
            'BoletoTypePortal' => '\\StructType\\BoletoTypePortal',
            'ArrayOfContratoSemNumeroPastaResponse' => '\\ArrayType\\ArrayOfContratoSemNumeroPastaResponse',
            'ContratoSemNumeroPastaResponse' => '\\StructType\\ContratoSemNumeroPastaResponse',
            'ArrayOfDadosAdicionaisContratoSemNumeroPastaResponse' => '\\ArrayType\\ArrayOfDadosAdicionaisContratoSemNumeroPastaResponse',
            'DadosAdicionaisContratoSemNumeroPastaResponse' => '\\StructType\\DadosAdicionaisContratoSemNumeroPastaResponse',
            'ClienteResponse' => '\\StructType\\ClienteResponse',
            'ClienteType' => '\\StructType\\ClienteType',
            'ClienteRequest' => '\\StructType\\ClienteRequest',
            'ArrayOfContratoRequest' => '\\ArrayType\\ArrayOfContratoRequest',
            'ContratoRequest' => '\\StructType\\ContratoRequest',
            'ContratoType' => '\\StructType\\ContratoType',
            'ContratoResponse' => '\\StructType\\ContratoResponse',
            'ArrayOfAcordoResponse' => '\\ArrayType\\ArrayOfAcordoResponse',
            'AcordoResponse' => '\\StructType\\AcordoResponse',
            'AcordoType' => '\\StructType\\AcordoType',
            'ClienteAcordoResponse' => '\\StructType\\ClienteAcordoResponse',
            'AssessoriaResponse' => '\\StructType\\AssessoriaResponse',
            'AssessoriaType' => '\\StructType\\AssessoriaType',
            'AssessoriaRequest' => '\\StructType\\AssessoriaRequest',
            'AcordoRequest' => '\\StructType\\AcordoRequest',
            'ArrayOfParcelaAcordoRequest' => '\\ArrayType\\ArrayOfParcelaAcordoRequest',
            'ParcelaAcordoRequest' => '\\StructType\\ParcelaAcordoRequest',
            'ParcelaAcordoType' => '\\StructType\\ParcelaAcordoType',
            'ParcelaAcordoResponse' => '\\StructType\\ParcelaAcordoResponse',
            'ArrayOfParcelaOriginalRequest' => '\\ArrayType\\ArrayOfParcelaOriginalRequest',
            'ParcelaOriginalRequest' => '\\StructType\\ParcelaOriginalRequest',
            'ParcelaOriginalType' => '\\StructType\\ParcelaOriginalType',
            'ParcelaOriginalResponse' => '\\StructType\\ParcelaOriginalResponse',
            'ArrayOfParcelaAcordoResponse' => '\\ArrayType\\ArrayOfParcelaAcordoResponse',
            'ArrayOfParcelaOriginalResponse' => '\\ArrayType\\ArrayOfParcelaOriginalResponse',
            'ArrayOfEventoResponse' => '\\ArrayType\\ArrayOfEventoResponse',
            'EventoResponse' => '\\StructType\\EventoResponse',
            'EventoType' => '\\StructType\\EventoType',
            'EventoRequest' => '\\StructType\\EventoRequest',
            'EventoClienteResponse' => '\\StructType\\EventoClienteResponse',
            'ArrayOfEventoContratoResponse' => '\\ArrayType\\ArrayOfEventoContratoResponse',
            'EventoContratoResponse' => '\\StructType\\EventoContratoResponse',
            'ArrayOfParcelaResponse' => '\\ArrayType\\ArrayOfParcelaResponse',
            'ParcelaResponse' => '\\StructType\\ParcelaResponse',
            'ParcelaType' => '\\StructType\\ParcelaType',
            'ParcelaRequest' => '\\StructType\\ParcelaRequest',
            'DadosAdicionaisRequest' => '\\StructType\\DadosAdicionaisRequest',
            'DadosAdicionaisType' => '\\StructType\\DadosAdicionaisType',
            'DadosAdicionaisResponse' => '\\StructType\\DadosAdicionaisResponse',
            'ArrayOfProdutoResponse' => '\\ArrayType\\ArrayOfProdutoResponse',
            'ProdutoResponse' => '\\StructType\\ProdutoResponse',
            'ProdutoType' => '\\StructType\\ProdutoType',
            'ProdutoRequest' => '\\StructType\\ProdutoRequest',
            'ContratoClienteResponse' => '\\StructType\\ContratoClienteResponse',
            'CredorContratoResponse' => '\\StructType\\CredorContratoResponse',
            'ArrayOfParcelaRequest' => '\\ArrayType\\ArrayOfParcelaRequest',
            'ArrayOfProdutoRequest' => '\\ArrayType\\ArrayOfProdutoRequest',
            'ArrayOfEmailRequest' => '\\ArrayType\\ArrayOfEmailRequest',
            'EmailRequest' => '\\StructType\\EmailRequest',
            'EmailType' => '\\StructType\\EmailType',
            'EmailResponse' => '\\StructType\\EmailResponse',
            'ArrayOfEnderecoRequest' => '\\ArrayType\\ArrayOfEnderecoRequest',
            'EnderecoRequest' => '\\StructType\\EnderecoRequest',
            'EnderecoType' => '\\StructType\\EnderecoType',
            'EnderecoResponse' => '\\StructType\\EnderecoResponse',
            'PessoaFisicaRequest' => '\\StructType\\PessoaFisicaRequest',
            'PessoaFisicaType' => '\\StructType\\PessoaFisicaType',
            'PessoaFisicaResponse' => '\\StructType\\PessoaFisicaResponse',
            'PessoaJuridicaRequest' => '\\StructType\\PessoaJuridicaRequest',
            'PessoaJuridicaType' => '\\StructType\\PessoaJuridicaType',
            'PessoaJuridicaResponse' => '\\StructType\\PessoaJuridicaResponse',
            'ArrayOfTelefoneRequest' => '\\ArrayType\\ArrayOfTelefoneRequest',
            'TelefoneRequest' => '\\StructType\\TelefoneRequest',
            'TelefoneType' => '\\StructType\\TelefoneType',
            'TelefoneResponse' => '\\StructType\\TelefoneResponse',
            'ClienteDiscadorResponse' => '\\StructType\\ClienteDiscadorResponse',
            'ArrayOfContratoClienteDiscadorResponse' => '\\ArrayType\\ArrayOfContratoClienteDiscadorResponse',
            'ContratoClienteDiscadorResponse' => '\\StructType\\ContratoClienteDiscadorResponse',
            'ArrayOfContratoClienteResponse' => '\\ArrayType\\ArrayOfContratoClienteResponse',
            'ArrayOfEmailResponse' => '\\ArrayType\\ArrayOfEmailResponse',
            'ArrayOfEnderecoResponse' => '\\ArrayType\\ArrayOfEnderecoResponse',
            'ArrayOfReferenciaResponse' => '\\ArrayType\\ArrayOfReferenciaResponse',
            'ReferenciaResponse' => '\\StructType\\ReferenciaResponse',
            'ReferenciaType' => '\\StructType\\ReferenciaType',
            'ReferenciaRequest' => '\\StructType\\ReferenciaRequest',
            'ArrayOfTelefoneResponse' => '\\ArrayType\\ArrayOfTelefoneResponse',
            'ArrayOfCredorType' => '\\ArrayType\\ArrayOfCredorType',
            'CredorType' => '\\StructType\\CredorType',
            'CredorResponse' => '\\StructType\\CredorResponse',
            'ArrayOfContratoTypePortal' => '\\ArrayType\\ArrayOfContratoTypePortal',
            'ContratoTypePortal' => '\\StructType\\ContratoTypePortal',
            'ArrayOfProdutoTypePortal' => '\\ArrayType\\ArrayOfProdutoTypePortal',
            'ProdutoTypePortal' => '\\StructType\\ProdutoTypePortal',
            'ArrayOfProdutoComposicaoType' => '\\ArrayType\\ArrayOfProdutoComposicaoType',
            'ProdutoComposicaoType' => '\\StructType\\ProdutoComposicaoType',
            'ContratoResponsePortal' => '\\StructType\\ContratoResponsePortal',
            'ArrayOfFormaPagamentoUraType' => '\\ArrayType\\ArrayOfFormaPagamentoUraType',
            'FormaPagamentoUraType' => '\\StructType\\FormaPagamentoUraType',
            'FormaPagamentoUraResponse' => '\\StructType\\FormaPagamentoUraResponse',
            'CalculoPortalResponse' => '\\StructType\\CalculoPortalResponse',
            'ArrayOfCalculoTypePortal' => '\\ArrayType\\ArrayOfCalculoTypePortal',
            'CalculoTypePortal' => '\\StructType\\CalculoTypePortal',
            'CampanhaDesconto' => '\\StructType\\CampanhaDesconto',
            'ArrayOfOpcesParcelamentoType' => '\\ArrayType\\ArrayOfOpcesParcelamentoType',
            'OpcesParcelamentoType' => '\\StructType\\OpcesParcelamentoType',
            'ArrayOfDataCalculoOpcao' => '\\ArrayType\\ArrayOfDataCalculoOpcao',
            'DataCalculoOpcao' => '\\StructType\\DataCalculoOpcao',
            'ArrayOfParcelaOriginalCobChatResponse' => '\\ArrayType\\ArrayOfParcelaOriginalCobChatResponse',
            'ParcelaOriginalCobChatResponse' => '\\StructType\\ParcelaOriginalCobChatResponse',
            'ParcelaOriginalCobChatType' => '\\StructType\\ParcelaOriginalCobChatType',
            'ParcelaOriginalCobChatRequest' => '\\StructType\\ParcelaOriginalCobChatRequest',
            'ArrayOfParcelaCalculoResponse' => '\\ArrayType\\ArrayOfParcelaCalculoResponse',
            'ParcelaCalculoResponse' => '\\StructType\\ParcelaCalculoResponse',
            'CET' => '\\StructType\\CET',
            'ArrayOfParcelaAcordoType' => '\\ArrayType\\ArrayOfParcelaAcordoType',
            'TermoAcordoKrotonResponse' => '\\StructType\\TermoAcordoKrotonResponse',
            'TermoAcordoKrotonType' => '\\StructType\\TermoAcordoKrotonType',
            'EmissaoBoletoTypeUra' => '\\StructType\\EmissaoBoletoTypeUra',
            'DadosClienteResponse' => '\\StructType\\DadosClienteResponse',
            'PortalControleAcessoResponse' => '\\StructType\\PortalControleAcessoResponse',
            'PortalControleAcessoType' => '\\StructType\\PortalControleAcessoType',
            'FormaPagamentoCobChatResponse' => '\\StructType\\FormaPagamentoCobChatResponse',
            'FormaPagamentoCobChatType' => '\\StructType\\FormaPagamentoCobChatType',
            'AutenticacaoResponse' => '\\StructType\\AutenticacaoResponse',
            'AssessoriaResponsePortal' => '\\StructType\\AssessoriaResponsePortal',
            'AssessoriaTypePortal' => '\\StructType\\AssessoriaTypePortal',
            'ArrayOfConfigTypePortalResponse' => '\\ArrayType\\ArrayOfConfigTypePortalResponse',
            'ConfigTypePortalResponse' => '\\StructType\\ConfigTypePortalResponse',
            'ConfigTypePortal' => '\\StructType\\ConfigTypePortal',
            'ArrayOfCartaoParametroType' => '\\ArrayType\\ArrayOfCartaoParametroType',
            'CartaoParametroType' => '\\StructType\\CartaoParametroType',
            'PortalIntegracaoResponse' => '\\StructType\\PortalIntegracaoResponse',
            'PortalIntegracaoType' => '\\StructType\\PortalIntegracaoType',
            'ArrayOfPortalParametroResponse' => '\\ArrayType\\ArrayOfPortalParametroResponse',
            'PortalParametroResponse' => '\\StructType\\PortalParametroResponse',
            'PortalParametroType' => '\\StructType\\PortalParametroType',
            'PessoaTypePortal' => '\\StructType\\PessoaTypePortal',
            'PessoaPortalResponse' => '\\StructType\\PessoaPortalResponse',
            'ArrayOfUFType' => '\\ArrayType\\ArrayOfUFType',
            'UFType' => '\\StructType\\UFType',
            'ArrayOfCidadeType' => '\\ArrayType\\ArrayOfCidadeType',
            'CidadeType' => '\\StructType\\CidadeType',
            'SolicitaContatoType' => '\\StructType\\SolicitaContatoType',
            'PropostaType' => '\\StructType\\PropostaType',
            'TermoAcordoTypePortal' => '\\StructType\\TermoAcordoTypePortal',
            'EmissaoBoletoTypePortal' => '\\StructType\\EmissaoBoletoTypePortal',
            'PortalLogType' => '\\StructType\\PortalLogType',
            'PortalLogResponse' => '\\StructType\\PortalLogResponse',
            'PortalLogRequest' => '\\StructType\\PortalLogRequest',
            'ArrayOfBoletoAbertoTypePortal' => '\\ArrayType\\ArrayOfBoletoAbertoTypePortal',
            'BoletoAbertoTypePortal' => '\\StructType\\BoletoAbertoTypePortal',
            'ContratoCampoResponsePortal' => '\\StructType\\ContratoCampoResponsePortal',
            'ContratoCampoTypePortal' => '\\StructType\\ContratoCampoTypePortal',
            'ArrayOfAcordoPortalResponse' => '\\ArrayType\\ArrayOfAcordoPortalResponse',
            'AcordoPortalResponse' => '\\StructType\\AcordoPortalResponse',
            'AcordoTypePortal' => '\\StructType\\AcordoTypePortal',
            'AcordoPortalRequest' => '\\StructType\\AcordoPortalRequest',
            'ArrayOfParcelaAcordoPortalRequest' => '\\ArrayType\\ArrayOfParcelaAcordoPortalRequest',
            'ParcelaAcordoPortalRequest' => '\\StructType\\ParcelaAcordoPortalRequest',
            'ParcelaAcordoTypePortal' => '\\StructType\\ParcelaAcordoTypePortal',
            'ParcelaAcordoPortalResponse' => '\\StructType\\ParcelaAcordoPortalResponse',
            'ArrayOfParcelaAcordoPortalResponse' => '\\ArrayType\\ArrayOfParcelaAcordoPortalResponse',
            'ArrayOfClienteAcordoResponse' => '\\ArrayType\\ArrayOfClienteAcordoResponse',
            'ArrayOfReferenciaRequest' => '\\ArrayType\\ArrayOfReferenciaRequest',
            'ArrayOfContratosDistribuidosResponse' => '\\ArrayType\\ArrayOfContratosDistribuidosResponse',
            'ContratosDistribuidosResponse' => '\\StructType\\ContratosDistribuidosResponse',
            'ArrayOfPagamentoDiretoRequest' => '\\ArrayType\\ArrayOfPagamentoDiretoRequest',
            'PagamentoDiretoRequest' => '\\StructType\\PagamentoDiretoRequest',
            'PagamentoDiretoType' => '\\StructType\\PagamentoDiretoType',
            'ArrayOfDevolucaoParcialRequest' => '\\ArrayType\\ArrayOfDevolucaoParcialRequest',
            'DevolucaoParcialRequest' => '\\StructType\\DevolucaoParcialRequest',
            'DevolucaoParcialType' => '\\StructType\\DevolucaoParcialType',
            'ArrayOfClienteResponse' => '\\ArrayType\\ArrayOfClienteResponse',
            'ArrayOfContratoResponse' => '\\ArrayType\\ArrayOfContratoResponse',
            'ArrayOfEventoClienteResponse' => '\\ArrayType\\ArrayOfEventoClienteResponse',
            'ArrayOfBoletoRequest' => '\\ArrayType\\ArrayOfBoletoRequest',
            'BoletoRequest' => '\\StructType\\BoletoRequest',
            'BoletoType' => '\\StructType\\BoletoType',
            'BoletoResponse' => '\\StructType\\BoletoResponse',
            'ArrayOfPagamentoResponse' => '\\ArrayType\\ArrayOfPagamentoResponse',
            'PagamentoResponse' => '\\StructType\\PagamentoResponse',
            'PagamentoType' => '\\StructType\\PagamentoType',
            'ArrayOfPagamentosOperadorResponse' => '\\ArrayType\\ArrayOfPagamentosOperadorResponse',
            'PagamentosOperadorResponse' => '\\StructType\\PagamentosOperadorResponse',
            'ArrayOfPagamentoRenegResponse' => '\\ArrayType\\ArrayOfPagamentoRenegResponse',
            'PagamentoRenegResponse' => '\\StructType\\PagamentoRenegResponse',
            'AcordoRenegResponse' => '\\StructType\\AcordoRenegResponse',
            'ArrayOfParcelaAcordoRenegResponse' => '\\ArrayType\\ArrayOfParcelaAcordoRenegResponse',
            'ParcelaAcordoRenegResponse' => '\\StructType\\ParcelaAcordoRenegResponse',
            'ArrayOfParcelaOriginalRenegResponse' => '\\ArrayType\\ArrayOfParcelaOriginalRenegResponse',
            'ParcelaOriginalRenegResponse' => '\\StructType\\ParcelaOriginalRenegResponse',
            'ArrayOfBoletoRenegResponse' => '\\ArrayType\\ArrayOfBoletoRenegResponse',
            'BoletoRenegResponse' => '\\StructType\\BoletoRenegResponse',
            'ContratoRenegResponse' => '\\StructType\\ContratoRenegResponse',
            'ContratoRenegType' => '\\StructType\\ContratoRenegType',
            'ArrayOfParcelaRenegResponse' => '\\ArrayType\\ArrayOfParcelaRenegResponse',
            'ParcelaRenegResponse' => '\\StructType\\ParcelaRenegResponse',
            'ArrayOfProdutoRenegResponse' => '\\ArrayType\\ArrayOfProdutoRenegResponse',
            'ProdutoRenegResponse' => '\\StructType\\ProdutoRenegResponse',
            'PagamentoReneg' => '\\StructType\\PagamentoReneg',
            'ArrayOfBoletoResponse' => '\\ArrayType\\ArrayOfBoletoResponse',
            'ArrayOfAcordoQuebraResponse' => '\\ArrayType\\ArrayOfAcordoQuebraResponse',
            'AcordoQuebraResponse' => '\\StructType\\AcordoQuebraResponse',
            'NossoNumeroResponse' => '\\StructType\\NossoNumeroResponse',
            'ArrayOfConfigTypePortal' => '\\ArrayType\\ArrayOfConfigTypePortal',
            'ArrayOfBoletoOriginalResponse' => '\\ArrayType\\ArrayOfBoletoOriginalResponse',
            'BoletoOriginalResponse' => '\\StructType\\BoletoOriginalResponse',
            'ArrayOfContratoBoletoResponse' => '\\ArrayType\\ArrayOfContratoBoletoResponse',
            'ContratoBoletoResponse' => '\\StructType\\ContratoBoletoResponse',
            'ArrayOfClienteCadastralResponse' => '\\ArrayType\\ArrayOfClienteCadastralResponse',
            'ClienteCadastralResponse' => '\\StructType\\ClienteCadastralResponse',
            'ArrayOfFormaPagamentoType' => '\\ArrayType\\ArrayOfFormaPagamentoType',
            'FormaPagamentoType' => '\\StructType\\FormaPagamentoType',
            'FormaPagamentoResponse' => '\\StructType\\FormaPagamentoResponse',
            'ArrayOfFormaPagamentoCobChatType' => '\\ArrayType\\ArrayOfFormaPagamentoCobChatType',
            'ArrayOfAlterarNumeroParcelaAcordoRequest' => '\\ArrayType\\ArrayOfAlterarNumeroParcelaAcordoRequest',
            'AlterarNumeroParcelaAcordoRequest' => '\\StructType\\AlterarNumeroParcelaAcordoRequest',
            'AlterarNumeroParcelaAcordoType' => '\\StructType\\AlterarNumeroParcelaAcordoType',
            'AlterarNumeroParcelaAcordoResponse' => '\\StructType\\AlterarNumeroParcelaAcordoResponse',
            'ArrayOfAlterarNumeroParcelaAcordoResponse' => '\\ArrayType\\ArrayOfAlterarNumeroParcelaAcordoResponse',
            'ArrayOfAcordoCredorTypePortal' => '\\ArrayType\\ArrayOfAcordoCredorTypePortal',
            'AcordoCredorTypePortal' => '\\StructType\\AcordoCredorTypePortal',
            'ArrayOfFilialKrotonResponse' => '\\ArrayType\\ArrayOfFilialKrotonResponse',
            'FilialKrotonResponse' => '\\StructType\\FilialKrotonResponse',
            'FilialKrotonType' => '\\StructType\\FilialKrotonType',
            'CertificadoDeAceiteKrotonResponse' => '\\StructType\\CertificadoDeAceiteKrotonResponse',
            'CertificadoDeAceiteKrotonType' => '\\StructType\\CertificadoDeAceiteKrotonType',
            'DadosCheckoutType' => '\\StructType\\DadosCheckoutType',
            'ArrayOfContratoTypeCheckout' => '\\ArrayType\\ArrayOfContratoTypeCheckout',
            'ContratoTypeCheckout' => '\\StructType\\ContratoTypeCheckout',
            'ArrayOfParcelaTypeCheckout' => '\\ArrayType\\ArrayOfParcelaTypeCheckout',
            'ParcelaTypeCheckout' => '\\StructType\\ParcelaTypeCheckout',
            'DadosPixType' => '\\StructType\\DadosPixType',
            'DadosPixTypePortal' => '\\StructType\\DadosPixTypePortal',
            'ArrayOfContratoTypePix' => '\\ArrayType\\ArrayOfContratoTypePix',
            'ContratoTypePix' => '\\StructType\\ContratoTypePix',
            'ArrayOfParcelaTypePix' => '\\ArrayType\\ArrayOfParcelaTypePix',
            'ParcelaTypePix' => '\\StructType\\ParcelaTypePix',
            'PagamentoCheckoutRequest' => '\\StructType\\PagamentoCheckoutRequest',
            'ConcluirCheckoutType' => '\\StructType\\ConcluirCheckoutType',
            'AssessoriaResponseCheckout' => '\\StructType\\AssessoriaResponseCheckout',
            'AssessoriaResponsePix' => '\\StructType\\AssessoriaResponsePix',
            'CheckoutConfiguracaoType' => '\\StructType\\CheckoutConfiguracaoType',
            'CheckOutLogType' => '\\StructType\\CheckOutLogType',
            'SalvarAcordoRequest' => '\\StructType\\SalvarAcordoRequest',
            'SalvarAcordoType' => '\\StructType\\SalvarAcordoType',
            'ArrayOfDespesaRequest' => '\\ArrayType\\ArrayOfDespesaRequest',
            'DespesaRequest' => '\\StructType\\DespesaRequest',
            'DespesaType' => '\\StructType\\DespesaType',
            'ArrayOfParcelaNovaAcordoRequest' => '\\ArrayType\\ArrayOfParcelaNovaAcordoRequest',
            'ParcelaNovaAcordoRequest' => '\\StructType\\ParcelaNovaAcordoRequest',
            'ParcelaNovaAcordoType' => '\\StructType\\ParcelaNovaAcordoType',
            'ArrayOfParcelaOriginalAcordoRequest' => '\\ArrayType\\ArrayOfParcelaOriginalAcordoRequest',
            'ParcelaOriginalAcordoRequest' => '\\StructType\\ParcelaOriginalAcordoRequest',
            'ParcelaOriginalAcordoType' => '\\StructType\\ParcelaOriginalAcordoType',
            'EnviaBoletoCobChat' => '\\StructType\\EnviaBoletoCobChat',
            'EnviaBoletoCobChatResponse' => '\\StructType\\EnviaBoletoCobChatResponse',
            'GerarAcordoCobChat' => '\\StructType\\GerarAcordoCobChat',
            'GerarAcordoCobChatResponse' => '\\StructType\\GerarAcordoCobChatResponse',
            'ConsultarContratosSemNumeroPasta' => '\\StructType\\ConsultarContratosSemNumeroPasta',
            'ConsultarContratosSemNumeroPastaResponse' => '\\StructType\\ConsultarContratosSemNumeroPastaResponse',
            'QuebrarAcordoCobChat' => '\\StructType\\QuebrarAcordoCobChat',
            'QuebrarAcordoCobChatResponse' => '\\StructType\\QuebrarAcordoCobChatResponse',
            'ConsultarClientePorCPFCNPJUra' => '\\StructType\\ConsultarClientePorCPFCNPJUra',
            'ConsultarClientePorCPFCNPJUraResponse' => '\\StructType\\ConsultarClientePorCPFCNPJUraResponse',
            'ConsultarCredoresDoClienteUra' => '\\StructType\\ConsultarCredoresDoClienteUra',
            'ConsultarCredoresDoClienteUraResponse' => '\\StructType\\ConsultarCredoresDoClienteUraResponse',
            'ConsultarContratoClienteUra' => '\\StructType\\ConsultarContratoClienteUra',
            'ConsultarContratoClienteUraResponse' => '\\StructType\\ConsultarContratoClienteUraResponse',
            'ConsultarFormaPagamentoUra' => '\\StructType\\ConsultarFormaPagamentoUra',
            'ConsultarFormaPagamentoUraResponse' => '\\StructType\\ConsultarFormaPagamentoUraResponse',
            'CalculoUra' => '\\StructType\\CalculoUra',
            'CalculoUraResponse' => '\\StructType\\CalculoUraResponse',
            'GerarAcordoUra' => '\\StructType\\GerarAcordoUra',
            'GerarAcordoUraResponse' => '\\StructType\\GerarAcordoUraResponse',
            'ImprimeTermoAcordoKrotonUra' => '\\StructType\\ImprimeTermoAcordoKrotonUra',
            'ImprimeTermoAcordoKrotonUraResponse' => '\\StructType\\ImprimeTermoAcordoKrotonUraResponse',
            'EnviaCheckoutUra' => '\\StructType\\EnviaCheckoutUra',
            'EnviaCheckoutUraResponse' => '\\StructType\\EnviaCheckoutUraResponse',
            'EnviaBoletoUra' => '\\StructType\\EnviaBoletoUra',
            'EnviaBoletoUraResponse' => '\\StructType\\EnviaBoletoUraResponse',
            'EmitirBoletoUra' => '\\StructType\\EmitirBoletoUra',
            'EmitirBoletoUraResponse' => '\\StructType\\EmitirBoletoUraResponse',
            'ConsultarDadosClienteCobChat' => '\\StructType\\ConsultarDadosClienteCobChat',
            'ConsultarDadosClienteCobChatResponse' => '\\StructType\\ConsultarDadosClienteCobChatResponse',
            'EnviaBoletoTermoUra' => '\\StructType\\EnviaBoletoTermoUra',
            'EnviaBoletoTermoUraResponse' => '\\StructType\\EnviaBoletoTermoUraResponse',
            'EnviaCodigoAcessoCobchat' => '\\StructType\\EnviaCodigoAcessoCobchat',
            'EnviaCodigoAcessoCobchatResponse' => '\\StructType\\EnviaCodigoAcessoCobchatResponse',
            'HealthCheckRoute' => '\\StructType\\HealthCheckRoute',
            'HealthCheckRouteResponse' => '\\StructType\\HealthCheckRouteResponse',
            'GetToken' => '\\StructType\\GetToken',
            'GetTokenResponse' => '\\StructType\\GetTokenResponse',
            'ConsultarAssessoriaPorURL' => '\\StructType\\ConsultarAssessoriaPorURL',
            'ConsultarAssessoriaPorURLResponse' => '\\StructType\\ConsultarAssessoriaPorURLResponse',
            'ConsultaDadosCheckout' => '\\StructType\\ConsultaDadosCheckout',
            'ConsultaDadosCheckoutResponse' => '\\StructType\\ConsultaDadosCheckoutResponse',
            'ConsultarDadosPix' => '\\StructType\\ConsultarDadosPix',
            'ConsultarDadosPixResponse' => '\\StructType\\ConsultarDadosPixResponse',
            'ConsultaURLCheckout' => '\\StructType\\ConsultaURLCheckout',
            'ConsultaURLCheckoutResponse' => '\\StructType\\ConsultaURLCheckoutResponse',
            'ConsultaURLCheckoutCobChat' => '\\StructType\\ConsultaURLCheckoutCobChat',
            'ConsultaURLCheckoutCobChatResponse' => '\\StructType\\ConsultaURLCheckoutCobChatResponse',
            'ConsultaPixCobChat' => '\\StructType\\ConsultaPixCobChat',
            'ConsultaPixCobChatResponse' => '\\StructType\\ConsultaPixCobChatResponse',
            'EnviaCheckoutCobChat' => '\\StructType\\EnviaCheckoutCobChat',
            'EnviaCheckoutCobChatResponse' => '\\StructType\\EnviaCheckoutCobChatResponse',
            'EnviaPixCobChat' => '\\StructType\\EnviaPixCobChat',
            'EnviaPixCobChatResponse' => '\\StructType\\EnviaPixCobChatResponse',
            'IncluirConversa' => '\\StructType\\IncluirConversa',
            'IncluirConversaResponse' => '\\StructType\\IncluirConversaResponse',
            'SalvarPagamentoCheckout' => '\\StructType\\SalvarPagamentoCheckout',
            'SalvarPagamentoCheckoutResponse' => '\\StructType\\SalvarPagamentoCheckoutResponse',
            'SalvarPagamentoPreTransacao' => '\\StructType\\SalvarPagamentoPreTransacao',
            'SalvarPagamentoPreTransacaoResponse' => '\\StructType\\SalvarPagamentoPreTransacaoResponse',
            'AlterarSituacaoCheckout' => '\\StructType\\AlterarSituacaoCheckout',
            'AlterarSituacaoCheckoutResponse' => '\\StructType\\AlterarSituacaoCheckoutResponse',
            'ConcluirCheckoutPosTransacao' => '\\StructType\\ConcluirCheckoutPosTransacao',
            'ConcluirCheckoutPosTransacaoResponse' => '\\StructType\\ConcluirCheckoutPosTransacaoResponse',
            'EstornarPagamentoCheckout' => '\\StructType\\EstornarPagamentoCheckout',
            'EstornarPagamentoCheckoutResponse' => '\\StructType\\EstornarPagamentoCheckoutResponse',
            'EventoEmailAlertaErroCheckout' => '\\StructType\\EventoEmailAlertaErroCheckout',
            'EventoEmailAlertaErroCheckoutResponse' => '\\StructType\\EventoEmailAlertaErroCheckoutResponse',
            'ConcluirCheckout' => '\\StructType\\ConcluirCheckout',
            'ConcluirCheckoutResponse' => '\\StructType\\ConcluirCheckoutResponse',
            'SalvarEventoRecusadoCheckout' => '\\StructType\\SalvarEventoRecusadoCheckout',
            'SalvarEventoRecusadoCheckoutResponse' => '\\StructType\\SalvarEventoRecusadoCheckoutResponse',
            'IncluirEventoChekout' => '\\StructType\\IncluirEventoChekout',
            'IncluirEventoChekoutResponse' => '\\StructType\\IncluirEventoChekoutResponse',
            'ConsultarAssessoriaPorURLCheckout' => '\\StructType\\ConsultarAssessoriaPorURLCheckout',
            'ConsultarAssessoriaPorURLCheckoutResponse' => '\\StructType\\ConsultarAssessoriaPorURLCheckoutResponse',
            'ConsultarAssessoriaPorAcordo' => '\\StructType\\ConsultarAssessoriaPorAcordo',
            'ConsultarAssessoriaPorAcordoResponse' => '\\StructType\\ConsultarAssessoriaPorAcordoResponse',
            'ConsultarAssessoriaPorPixCheckout' => '\\StructType\\ConsultarAssessoriaPorPixCheckout',
            'ConsultarAssessoriaPorPixCheckoutResponse' => '\\StructType\\ConsultarAssessoriaPorPixCheckoutResponse',
            'ConsultarPortalIntegracao' => '\\StructType\\ConsultarPortalIntegracao',
            'ConsultarPortalIntegracaoResponse' => '\\StructType\\ConsultarPortalIntegracaoResponse',
            'ConsultarPortalParametro' => '\\StructType\\ConsultarPortalParametro',
            'ConsultarPortalParametroResponse' => '\\StructType\\ConsultarPortalParametroResponse',
            'LoginPortal' => '\\StructType\\LoginPortal',
            'LoginPortalResponse' => '\\StructType\\LoginPortalResponse',
            'LoginRedirect' => '\\StructType\\LoginRedirect',
            'LoginRedirectResponse' => '\\StructType\\LoginRedirectResponse',
            'ListarEstados' => '\\StructType\\ListarEstados',
            'ListarEstadosResponse' => '\\StructType\\ListarEstadosResponse',
            'ListarCidades' => '\\StructType\\ListarCidades',
            'ListarCidadesResponse' => '\\StructType\\ListarCidadesResponse',
            'ConsultarCredoresDoCliente' => '\\StructType\\ConsultarCredoresDoCliente',
            'ConsultarCredoresDoClienteResponse' => '\\StructType\\ConsultarCredoresDoClienteResponse',
            'ConsultarContratoCliente' => '\\StructType\\ConsultarContratoCliente',
            'ConsultarContratoClienteResponse' => '\\StructType\\ConsultarContratoClienteResponse',
            'GetCartaoParametrosIntegracao' => '\\StructType\\GetCartaoParametrosIntegracao',
            'GetCartaoParametrosIntegracaoResponse' => '\\StructType\\GetCartaoParametrosIntegracaoResponse',
            'GetCartaoParametrosIntegracaoPorId' => '\\StructType\\GetCartaoParametrosIntegracaoPorId',
            'GetCartaoParametrosIntegracaoPorIdResponse' => '\\StructType\\GetCartaoParametrosIntegracaoPorIdResponse',
            'SolicitaContato' => '\\StructType\\SolicitaContato',
            'SolicitaContatoResponse' => '\\StructType\\SolicitaContatoResponse',
            'CadastraProposta' => '\\StructType\\CadastraProposta',
            'CadastraPropostaResponse' => '\\StructType\\CadastraPropostaResponse',
            'GerarAcordoPortal' => '\\StructType\\GerarAcordoPortal',
            'GerarAcordoPortalResponse' => '\\StructType\\GerarAcordoPortalResponse',
            'RecuperarPlanosPortal' => '\\StructType\\RecuperarPlanosPortal',
            'RecuperarPlanosPortalResponse' => '\\StructType\\RecuperarPlanosPortalResponse',
            'CalculoPortal' => '\\StructType\\CalculoPortal',
            'CalculoCobChat' => '\\StructType\\CalculoCobChat',
            'CalculoCobChatResponse' => '\\StructType\\CalculoCobChatResponse',
            'ImprimeTermoAcordo' => '\\StructType\\ImprimeTermoAcordo',
            'ImprimeTermoAcordoResponse' => '\\StructType\\ImprimeTermoAcordoResponse',
            'EmitirBoleto' => '\\StructType\\EmitirBoleto',
            'EmitirBoletoResponse' => '\\StructType\\EmitirBoletoResponse',
            'EmitirBoletoCobChat' => '\\StructType\\EmitirBoletoCobChat',
            'EmitirBoletoCobChatResponse' => '\\StructType\\EmitirBoletoCobChatResponse',
            'EmitirBoletoPortal' => '\\StructType\\EmitirBoletoPortal',
            'EmitirBoletoPortalResponse' => '\\StructType\\EmitirBoletoPortalResponse',
            'EmitirBoletoPortalV2' => '\\StructType\\EmitirBoletoPortalV2',
            'EmitirBoletoPortalV2Response' => '\\StructType\\EmitirBoletoPortalV2Response',
            'GravaLogPortal' => '\\StructType\\GravaLogPortal',
            'GravaLogPortalResponse' => '\\StructType\\GravaLogPortalResponse',
            'ConsultaParcelasAbertas30dias' => '\\StructType\\ConsultaParcelasAbertas30dias',
            'ConsultaParcelasAbertas30diasResponse' => '\\StructType\\ConsultaParcelasAbertas30diasResponse',
            'ConsultaParcelasAbertasPortal' => '\\StructType\\ConsultaParcelasAbertasPortal',
            'ConsultaParcelasAbertasPortalResponse' => '\\StructType\\ConsultaParcelasAbertasPortalResponse',
            'ConsultarContratoCampoPortal' => '\\StructType\\ConsultarContratoCampoPortal',
            'ConsultarContratoCampoPortalResponse' => '\\StructType\\ConsultarContratoCampoPortalResponse',
            'ConsultarAcordosEmAndamentoPorCliente' => '\\StructType\\ConsultarAcordosEmAndamentoPorCliente',
            'ConsultarAcordosEmAndamentoPorClienteResponse' => '\\StructType\\ConsultarAcordosEmAndamentoPorClienteResponse',
            'ConsultarAcordosEmAndamentoPorClientePortal' => '\\StructType\\ConsultarAcordosEmAndamentoPorClientePortal',
            'ConsultarAcordosEmAndamentoPorClientePortalResponse' => '\\StructType\\ConsultarAcordosEmAndamentoPorClientePortalResponse',
            'EnviaBoleto' => '\\StructType\\EnviaBoleto',
            'EnviaBoletoResponse' => '\\StructType\\EnviaBoletoResponse',
            'ConsultarAcordosFinalizadosPorCliente' => '\\StructType\\ConsultarAcordosFinalizadosPorCliente',
            'ConsultarAcordosFinalizadosPorClienteResponse' => '\\StructType\\ConsultarAcordosFinalizadosPorClienteResponse',
            'ConsultarAcordosFinalizadosPorClientePortal' => '\\StructType\\ConsultarAcordosFinalizadosPorClientePortal',
            'ConsultarAcordosFinalizadosPorClientePortalResponse' => '\\StructType\\ConsultarAcordosFinalizadosPorClientePortalResponse',
            'ConsultarAcordosEmAndamentoPorCPFCNPJ' => '\\StructType\\ConsultarAcordosEmAndamentoPorCPFCNPJ',
            'ConsultarAcordosEmAndamentoPorCPFCNPJResponse' => '\\StructType\\ConsultarAcordosEmAndamentoPorCPFCNPJResponse',
            'ConsultarAcordosFinalizadosPorCPFCNPJ' => '\\StructType\\ConsultarAcordosFinalizadosPorCPFCNPJ',
            'ConsultarAcordosFinalizadosPorCPFCNPJResponse' => '\\StructType\\ConsultarAcordosFinalizadosPorCPFCNPJResponse',
            'ConsultarTodosAcordosPorClientePortal' => '\\StructType\\ConsultarTodosAcordosPorClientePortal',
            'ConsultarTodosAcordosPorClientePortalResponse' => '\\StructType\\ConsultarTodosAcordosPorClientePortalResponse',
            'ValidaToken' => '\\StructType\\ValidaToken',
            'ValidaTokenResponse' => '\\StructType\\ValidaTokenResponse',
            'EnviaCodigoViaSMS' => '\\StructType\\EnviaCodigoViaSMS',
            'EnviaCodigoViaSMSResponse' => '\\StructType\\EnviaCodigoViaSMSResponse',
            'EnviaCodigoViaEmail' => '\\StructType\\EnviaCodigoViaEmail',
            'EnviaCodigoViaEmailResponse' => '\\StructType\\EnviaCodigoViaEmailResponse',
            'AtualizarDadosCadastrais' => '\\StructType\\AtualizarDadosCadastrais',
            'AtualizarDadosCadastraisResponse' => '\\StructType\\AtualizarDadosCadastraisResponse',
            'SalvarCliente' => '\\StructType\\SalvarCliente',
            'SalvarClienteResponse' => '\\StructType\\SalvarClienteResponse',
            'ContratosDistribuidos' => '\\StructType\\ContratosDistribuidos',
            'ContratosDistribuidosPorData' => '\\StructType\\ContratosDistribuidosPorData',
            'ContratosDistribuidosPorDataResponse' => '\\StructType\\ContratosDistribuidosPorDataResponse',
            'DevolverContratoPorPagamentos' => '\\StructType\\DevolverContratoPorPagamentos',
            'DevolverContratoPorPagamentosResponse' => '\\StructType\\DevolverContratoPorPagamentosResponse',
            'DevolverContratoPorPagamentoDireto' => '\\StructType\\DevolverContratoPorPagamentoDireto',
            'DevolverContratoPorPagamentoDiretoResponse' => '\\StructType\\DevolverContratoPorPagamentoDiretoResponse',
            'DevolverContrato' => '\\StructType\\DevolverContrato',
            'DevolverContratoResponse' => '\\StructType\\DevolverContratoResponse',
            'DevolverContratoMotivo' => '\\StructType\\DevolverContratoMotivo',
            'DevolverContratoMotivoResponse' => '\\StructType\\DevolverContratoMotivoResponse',
            'DevolverContratoPorDevolucoesParciais' => '\\StructType\\DevolverContratoPorDevolucoesParciais',
            'DevolverContratoPorDevolucoesParciaisResponse' => '\\StructType\\DevolverContratoPorDevolucoesParciaisResponse',
            'PagarAcordoPorParcela' => '\\StructType\\PagarAcordoPorParcela',
            'PagarAcordoPorParcelaResponse' => '\\StructType\\PagarAcordoPorParcelaResponse',
            'PagarAcordo' => '\\StructType\\PagarAcordo',
            'PagarAcordoResponse' => '\\StructType\\PagarAcordoResponse',
            'ConsultarClientePortalPorCPFCNPJ' => '\\StructType\\ConsultarClientePortalPorCPFCNPJ',
            'ConsultarClientePortalPorCPFCNPJResponse' => '\\StructType\\ConsultarClientePortalPorCPFCNPJResponse',
            'ConsultarClientePorCPFCNPJ' => '\\StructType\\ConsultarClientePorCPFCNPJ',
            'ConsultarClientePorCPFCNPJResponse' => '\\StructType\\ConsultarClientePorCPFCNPJResponse',
            'ConsultarClientePorTelefone' => '\\StructType\\ConsultarClientePorTelefone',
            'ConsultarClientePorTelefoneResponse' => '\\StructType\\ConsultarClientePorTelefoneResponse',
            'ConsultarClienteDiscador' => '\\StructType\\ConsultarClienteDiscador',
            'ConsultarClienteDiscadorResponse' => '\\StructType\\ConsultarClienteDiscadorResponse',
            'ConsultarCliente' => '\\StructType\\ConsultarCliente',
            'ConsultarClienteResponse' => '\\StructType\\ConsultarClienteResponse',
            'ConsultarClientes' => '\\StructType\\ConsultarClientes',
            'ConsultarClientesResponse' => '\\StructType\\ConsultarClientesResponse',
            'ConsultarContratos' => '\\StructType\\ConsultarContratos',
            'ConsultarContratosResponse' => '\\StructType\\ConsultarContratosResponse',
            'ConsultaContratosMarcador' => '\\StructType\\ConsultaContratosMarcador',
            'ConsultaContratosMarcadorResponse' => '\\StructType\\ConsultaContratosMarcadorResponse',
            'ConsultarAcordos' => '\\StructType\\ConsultarAcordos',
            'ConsultarAcordosResponse' => '\\StructType\\ConsultarAcordosResponse',
            'ConsultarAcordosPorDataAlteracao' => '\\StructType\\ConsultarAcordosPorDataAlteracao',
            'ConsultarAcordosPorDataAlteracaoResponse' => '\\StructType\\ConsultarAcordosPorDataAlteracaoResponse',
            'ConsultarEventos' => '\\StructType\\ConsultarEventos',
            'ConsultarEventosResponse' => '\\StructType\\ConsultarEventosResponse',
            'IncluirBoletos' => '\\StructType\\IncluirBoletos',
            'IncluirBoletosResponse' => '\\StructType\\IncluirBoletosResponse',
            'IncluirSPC' => '\\StructType\\IncluirSPC',
            'IncluirSPCResponse' => '\\StructType\\IncluirSPCResponse',
            'RemoverSPC' => '\\StructType\\RemoverSPC',
            'RemoverSPCResponse' => '\\StructType\\RemoverSPCResponse',
            'IncluirEvento' => '\\StructType\\IncluirEvento',
            'IncluirEventoResponse' => '\\StructType\\IncluirEventoResponse',
            'IncluirCanaisdeAtendimentoPorCPFCNPJ' => '\\StructType\\IncluirCanaisdeAtendimentoPorCPFCNPJ',
            'IncluirCanaisdeAtendimentoPorCPFCNPJResponse' => '\\StructType\\IncluirCanaisdeAtendimentoPorCPFCNPJResponse',
            'IncluirAcordo' => '\\StructType\\IncluirAcordo',
            'IncluirAcordoResponse' => '\\StructType\\IncluirAcordoResponse',
            'SalvarAcordo' => '\\StructType\\SalvarAcordo',
            'SalvarAcordoResponse' => '\\StructType\\SalvarAcordoResponse',
            'SuspenderCobranca' => '\\StructType\\SuspenderCobranca',
            'SuspenderCobrancaResponse' => '\\StructType\\SuspenderCobrancaResponse',
            'ReativarCobranca' => '\\StructType\\ReativarCobranca',
            'ReativarCobrancaResponse' => '\\StructType\\ReativarCobrancaResponse',
            'ReabrirContrato' => '\\StructType\\ReabrirContrato',
            'ReabrirContratoResponse' => '\\StructType\\ReabrirContratoResponse',
            'EstornarPagamento' => '\\StructType\\EstornarPagamento',
            'EstornarPagamentoResponse' => '\\StructType\\EstornarPagamentoResponse',
            'ConsultarPagamentos' => '\\StructType\\ConsultarPagamentos',
            'ConsultarPagamentosResponse' => '\\StructType\\ConsultarPagamentosResponse',
            'ConsultarPagamentosOperador' => '\\StructType\\ConsultarPagamentosOperador',
            'ConsultarPagamentosOperadorResponse' => '\\StructType\\ConsultarPagamentosOperadorResponse',
            'ConsultarPagamentosRenegociacao' => '\\StructType\\ConsultarPagamentosRenegociacao',
            'ConsultarPagamentosRenegociacaoResponse' => '\\StructType\\ConsultarPagamentosRenegociacaoResponse',
            'ConsultarBoletos' => '\\StructType\\ConsultarBoletos',
            'ConsultarBoletosResponse' => '\\StructType\\ConsultarBoletosResponse',
            'QuebrarAcordo' => '\\StructType\\QuebrarAcordo',
            'QuebrarAcordoResponse' => '\\StructType\\QuebrarAcordoResponse',
            'ConsultarQuebraAcordos' => '\\StructType\\ConsultarQuebraAcordos',
            'ConsultarQuebraAcordosResponse' => '\\StructType\\ConsultarQuebraAcordosResponse',
            'ConsultarNossoNumero' => '\\StructType\\ConsultarNossoNumero',
            'ConsultarNossoNumeroResponse' => '\\StructType\\ConsultarNossoNumeroResponse',
            'IncluirContrato' => '\\StructType\\IncluirContrato',
            'IncluirContratoResponse' => '\\StructType\\IncluirContratoResponse',
            'IncluirEmail' => '\\StructType\\IncluirEmail',
            'IncluirEmailResponse' => '\\StructType\\IncluirEmailResponse',
            'IncluirTelefone' => '\\StructType\\IncluirTelefone',
            'IncluirTelefoneResponse' => '\\StructType\\IncluirTelefoneResponse',
            'IncluirEndereco' => '\\StructType\\IncluirEndereco',
            'IncluirEnderecoResponse' => '\\StructType\\IncluirEnderecoResponse',
            'GetConfigCredor' => '\\StructType\\GetConfigCredor',
            'GetConfigCredorResponse' => '\\StructType\\GetConfigCredorResponse',
            'ConsultaBoletosOriginais' => '\\StructType\\ConsultaBoletosOriginais',
            'ConsultaBoletosOriginaisResponse' => '\\StructType\\ConsultaBoletosOriginaisResponse',
            'ConsultarAtualizacaoCadastral' => '\\StructType\\ConsultarAtualizacaoCadastral',
            'ConsultarAtualizacaoCadastralResponse' => '\\StructType\\ConsultarAtualizacaoCadastralResponse',
            'CheckOutLog' => '\\StructType\\CheckOutLog',
            'CheckOutLogResponse' => '\\StructType\\CheckOutLogResponse',
            'ConsultarIntegracaoGateway' => '\\StructType\\ConsultarIntegracaoGateway',
            'ConsultarIntegracaoGatewayResponse' => '\\StructType\\ConsultarIntegracaoGatewayResponse',
            'ConsultarFormaPagamentoCobChat' => '\\StructType\\ConsultarFormaPagamentoCobChat',
            'ConsultarFormaPagamentoCobChatResponse' => '\\StructType\\ConsultarFormaPagamentoCobChatResponse',
            'AlterarNumeroAcordo' => '\\StructType\\AlterarNumeroAcordo',
            'AlterarNumeroAcordoResponse' => '\\StructType\\AlterarNumeroAcordoResponse',
            'AlterarNumeroContratoAcordo' => '\\StructType\\AlterarNumeroContratoAcordo',
            'AlterarNumeroContratoAcordoResponse' => '\\StructType\\AlterarNumeroContratoAcordoResponse',
            'AlterarNumeroParcelaAcordo' => '\\StructType\\AlterarNumeroParcelaAcordo',
            'RecuperarBinsElo' => '\\StructType\\RecuperarBinsElo',
            'RecuperarBinsEloResponse' => '\\StructType\\RecuperarBinsEloResponse',
            'EmitirBoletoApi' => '\\StructType\\EmitirBoletoApi',
            'EmitirBoletoApiResponse' => '\\StructType\\EmitirBoletoApiResponse',
            'EmitirBoleto2ViaApi' => '\\StructType\\EmitirBoleto2ViaApi',
            'EmitirBoleto2ViaApiResponse' => '\\StructType\\EmitirBoleto2ViaApiResponse',
            'VerificarAprovacaoAcordosPortal' => '\\StructType\\VerificarAprovacaoAcordosPortal',
            'VerificarAprovacaoAcordosPortalResponse' => '\\StructType\\VerificarAprovacaoAcordosPortalResponse',
            'VerificarBloqueioImpressaoBoletoConfigPortal' => '\\StructType\\VerificarBloqueioImpressaoBoletoConfigPortal',
            'VerificarBloqueioImpressaoBoletoConfigPortalResponse' => '\\StructType\\VerificarBloqueioImpressaoBoletoConfigPortalResponse',
            'ConsultarFiliaisKrotonPortal' => '\\StructType\\ConsultarFiliaisKrotonPortal',
            'ConsultarFiliaisKrotonPortalResponse' => '\\StructType\\ConsultarFiliaisKrotonPortalResponse',
            'ConsultarFilialKrotonDoContratoPortal' => '\\StructType\\ConsultarFilialKrotonDoContratoPortal',
            'ConsultarFilialKrotonDoContratoPortalResponse' => '\\StructType\\ConsultarFilialKrotonDoContratoPortalResponse',
            'ImprimeTermoAcordoKrotonPortal' => '\\StructType\\ImprimeTermoAcordoKrotonPortal',
            'ImprimeTermoAcordoKrotonPortalResponse' => '\\StructType\\ImprimeTermoAcordoKrotonPortalResponse',
            'ImprimeCertificadoDeAceiteKrotonPortal' => '\\StructType\\ImprimeCertificadoDeAceiteKrotonPortal',
            'ImprimeCertificadoDeAceiteKrotonPortalResponse' => '\\StructType\\ImprimeCertificadoDeAceiteKrotonPortalResponse',
            'LoginCobChat' => '\\StructType\\LoginCobChat',
            'LoginCobChatResponse' => '\\StructType\\LoginCobChatResponse',
            'ConsultaParcelasAbertasCobChat' => '\\StructType\\ConsultaParcelasAbertasCobChat',
            'ConsultaParcelasAbertasCobChatResponse' => '\\StructType\\ConsultaParcelasAbertasCobChatResponse',
            'ConsultarIntegracaoCobChat' => '\\StructType\\ConsultarIntegracaoCobChat',
            'ConsultarIntegracaoCobChatResponse' => '\\StructType\\ConsultarIntegracaoCobChatResponse',
            'ConsultarTodosAcordosPorClienteCobChat' => '\\StructType\\ConsultarTodosAcordosPorClienteCobChat',
            'ConsultarTodosAcordosPorClienteCobChatResponse' => '\\StructType\\ConsultarTodosAcordosPorClienteCobChatResponse',
            'ConsultarAcordosEmAndamentoPorClienteCobChat' => '\\StructType\\ConsultarAcordosEmAndamentoPorClienteCobChat',
            'ConsultarAcordosEmAndamentoPorClienteCobChatResponse' => '\\StructType\\ConsultarAcordosEmAndamentoPorClienteCobChatResponse',
            'ConsultarContratoClienteCobChat' => '\\StructType\\ConsultarContratoClienteCobChat',
            'ConsultarContratoClienteCobChatResponse' => '\\StructType\\ConsultarContratoClienteCobChatResponse',
            'ConsultarCredoresDoClienteCobChat' => '\\StructType\\ConsultarCredoresDoClienteCobChat',
            'ConsultarCredoresDoClienteCobChatResponse' => '\\StructType\\ConsultarCredoresDoClienteCobChatResponse',
            'ConsultarClientePorCPFCNPJCobChat' => '\\StructType\\ConsultarClientePorCPFCNPJCobChat',
            'ConsultarClientePorCPFCNPJCobChatResponse' => '\\StructType\\ConsultarClientePorCPFCNPJCobChatResponse',
        );
    }
}
