<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEnderecoRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEnderecoRequest
 * @subpackage Arrays
 */
class ArrayOfEnderecoRequest extends AbstractStructArrayBase
{
    /**
     * The EnderecoRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EnderecoRequest[]
     */
    public $EnderecoRequest;
    /**
     * Constructor method for ArrayOfEnderecoRequest
     * @uses ArrayOfEnderecoRequest::setEnderecoRequest()
     * @param \StructType\EnderecoRequest[] $enderecoRequest
     */
    public function __construct(array $enderecoRequest = array())
    {
        $this
            ->setEnderecoRequest($enderecoRequest);
    }
    /**
     * Get EnderecoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EnderecoRequest[]|null
     */
    public function getEnderecoRequest()
    {
        return isset($this->EnderecoRequest) ? $this->EnderecoRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEnderecoRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnderecoRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnderecoRequestForArrayConstraintsFromSetEnderecoRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEnderecoRequestEnderecoRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfEnderecoRequestEnderecoRequestItem instanceof \StructType\EnderecoRequest) {
                $invalidValues[] = is_object($arrayOfEnderecoRequestEnderecoRequestItem) ? get_class($arrayOfEnderecoRequestEnderecoRequestItem) : sprintf('%s(%s)', gettype($arrayOfEnderecoRequestEnderecoRequestItem), var_export($arrayOfEnderecoRequestEnderecoRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EnderecoRequest property can only contain items of type \StructType\EnderecoRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EnderecoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EnderecoRequest[] $enderecoRequest
     * @return \ArrayType\ArrayOfEnderecoRequest
     */
    public function setEnderecoRequest(array $enderecoRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($enderecoRequestArrayErrorMessage = self::validateEnderecoRequestForArrayConstraintsFromSetEnderecoRequest($enderecoRequest))) {
            throw new \InvalidArgumentException($enderecoRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($enderecoRequest) || (is_array($enderecoRequest) && empty($enderecoRequest))) {
            unset($this->EnderecoRequest);
        } else {
            $this->EnderecoRequest = $enderecoRequest;
        }
        return $this;
    }
    /**
     * Add item to EnderecoRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\EnderecoRequest $item
     * @return \ArrayType\ArrayOfEnderecoRequest
     */
    public function addToEnderecoRequest(\StructType\EnderecoRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EnderecoRequest) {
            throw new \InvalidArgumentException(sprintf('The EnderecoRequest property can only contain items of type \StructType\EnderecoRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EnderecoRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EnderecoRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EnderecoRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EnderecoRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EnderecoRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EnderecoRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EnderecoRequest
     */
    public function getAttributeName()
    {
        return 'EnderecoRequest';
    }
}
