<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmailResponse ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEmailResponse
 * @subpackage Arrays
 */
class ArrayOfEmailResponse extends AbstractStructArrayBase
{
    /**
     * The EmailResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailResponse[]
     */
    public $EmailResponse;
    /**
     * Constructor method for ArrayOfEmailResponse
     * @uses ArrayOfEmailResponse::setEmailResponse()
     * @param \StructType\EmailResponse[] $emailResponse
     */
    public function __construct(array $emailResponse = array())
    {
        $this
            ->setEmailResponse($emailResponse);
    }
    /**
     * Get EmailResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailResponse[]|null
     */
    public function getEmailResponse()
    {
        return isset($this->EmailResponse) ? $this->EmailResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailResponseForArrayConstraintsFromSetEmailResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEmailResponseEmailResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmailResponseEmailResponseItem instanceof \StructType\EmailResponse) {
                $invalidValues[] = is_object($arrayOfEmailResponseEmailResponseItem) ? get_class($arrayOfEmailResponseEmailResponseItem) : sprintf('%s(%s)', gettype($arrayOfEmailResponseEmailResponseItem), var_export($arrayOfEmailResponseEmailResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailResponse property can only contain items of type \StructType\EmailResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmailResponse[] $emailResponse
     * @return \ArrayType\ArrayOfEmailResponse
     */
    public function setEmailResponse(array $emailResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($emailResponseArrayErrorMessage = self::validateEmailResponseForArrayConstraintsFromSetEmailResponse($emailResponse))) {
            throw new \InvalidArgumentException($emailResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($emailResponse) || (is_array($emailResponse) && empty($emailResponse))) {
            unset($this->EmailResponse);
        } else {
            $this->EmailResponse = $emailResponse;
        }
        return $this;
    }
    /**
     * Add item to EmailResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailResponse $item
     * @return \ArrayType\ArrayOfEmailResponse
     */
    public function addToEmailResponse(\StructType\EmailResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailResponse) {
            throw new \InvalidArgumentException(sprintf('The EmailResponse property can only contain items of type \StructType\EmailResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EmailResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EmailResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EmailResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EmailResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EmailResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EmailResponse
     */
    public function getAttributeName()
    {
        return 'EmailResponse';
    }
}
