<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmailRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEmailRequest
 * @subpackage Arrays
 */
class ArrayOfEmailRequest extends AbstractStructArrayBase
{
    /**
     * The EmailRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailRequest[]
     */
    public $EmailRequest;
    /**
     * Constructor method for ArrayOfEmailRequest
     * @uses ArrayOfEmailRequest::setEmailRequest()
     * @param \StructType\EmailRequest[] $emailRequest
     */
    public function __construct(array $emailRequest = array())
    {
        $this
            ->setEmailRequest($emailRequest);
    }
    /**
     * Get EmailRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailRequest[]|null
     */
    public function getEmailRequest()
    {
        return isset($this->EmailRequest) ? $this->EmailRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmailRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmailRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailRequestForArrayConstraintsFromSetEmailRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEmailRequestEmailRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmailRequestEmailRequestItem instanceof \StructType\EmailRequest) {
                $invalidValues[] = is_object($arrayOfEmailRequestEmailRequestItem) ? get_class($arrayOfEmailRequestEmailRequestItem) : sprintf('%s(%s)', gettype($arrayOfEmailRequestEmailRequestItem), var_export($arrayOfEmailRequestEmailRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EmailRequest property can only contain items of type \StructType\EmailRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EmailRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmailRequest[] $emailRequest
     * @return \ArrayType\ArrayOfEmailRequest
     */
    public function setEmailRequest(array $emailRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($emailRequestArrayErrorMessage = self::validateEmailRequestForArrayConstraintsFromSetEmailRequest($emailRequest))) {
            throw new \InvalidArgumentException($emailRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($emailRequest) || (is_array($emailRequest) && empty($emailRequest))) {
            unset($this->EmailRequest);
        } else {
            $this->EmailRequest = $emailRequest;
        }
        return $this;
    }
    /**
     * Add item to EmailRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\EmailRequest $item
     * @return \ArrayType\ArrayOfEmailRequest
     */
    public function addToEmailRequest(\StructType\EmailRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmailRequest) {
            throw new \InvalidArgumentException(sprintf('The EmailRequest property can only contain items of type \StructType\EmailRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EmailRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EmailRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EmailRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EmailRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EmailRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EmailRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EmailRequest
     */
    public function getAttributeName()
    {
        return 'EmailRequest';
    }
}
