<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContratoRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContratoRequest
 * @subpackage Arrays
 */
class ArrayOfContratoRequest extends AbstractStructArrayBase
{
    /**
     * The ContratoRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContratoRequest[]
     */
    public $ContratoRequest;
    /**
     * Constructor method for ArrayOfContratoRequest
     * @uses ArrayOfContratoRequest::setContratoRequest()
     * @param \StructType\ContratoRequest[] $contratoRequest
     */
    public function __construct(array $contratoRequest = array())
    {
        $this
            ->setContratoRequest($contratoRequest);
    }
    /**
     * Get ContratoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContratoRequest[]|null
     */
    public function getContratoRequest()
    {
        return isset($this->ContratoRequest) ? $this->ContratoRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContratoRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContratoRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContratoRequestForArrayConstraintsFromSetContratoRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfContratoRequestContratoRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfContratoRequestContratoRequestItem instanceof \StructType\ContratoRequest) {
                $invalidValues[] = is_object($arrayOfContratoRequestContratoRequestItem) ? get_class($arrayOfContratoRequestContratoRequestItem) : sprintf('%s(%s)', gettype($arrayOfContratoRequestContratoRequestItem), var_export($arrayOfContratoRequestContratoRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContratoRequest property can only contain items of type \StructType\ContratoRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContratoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContratoRequest[] $contratoRequest
     * @return \ArrayType\ArrayOfContratoRequest
     */
    public function setContratoRequest(array $contratoRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($contratoRequestArrayErrorMessage = self::validateContratoRequestForArrayConstraintsFromSetContratoRequest($contratoRequest))) {
            throw new \InvalidArgumentException($contratoRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($contratoRequest) || (is_array($contratoRequest) && empty($contratoRequest))) {
            unset($this->ContratoRequest);
        } else {
            $this->ContratoRequest = $contratoRequest;
        }
        return $this;
    }
    /**
     * Add item to ContratoRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ContratoRequest $item
     * @return \ArrayType\ArrayOfContratoRequest
     */
    public function addToContratoRequest(\StructType\ContratoRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContratoRequest) {
            throw new \InvalidArgumentException(sprintf('The ContratoRequest property can only contain items of type \StructType\ContratoRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContratoRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContratoRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContratoRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContratoRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContratoRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContratoRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContratoRequest
     */
    public function getAttributeName()
    {
        return 'ContratoRequest';
    }
}
