<?php

namespace AgrioApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getInvoice
     * Meta information extracted from the WSDL
     * - documentation: Retourneren van de factuur.<BR> Op basis van het factuurnummer wordt de factuur opgezocht.<BR> Het relatienummer dient ter controle of het relatienummer bij het factuurnummer hoort.<BR> De factuur wordt geprint in PDF-formaat en
     * geretourneerd in Base64Binary formaat.error506: Er is geen relatie gevonden met het opgegeven relatienummererror507: Er is geen factuur gevonden met het opgegeven factuurnummererror508: De factuur en het opgegeven relatienummer horen niet bij
     * elkaarerror509: Voor de gekozen factuur kan geen layout bepaald wordenerror510: Er is een fout opgetreden bij het samenstellen van de PDF (--opgetreden fout--)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AgrioApiV6\StructType\GetInvoiceRequest $request_parameters
     * @return \AgrioApiV6\StructType\GetInvoiceResponse|bool
     */
    public function getInvoice(\AgrioApiV6\StructType\GetInvoiceRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getInvoice($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AgrioApiV6\StructType\GetInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
