<?php

namespace AgrioApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getInvoiceResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error510: Er is een fout opgetreden bij het samenstellen van de PDF (--opgetreden fout--) | error509: Voor de gekozen factuur kan geen layout bepaald worden | error508: De factuur en het opgegeven relatienummer horen niet bij elkaar
 * | error507: Er is geen factuur gevonden met het opgegeven factuurnummer | error506: Er is geen relatie gevonden met het opgegeven relatienummer
 * @subpackage Structs
 * @date 20240419 package
 */
class GetInvoiceResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The factuurBinary
     * Meta information extracted from the WSDL
     * - documentation: Base64Binary variant van de gegenereerde PDF van de factuur
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $factuurBinary;
    /**
     * Constructor method for getInvoiceResponse
     * @uses GetInvoiceResponse::setRequestTag()
     * @uses GetInvoiceResponse::setFactuurBinary()
     * @param string $requestTag
     * @param string $factuurBinary
     */
    public function __construct($requestTag = null, $factuurBinary = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setFactuurBinary($factuurBinary);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AgrioApiV6\StructType\GetInvoiceResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get factuurBinary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFactuurBinary()
    {
        return isset($this->factuurBinary) ? $this->factuurBinary : null;
    }
    /**
     * Set factuurBinary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $factuurBinary
     * @return \AgrioApiV6\StructType\GetInvoiceResponse
     */
    public function setFactuurBinary($factuurBinary = null)
    {
        // validation for constraint: string
        if (!is_null($factuurBinary) && !is_string($factuurBinary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factuurBinary, true), gettype($factuurBinary)), __LINE__);
        }
        if (is_null($factuurBinary) || (is_array($factuurBinary) && empty($factuurBinary))) {
            unset($this->factuurBinary);
        } else {
            $this->factuurBinary = $factuurBinary;
        }
        return $this;
    }
}
