<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \AbonnementApiV6\ClassMap::get(),
);
/**
 * Samples for Test ServiceType
 */
$test = new \AbonnementApiV6\ServiceType\Test($options);
/**
 * Sample call for testConnection operation/method
 */
if ($test->testConnection(new \AbonnementApiV6\StructType\TestConnectionRequest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \AbonnementApiV6\ServiceType\Get($options);
/**
 * Sample call for getUitgaveInfo operation/method
 */
if ($get->getUitgaveInfo(new \AbonnementApiV6\StructType\GetUitgaveInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAbonnementsoortInfo operation/method
 */
if ($get->getAbonnementsoortInfo(new \AbonnementApiV6\StructType\GetAbonnementsoortInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPakketInfo operation/method
 */
if ($get->getPakketInfo(new \AbonnementApiV6\StructType\GetPakketInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getActieInfo operation/method
 */
if ($get->getActieInfo(new \AbonnementApiV6\StructType\GetActieInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPropositieInfo operation/method
 */
if ($get->getPropositieInfo(new \AbonnementApiV6\StructType\GetPropositieInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAbonnementInfo operation/method
 */
if ($get->getAbonnementInfo(new \AbonnementApiV6\StructType\GetAbonnementInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSmartcodeByAboNo operation/method
 */
if ($get->getSmartcodeByAboNo(new \AbonnementApiV6\StructType\GetSmartcodeByAboNoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieAbosoortPrijs operation/method
 */
if ($get->getRelatieAbosoortPrijs(new \AbonnementApiV6\StructType\GetRelatieAbosoortPrijsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCalamiteitInfo operation/method
 */
if ($get->getCalamiteitInfo(new \AbonnementApiV6\StructType\GetCalamiteitInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCalamiteitInfoByPcHnr operation/method
 */
if ($get->getCalamiteitInfoByPcHnr(new \AbonnementApiV6\StructType\GetCalamiteitInfoByPcHnrRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHerkomstInfo operation/method
 */
if ($get->getHerkomstInfo(new \AbonnementApiV6\StructType\GetHerkomstInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSwitchProposities operation/method
 */
if ($get->getSwitchProposities(new \AbonnementApiV6\StructType\GetSwitchPropositiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLeverbareProductenInfo operation/method
 */
if ($get->getLeverbareProductenInfo(new \AbonnementApiV6\StructType\GetLeverbareProductenInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRolInfo operation/method
 */
if ($get->getRolInfo(new \AbonnementApiV6\StructType\GetRolInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLicentiehouders operation/method
 */
if ($get->getLicentiehouders(new \AbonnementApiV6\StructType\GetLicentiehoudersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFactSamenvatInfo operation/method
 */
if ($get->getFactSamenvatInfo(new \AbonnementApiV6\StructType\GetFactSamenvatInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getToekomstigeMutaties operation/method
 */
if ($get->getToekomstigeMutaties(new \AbonnementApiV6\StructType\GetToekomstigeMutatiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEdities operation/method
 */
if ($get->getEdities(new \AbonnementApiV6\StructType\GetEditiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEersteVerschijning operation/method
 */
if ($get->getEersteVerschijning(new \AbonnementApiV6\StructType\GetEersteVerschijningRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \AbonnementApiV6\ServiceType\Search($options);
/**
 * Sample call for searchAbonnement operation/method
 */
if ($search->searchAbonnement(new \AbonnementApiV6\StructType\SearchAbonnementRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchAbonnementByCred operation/method
 */
if ($search->searchAbonnementByCred(new \AbonnementApiV6\StructType\SearchAbonnementByCredRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchSmartcode operation/method
 */
if ($search->searchSmartcode(new \AbonnementApiV6\StructType\SearchSmartcodeRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchRelNoByAboNo operation/method
 */
if ($search->searchRelNoByAboNo(new \AbonnementApiV6\StructType\SearchRelNoByAboNoRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \AbonnementApiV6\ServiceType\Check($options);
/**
 * Sample call for checkProefabo operation/method
 */
if ($check->checkProefabo(new \AbonnementApiV6\StructType\CheckProefaboRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkActieabo operation/method
 */
if ($check->checkActieabo(new \AbonnementApiV6\StructType\CheckActieaboRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \AbonnementApiV6\ServiceType\Create($options);
/**
 * Sample call for createAboAboNaw operation/method
 */
if ($create->createAboAboNaw(new \AbonnementApiV6\StructType\CreateAboAboNawRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAboAboNo operation/method
 */
if ($create->createAboAboNo(new \AbonnementApiV6\StructType\CreateAboAboNoRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAboDebNawAboNaw operation/method
 */
if ($create->createAboDebNawAboNaw(new \AbonnementApiV6\StructType\CreateAboDebNawAboNawRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAboDebNawAboNo operation/method
 */
if ($create->createAboDebNawAboNo(new \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAboDebNoAboNaw operation/method
 */
if ($create->createAboDebNoAboNaw(new \AbonnementApiV6\StructType\CreateAboDebNoAboNawRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAboDebNoAboNo operation/method
 */
if ($create->createAboDebNoAboNo(new \AbonnementApiV6\StructType\CreateAboDebNoAboNoRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createVervolgAbonnement operation/method
 */
if ($create->createVervolgAbonnement(new \AbonnementApiV6\StructType\CreateVervolgAbonnementRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createVakantieRegeling operation/method
 */
if ($create->createVakantieRegeling(new \AbonnementApiV6\StructType\CreateVakantieRegelingRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createVerhuizing operation/method
 */
if ($create->createVerhuizing(new \AbonnementApiV6\StructType\CreateVerhuizingRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBezorgKlacht operation/method
 */
if ($create->createBezorgKlacht(new \AbonnementApiV6\StructType\CreateBezorgKlachtRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBezKlachtRelUitgave operation/method
 */
if ($create->createBezKlachtRelUitgave(new \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createKlantPersoon operation/method
 */
if ($create->createKlantPersoon(new \AbonnementApiV6\StructType\CreateKlantPersoonRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \AbonnementApiV6\ServiceType\Update($options);
/**
 * Sample call for updateAboBetaalwijze operation/method
 */
if ($update->updateAboBetaalwijze(new \AbonnementApiV6\StructType\UpdateAboBetaalwijzeRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAboPassword operation/method
 */
if ($update->updateAboPassword(new \AbonnementApiV6\StructType\UpdateAboPasswordRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLicentie operation/method
 */
if ($update->updateLicentie(new \AbonnementApiV6\StructType\UpdateLicentieRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateKlantPersoon operation/method
 */
if ($update->updateKlantPersoon(new \AbonnementApiV6\StructType\UpdateKlantPersoonRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateKlantAdres operation/method
 */
if ($update->updateKlantAdres(new \AbonnementApiV6\StructType\UpdateKlantAdresRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLicentiehouderRol operation/method
 */
if ($update->updateLicentiehouderRol(new \AbonnementApiV6\StructType\UpdateLicentiehouderRolRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Switch ServiceType
 */
$switch = new \AbonnementApiV6\ServiceType\_Switch($options);
/**
 * Sample call for switchAbonnement operation/method
 */
if ($switch->switchAbonnement(new \AbonnementApiV6\StructType\SwitchAbonnementRequest()) !== false) {
    print_r($switch->getResult());
} else {
    print_r($switch->getLastError());
}
/**
 * Samples for Wijk ServiceType
 */
$wijk = new \AbonnementApiV6\ServiceType\Wijk($options);
/**
 * Sample call for wijkCheck operation/method
 */
if ($wijk->wijkCheck(new \AbonnementApiV6\StructType\WijkCheckRequest()) !== false) {
    print_r($wijk->getResult());
} else {
    print_r($wijk->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \AbonnementApiV6\ServiceType\Add($options);
/**
 * Sample call for addLicentiehouderRol operation/method
 */
if ($add->addLicentiehouderRol(new \AbonnementApiV6\StructType\AddLicentiehouderRolRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLicentiehouder operation/method
 */
if ($add->addLicentiehouder(new \AbonnementApiV6\StructType\AddLicentiehouderRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \AbonnementApiV6\ServiceType\Delete($options);
/**
 * Sample call for deleteLicentiehouderRol operation/method
 */
if ($delete->deleteLicentiehouderRol(new \AbonnementApiV6\StructType\DeleteLicentiehouderRolRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteLicentiehouder operation/method
 */
if ($delete->deleteLicentiehouder(new \AbonnementApiV6\StructType\DeleteLicentiehouderRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteToekomstigeMutatie operation/method
 */
if ($delete->deleteToekomstigeMutatie(new \AbonnementApiV6\StructType\DeleteToekomstigeMutatieRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Stop ServiceType
 */
$stop = new \AbonnementApiV6\ServiceType\Stop($options);
/**
 * Sample call for stopGratisAboPerDirect operation/method
 */
if ($stop->stopGratisAboPerDirect(new \AbonnementApiV6\StructType\StopGratisAboPerDirectRequest()) !== false) {
    print_r($stop->getResult());
} else {
    print_r($stop->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \AbonnementApiV6\ServiceType\Cancel($options);
/**
 * Sample call for cancelBezorgKlacht operation/method
 */
if ($cancel->cancelBezorgKlacht(new \AbonnementApiV6\StructType\CancelBezorgKlachtRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Bestaat ServiceType
 */
$bestaat = new \AbonnementApiV6\ServiceType\Bestaat($options);
/**
 * Sample call for bestaatActiefAbonnement operation/method
 */
if ($bestaat->bestaatActiefAbonnement(new \AbonnementApiV6\StructType\BestaatActiefAbonnementRequest()) !== false) {
    print_r($bestaat->getResult());
} else {
    print_r($bestaat->getLastError());
}
/**
 * Samples for Renew ServiceType
 */
$renew = new \AbonnementApiV6\ServiceType\Renew($options);
/**
 * Sample call for renewAbonnement operation/method
 */
if ($renew->renewAbonnement(new \AbonnementApiV6\StructType\RenewAbonnementRequest()) !== false) {
    print_r($renew->getResult());
} else {
    print_r($renew->getLastError());
}
