<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateKlantPersoonRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>RelatieApiV6.updatePersoon</b> te gebruiken om de relatie te wijzigen.
 * </br></u> <br/> Werkt een bestaande relatie zijnde een persoon bij op basis van de opgegeven gegevens. <br/><u>Let op:</u> bij wijzigingen van een bestaand persoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven
 * (groepen) elementen worden leeg gemaakt door de update.
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdateKlantPersoonRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: Te wijzigen persoonsgegevens voor de relatie Zie 5.1 Persoonsobject.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoon;
    /**
     * The canUpdate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen update uitgevoerd). false (Default) = updaten, true = testmodus niet updaten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canUpdate;
    /**
     * Constructor method for updateKlantPersoonRequest
     * @uses UpdateKlantPersoonRequest::setRequestTag()
     * @uses UpdateKlantPersoonRequest::setRelNo()
     * @uses UpdateKlantPersoonRequest::setPersoon()
     * @uses UpdateKlantPersoonRequest::setCanUpdate()
     * @param string $requestTag
     * @param int $relNo
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoon
     * @param bool $canUpdate
     */
    public function __construct($requestTag = null, $relNo = null, \AbonnementApiV6\StructType\PersoonsObject $persoon = null, $canUpdate = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNo($relNo)
            ->setPersoon($persoon)
            ->setCanUpdate($canUpdate);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\UpdateKlantPersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\UpdateKlantPersoonRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
    /**
     * Get persoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\PersoonsObject|null
     */
    public function getPersoon()
    {
        return isset($this->persoon) ? $this->persoon : null;
    }
    /**
     * Set persoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoon
     * @return \AbonnementApiV6\StructType\UpdateKlantPersoonRequest
     */
    public function setPersoon(\AbonnementApiV6\StructType\PersoonsObject $persoon = null)
    {
        if (is_null($persoon) || (is_array($persoon) && empty($persoon))) {
            unset($this->persoon);
        } else {
            $this->persoon = $persoon;
        }
        return $this;
    }
    /**
     * Get canUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUpdate()
    {
        return isset($this->canUpdate) ? $this->canUpdate : null;
    }
    /**
     * Set canUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUpdate
     * @return \AbonnementApiV6\StructType\UpdateKlantPersoonRequest
     */
    public function setCanUpdate($canUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUpdate) && !is_bool($canUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUpdate, true), gettype($canUpdate)), __LINE__);
        }
        if (is_null($canUpdate) || (is_array($canUpdate) && empty($canUpdate))) {
            unset($this->canUpdate);
        } else {
            $this->canUpdate = $canUpdate;
        }
        return $this;
    }
}
