<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToekMutInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met toekomstige mutaties, zoals bijvoorbeeld verhuizingen of vakantie regelingen.
 * @subpackage Structs
 * @date 20240419 package
 */
class ToekMutInfo extends AbstractStructBase
{
    /**
     * The toekomstigeMutatie
     * Meta information extracted from the WSDL
     * - documentation: Lijst met toekomstige mutaties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\ToekMut[]
     */
    public $toekomstigeMutatie;
    /**
     * Constructor method for ToekMutInfo
     * @uses ToekMutInfo::setToekomstigeMutatie()
     * @param \AbonnementApiV6\StructType\ToekMut[] $toekomstigeMutatie
     */
    public function __construct(array $toekomstigeMutatie = array())
    {
        $this
            ->setToekomstigeMutatie($toekomstigeMutatie);
    }
    /**
     * Get toekomstigeMutatie value
     * @return \AbonnementApiV6\StructType\ToekMut[]|null
     */
    public function getToekomstigeMutatie()
    {
        return $this->toekomstigeMutatie;
    }
    /**
     * This method is responsible for validating the values passed to the setToekomstigeMutatie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setToekomstigeMutatie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateToekomstigeMutatieForArrayConstraintsFromSetToekomstigeMutatie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $toekMutInfoToekomstigeMutatieItem) {
            // validation for constraint: itemType
            if (!$toekMutInfoToekomstigeMutatieItem instanceof \AbonnementApiV6\StructType\ToekMut) {
                $invalidValues[] = is_object($toekMutInfoToekomstigeMutatieItem) ? get_class($toekMutInfoToekomstigeMutatieItem) : sprintf('%s(%s)', gettype($toekMutInfoToekomstigeMutatieItem), var_export($toekMutInfoToekomstigeMutatieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The toekomstigeMutatie property can only contain items of type \AbonnementApiV6\StructType\ToekMut, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\ToekMut[] $toekomstigeMutatie
     * @return \AbonnementApiV6\StructType\ToekMutInfo
     */
    public function setToekomstigeMutatie(array $toekomstigeMutatie = array())
    {
        // validation for constraint: array
        if ('' !== ($toekomstigeMutatieArrayErrorMessage = self::validateToekomstigeMutatieForArrayConstraintsFromSetToekomstigeMutatie($toekomstigeMutatie))) {
            throw new \InvalidArgumentException($toekomstigeMutatieArrayErrorMessage, __LINE__);
        }
        $this->toekomstigeMutatie = $toekomstigeMutatie;
        return $this;
    }
    /**
     * Add item to toekomstigeMutatie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\ToekMut $item
     * @return \AbonnementApiV6\StructType\ToekMutInfo
     */
    public function addToToekomstigeMutatie(\AbonnementApiV6\StructType\ToekMut $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\ToekMut) {
            throw new \InvalidArgumentException(sprintf('The toekomstigeMutatie property can only contain items of type \AbonnementApiV6\StructType\ToekMut, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->toekomstigeMutatie[] = $item;
        return $this;
    }
}
