<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for switchAbonnementRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Een bestaand abonnement omzetten (switchen) naar een andere abonnementsvorm.
 * @subpackage Structs
 * @date 20240419 package
 */
class SwitchAbonnementRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementnummer van het abonnement dat omgezet moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboObject
     * Meta information extracted from the WSDL
     * - documentation: Gegevens van het nieuwe abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AboObject
     */
    public $aboObject;
    /**
     * The aboStopReden
     * Meta information extracted from the WSDL
     * - documentation: Reden waarom huidige abonnement wordt gestopt.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboStopReden;
    /**
     * The aboAdmKosten
     * Meta information extracted from the WSDL
     * - documentation: Administratiekosten die in rekening worden gebracht (future support).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboAdmKosten;
    /**
     * The aboFactuurOnderdrukken
     * Meta information extracted from the WSDL
     * - documentation: Indicatie geen factuur (false=Wel factuur, true=Geen factuur).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurOnderdrukken;
    /**
     * The aboSwitchEindePeriode
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2] Switch pas toepassen aan het einde van het huidige abonnement of per opgegeven aboIngangsDatum (0=per ingangsdatum, 1=per einde gefactureerde periode, 2=per einde contract).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aboSwitchEindePeriode;
    /**
     * The geenControleLopendAbo
     * Meta information extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag (false=Nee/true=Ja, default false dus wel uitvoeren).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The canSwitch
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen switch uitgevoerd) false (Default) = switchen, true = testmodus niet switchen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canSwitch;
    /**
     * Constructor method for switchAbonnementRequest
     * @uses SwitchAbonnementRequest::setAboNo()
     * @uses SwitchAbonnementRequest::setRequestTag()
     * @uses SwitchAbonnementRequest::setAboObject()
     * @uses SwitchAbonnementRequest::setAboStopReden()
     * @uses SwitchAbonnementRequest::setAboAdmKosten()
     * @uses SwitchAbonnementRequest::setAboFactuurOnderdrukken()
     * @uses SwitchAbonnementRequest::setAboSwitchEindePeriode()
     * @uses SwitchAbonnementRequest::setGeenControleLopendAbo()
     * @uses SwitchAbonnementRequest::setCanSwitch()
     * @param int $aboNo
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @param string $aboStopReden
     * @param float $aboAdmKosten
     * @param bool $aboFactuurOnderdrukken
     * @param float $aboSwitchEindePeriode
     * @param bool $geenControleLopendAbo
     * @param bool $canSwitch
     */
    public function __construct($aboNo = null, $requestTag = null, \AbonnementApiV6\StructType\AboObject $aboObject = null, $aboStopReden = null, $aboAdmKosten = null, $aboFactuurOnderdrukken = null, $aboSwitchEindePeriode = null, $geenControleLopendAbo = null, $canSwitch = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRequestTag($requestTag)
            ->setAboObject($aboObject)
            ->setAboStopReden($aboStopReden)
            ->setAboAdmKosten($aboAdmKosten)
            ->setAboFactuurOnderdrukken($aboFactuurOnderdrukken)
            ->setAboSwitchEindePeriode($aboSwitchEindePeriode)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setCanSwitch($canSwitch);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AboObject|null
     */
    public function getAboObject()
    {
        return isset($this->aboObject) ? $this->aboObject : null;
    }
    /**
     * Set aboObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboObject(\AbonnementApiV6\StructType\AboObject $aboObject = null)
    {
        if (is_null($aboObject) || (is_array($aboObject) && empty($aboObject))) {
            unset($this->aboObject);
        } else {
            $this->aboObject = $aboObject;
        }
        return $this;
    }
    /**
     * Get aboStopReden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboStopReden()
    {
        return isset($this->aboStopReden) ? $this->aboStopReden : null;
    }
    /**
     * Set aboStopReden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboStopReden
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboStopReden($aboStopReden = null)
    {
        // validation for constraint: string
        if (!is_null($aboStopReden) && !is_string($aboStopReden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboStopReden, true), gettype($aboStopReden)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aboStopReden) && mb_strlen($aboStopReden) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aboStopReden)), __LINE__);
        }
        if (is_null($aboStopReden) || (is_array($aboStopReden) && empty($aboStopReden))) {
            unset($this->aboStopReden);
        } else {
            $this->aboStopReden = $aboStopReden;
        }
        return $this;
    }
    /**
     * Get aboAdmKosten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboAdmKosten()
    {
        return isset($this->aboAdmKosten) ? $this->aboAdmKosten : null;
    }
    /**
     * Set aboAdmKosten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboAdmKosten
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboAdmKosten($aboAdmKosten = null)
    {
        // validation for constraint: float
        if (!is_null($aboAdmKosten) && !(is_float($aboAdmKosten) || is_numeric($aboAdmKosten))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboAdmKosten, true), gettype($aboAdmKosten)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboAdmKosten) && mb_strlen(preg_replace('/(\D)/', '', $aboAdmKosten)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboAdmKosten, true), mb_strlen(preg_replace('/(\D)/', '', $aboAdmKosten))), __LINE__);
        }
        if (is_null($aboAdmKosten) || (is_array($aboAdmKosten) && empty($aboAdmKosten))) {
            unset($this->aboAdmKosten);
        } else {
            $this->aboAdmKosten = $aboAdmKosten;
        }
        return $this;
    }
    /**
     * Get aboFactuurOnderdrukken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurOnderdrukken()
    {
        return isset($this->aboFactuurOnderdrukken) ? $this->aboFactuurOnderdrukken : null;
    }
    /**
     * Set aboFactuurOnderdrukken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurOnderdrukken
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboFactuurOnderdrukken($aboFactuurOnderdrukken = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboFactuurOnderdrukken) && !is_bool($aboFactuurOnderdrukken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboFactuurOnderdrukken, true), gettype($aboFactuurOnderdrukken)), __LINE__);
        }
        if (is_null($aboFactuurOnderdrukken) || (is_array($aboFactuurOnderdrukken) && empty($aboFactuurOnderdrukken))) {
            unset($this->aboFactuurOnderdrukken);
        } else {
            $this->aboFactuurOnderdrukken = $aboFactuurOnderdrukken;
        }
        return $this;
    }
    /**
     * Get aboSwitchEindePeriode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboSwitchEindePeriode()
    {
        return isset($this->aboSwitchEindePeriode) ? $this->aboSwitchEindePeriode : null;
    }
    /**
     * Set aboSwitchEindePeriode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboSwitchEindePeriode
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setAboSwitchEindePeriode($aboSwitchEindePeriode = null)
    {
        // validation for constraint: float
        if (!is_null($aboSwitchEindePeriode) && !(is_float($aboSwitchEindePeriode) || is_numeric($aboSwitchEindePeriode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboSwitchEindePeriode, true), gettype($aboSwitchEindePeriode)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboSwitchEindePeriode) && mb_strlen(preg_replace('/(\D)/', '', $aboSwitchEindePeriode)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboSwitchEindePeriode, true), mb_strlen(preg_replace('/(\D)/', '', $aboSwitchEindePeriode))), __LINE__);
        }
        if (is_null($aboSwitchEindePeriode) || (is_array($aboSwitchEindePeriode) && empty($aboSwitchEindePeriode))) {
            unset($this->aboSwitchEindePeriode);
        } else {
            $this->aboSwitchEindePeriode = $aboSwitchEindePeriode;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get canSwitch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanSwitch()
    {
        return isset($this->canSwitch) ? $this->canSwitch : null;
    }
    /**
     * Set canSwitch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canSwitch
     * @return \AbonnementApiV6\StructType\SwitchAbonnementRequest
     */
    public function setCanSwitch($canSwitch = null)
    {
        // validation for constraint: boolean
        if (!is_null($canSwitch) && !is_bool($canSwitch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canSwitch, true), gettype($canSwitch)), __LINE__);
        }
        if (is_null($canSwitch) || (is_array($canSwitch) && empty($canSwitch))) {
            unset($this->canSwitch);
        } else {
            $this->canSwitch = $canSwitch;
        }
        return $this;
    }
}
