<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchRelNoByAboNoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft het relatienummer van het opgegeven abonnementnummer terug. Dat is afhankelijk van de gevraagde soort relatie de abonnee, de debiteur of de aanbrenger.
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchRelNoByAboNoRequest extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The soortRelatie
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2] Welk relatie veld moet er worden teruggegeven? 0 = Abonnee (default) 1 = Debiteur 2 = Aanbrenger.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $soortRelatie;
    /**
     * Constructor method for searchRelNoByAboNoRequest
     * @uses SearchRelNoByAboNoRequest::setAboNo()
     * @uses SearchRelNoByAboNoRequest::setRequestTag()
     * @uses SearchRelNoByAboNoRequest::setSoortRelatie()
     * @param int $aboNo
     * @param string $requestTag
     * @param float $soortRelatie
     */
    public function __construct($aboNo = null, $requestTag = null, $soortRelatie = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setRequestTag($requestTag)
            ->setSoortRelatie($soortRelatie);
    }
    /**
     * Get aboNo value
     * @return int
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\SearchRelNoByAboNoRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\SearchRelNoByAboNoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get soortRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getSoortRelatie()
    {
        return isset($this->soortRelatie) ? $this->soortRelatie : null;
    }
    /**
     * Set soortRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $soortRelatie
     * @return \AbonnementApiV6\StructType\SearchRelNoByAboNoRequest
     */
    public function setSoortRelatie($soortRelatie = null)
    {
        // validation for constraint: float
        if (!is_null($soortRelatie) && !(is_float($soortRelatie) || is_numeric($soortRelatie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($soortRelatie, true), gettype($soortRelatie)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($soortRelatie) && mb_strlen(preg_replace('/(\D)/', '', $soortRelatie)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($soortRelatie, true), mb_strlen(preg_replace('/(\D)/', '', $soortRelatie))), __LINE__);
        }
        if (is_null($soortRelatie) || (is_array($soortRelatie) && empty($soortRelatie))) {
            unset($this->soortRelatie);
        } else {
            $this->soortRelatie = $soortRelatie;
        }
        return $this;
    }
}
