<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchAbonnementRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Zoeken van abonnements informatie.
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchAbonnementRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode. Er mag gezocht worden met een combinatie van cijfers, en geen of 1 letter (bijv. 1100 K, of 1100). De service zoekt dan o.b.v. een LIKE.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The huisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $huisNummer;
    /**
     * The huisNummerToevoeging
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer toevoeging Match wordt uitgevoerd zonder spaties, ?-? en op uppercase.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisNummerToevoeging;
    /**
     * The achternaam
     * Meta information extracted from the WSDL
     * - documentation: Achternaam van de relatie Indien meegegeven wordt de match uitgevoerd op uppercase en o.b.v. de 1e 5 karakters.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaam;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Email-adres van de relatie Indien meegegegeven wordt de match 1-op-1 uitgevoerd.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The telefoonNummer
     * Meta information extracted from the WSDL
     * - documentation: Telefoonnummer Indien meegegeven wordt de match 1-op-1 uitgevoerd.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonNummer;
    /**
     * The toonAbonnementen
     * Meta information extracted from the WSDL
     * - documentation: Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * The exclVerschijningen
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van de recente verschijningen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclVerschijningen;
    /**
     * The exclKlachten
     * Meta information extracted from the WSDL
     * - documentation: Exclusief ophalen van bijbehorende klachten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclKlachten;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer Indien meegegegeven wordt de match 1-op-1 uitgevoerd.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * Constructor method for searchAbonnementRequest
     * @uses SearchAbonnementRequest::setRequestTag()
     * @uses SearchAbonnementRequest::setPostcode()
     * @uses SearchAbonnementRequest::setHuisNummer()
     * @uses SearchAbonnementRequest::setHuisNummerToevoeging()
     * @uses SearchAbonnementRequest::setAchternaam()
     * @uses SearchAbonnementRequest::setEmail()
     * @uses SearchAbonnementRequest::setTelefoonNummer()
     * @uses SearchAbonnementRequest::setToonAbonnementen()
     * @uses SearchAbonnementRequest::setExclVerschijningen()
     * @uses SearchAbonnementRequest::setExclKlachten()
     * @uses SearchAbonnementRequest::setRelNo()
     * @param string $requestTag
     * @param string $postcode
     * @param float $huisNummer
     * @param string $huisNummerToevoeging
     * @param string $achternaam
     * @param string $email
     * @param string $telefoonNummer
     * @param float $toonAbonnementen
     * @param bool $exclVerschijningen
     * @param bool $exclKlachten
     * @param int $relNo
     */
    public function __construct($requestTag = null, $postcode = null, $huisNummer = null, $huisNummerToevoeging = null, $achternaam = null, $email = null, $telefoonNummer = null, $toonAbonnementen = null, $exclVerschijningen = null, $exclKlachten = null, $relNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setPostcode($postcode)
            ->setHuisNummer($huisNummer)
            ->setHuisNummerToevoeging($huisNummerToevoeging)
            ->setAchternaam($achternaam)
            ->setEmail($email)
            ->setTelefoonNummer($telefoonNummer)
            ->setToonAbonnementen($toonAbonnementen)
            ->setExclVerschijningen($exclVerschijningen)
            ->setExclKlachten($exclKlachten)
            ->setRelNo($relNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $huisNummer
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: float
        if (!is_null($huisNummer) && !(is_float($huisNummer) || is_numeric($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get huisNummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToevoeging()
    {
        return isset($this->huisNummerToevoeging) ? $this->huisNummerToevoeging : null;
    }
    /**
     * Set huisNummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToevoeging
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setHuisNummerToevoeging($huisNummerToevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($huisNummerToevoeging) && !is_string($huisNummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisNummerToevoeging, true), gettype($huisNummerToevoeging)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($huisNummerToevoeging) && mb_strlen($huisNummerToevoeging) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($huisNummerToevoeging)), __LINE__);
        }
        if (is_null($huisNummerToevoeging) || (is_array($huisNummerToevoeging) && empty($huisNummerToevoeging))) {
            unset($this->huisNummerToevoeging);
        } else {
            $this->huisNummerToevoeging = $huisNummerToevoeging;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get telefoonNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummer()
    {
        return isset($this->telefoonNummer) ? $this->telefoonNummer : null;
    }
    /**
     * Set telefoonNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummer
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setTelefoonNummer($telefoonNummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonNummer) && !is_string($telefoonNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonNummer, true), gettype($telefoonNummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonNummer) && mb_strlen($telefoonNummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonNummer)), __LINE__);
        }
        if (is_null($telefoonNummer) || (is_array($telefoonNummer) && empty($telefoonNummer))) {
            unset($this->telefoonNummer);
        } else {
            $this->telefoonNummer = $telefoonNummer;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: float
        if (!is_null($toonAbonnementen) && !(is_float($toonAbonnementen) || is_numeric($toonAbonnementen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toonAbonnementen, true), gettype($toonAbonnementen)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($toonAbonnementen) && mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($toonAbonnementen, true), mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Get exclVerschijningen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclVerschijningen()
    {
        return isset($this->exclVerschijningen) ? $this->exclVerschijningen : null;
    }
    /**
     * Set exclVerschijningen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclVerschijningen
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setExclVerschijningen($exclVerschijningen = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclVerschijningen) && !is_bool($exclVerschijningen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclVerschijningen, true), gettype($exclVerschijningen)), __LINE__);
        }
        if (is_null($exclVerschijningen) || (is_array($exclVerschijningen) && empty($exclVerschijningen))) {
            unset($this->exclVerschijningen);
        } else {
            $this->exclVerschijningen = $exclVerschijningen;
        }
        return $this;
    }
    /**
     * Get exclKlachten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclKlachten()
    {
        return isset($this->exclKlachten) ? $this->exclKlachten : null;
    }
    /**
     * Set exclKlachten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclKlachten
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setExclKlachten($exclKlachten = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclKlachten) && !is_bool($exclKlachten)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclKlachten, true), gettype($exclKlachten)), __LINE__);
        }
        if (is_null($exclKlachten) || (is_array($exclKlachten) && empty($exclKlachten))) {
            unset($this->exclKlachten);
        } else {
            $this->exclKlachten = $exclKlachten;
        }
        return $this;
    }
    /**
     * Get relNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNo()
    {
        return isset($this->relNo) ? $this->relNo : null;
    }
    /**
     * Set relNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\SearchAbonnementRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        if (is_null($relNo) || (is_array($relNo) && empty($relNo))) {
            unset($this->relNo);
        } else {
            $this->relNo = $relNo;
        }
        return $this;
    }
}
