<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RolInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst rollen.
 * @subpackage Structs
 * @date 20240419 package
 */
class RolInfo extends AbstractStructBase
{
    /**
     * The rol
     * Meta information extracted from the WSDL
     * - documentation: Lijst rollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Rol[]
     */
    public $rol;
    /**
     * Constructor method for RolInfo
     * @uses RolInfo::setRol()
     * @param \AbonnementApiV6\StructType\Rol[] $rol
     */
    public function __construct(array $rol = array())
    {
        $this
            ->setRol($rol);
    }
    /**
     * Get rol value
     * @return \AbonnementApiV6\StructType\Rol[]|null
     */
    public function getRol()
    {
        return $this->rol;
    }
    /**
     * This method is responsible for validating the values passed to the setRol method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRol method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRolForArrayConstraintsFromSetRol(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rolInfoRolItem) {
            // validation for constraint: itemType
            if (!$rolInfoRolItem instanceof \AbonnementApiV6\StructType\Rol) {
                $invalidValues[] = is_object($rolInfoRolItem) ? get_class($rolInfoRolItem) : sprintf('%s(%s)', gettype($rolInfoRolItem), var_export($rolInfoRolItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rol property can only contain items of type \AbonnementApiV6\StructType\Rol, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rol value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Rol[] $rol
     * @return \AbonnementApiV6\StructType\RolInfo
     */
    public function setRol(array $rol = array())
    {
        // validation for constraint: array
        if ('' !== ($rolArrayErrorMessage = self::validateRolForArrayConstraintsFromSetRol($rol))) {
            throw new \InvalidArgumentException($rolArrayErrorMessage, __LINE__);
        }
        $this->rol = $rol;
        return $this;
    }
    /**
     * Add item to rol value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Rol $item
     * @return \AbonnementApiV6\StructType\RolInfo
     */
    public function addToRol(\AbonnementApiV6\StructType\Rol $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Rol) {
            throw new \InvalidArgumentException(sprintf('The rol property can only contain items of type \AbonnementApiV6\StructType\Rol, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rol[] = $item;
        return $this;
    }
}
