<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rol StructType
 * Meta information extracted from the WSDL
 * - documentation: Rol
 * @subpackage Structs
 * @date 20240419 package
 */
class Rol extends AbstractStructBase
{
    /**
     * The rolOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Rol omschrijving.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rolOmschrijving;
    /**
     * The rolBeheerder
     * Meta information extracted from the WSDL
     * - documentation: Rol beheerder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $rolBeheerder;
    /**
     * The rolNummer
     * Meta information extracted from the WSDL
     * - documentation: Rol nummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $rolNummer;
    /**
     * Constructor method for Rol
     * @uses Rol::setRolOmschrijving()
     * @uses Rol::setRolBeheerder()
     * @uses Rol::setRolNummer()
     * @param string $rolOmschrijving
     * @param int $rolBeheerder
     * @param int $rolNummer
     */
    public function __construct($rolOmschrijving = null, $rolBeheerder = null, $rolNummer = null)
    {
        $this
            ->setRolOmschrijving($rolOmschrijving)
            ->setRolBeheerder($rolBeheerder)
            ->setRolNummer($rolNummer);
    }
    /**
     * Get rolOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolOmschrijving()
    {
        return isset($this->rolOmschrijving) ? $this->rolOmschrijving : null;
    }
    /**
     * Set rolOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rolOmschrijving
     * @return \AbonnementApiV6\StructType\Rol
     */
    public function setRolOmschrijving($rolOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($rolOmschrijving) && !is_string($rolOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rolOmschrijving, true), gettype($rolOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($rolOmschrijving) && mb_strlen($rolOmschrijving) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($rolOmschrijving)), __LINE__);
        }
        if (is_null($rolOmschrijving) || (is_array($rolOmschrijving) && empty($rolOmschrijving))) {
            unset($this->rolOmschrijving);
        } else {
            $this->rolOmschrijving = $rolOmschrijving;
        }
        return $this;
    }
    /**
     * Get rolBeheerder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRolBeheerder()
    {
        return isset($this->rolBeheerder) ? $this->rolBeheerder : null;
    }
    /**
     * Set rolBeheerder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rolBeheerder
     * @return \AbonnementApiV6\StructType\Rol
     */
    public function setRolBeheerder($rolBeheerder = null)
    {
        // validation for constraint: int
        if (!is_null($rolBeheerder) && !(is_int($rolBeheerder) || ctype_digit($rolBeheerder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rolBeheerder, true), gettype($rolBeheerder)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($rolBeheerder) && mb_strlen(preg_replace('/(\D)/', '', $rolBeheerder)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($rolBeheerder, true), mb_strlen(preg_replace('/(\D)/', '', $rolBeheerder))), __LINE__);
        }
        if (is_null($rolBeheerder) || (is_array($rolBeheerder) && empty($rolBeheerder))) {
            unset($this->rolBeheerder);
        } else {
            $this->rolBeheerder = $rolBeheerder;
        }
        return $this;
    }
    /**
     * Get rolNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRolNummer()
    {
        return isset($this->rolNummer) ? $this->rolNummer : null;
    }
    /**
     * Set rolNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rolNummer
     * @return \AbonnementApiV6\StructType\Rol
     */
    public function setRolNummer($rolNummer = null)
    {
        // validation for constraint: int
        if (!is_null($rolNummer) && !(is_int($rolNummer) || ctype_digit($rolNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rolNummer, true), gettype($rolNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($rolNummer) && mb_strlen(preg_replace('/(\D)/', '', $rolNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($rolNummer, true), mb_strlen(preg_replace('/(\D)/', '', $rolNummer))), __LINE__);
        }
        if (is_null($rolNummer) || (is_array($rolNummer) && empty($rolNummer))) {
            unset($this->rolNummer);
        } else {
            $this->rolNummer = $rolNummer;
        }
        return $this;
    }
}
