<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewAbonnementResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error51: De renew-optie is niet actief | error50: Er is een onbekende foutmelding opgetreden. | error13: Bij betaalwijze 3 (iDeal) moet een betaalReferentie worden opgegeven | error12: Het is niet mogelijk om dit abonnement te
 * renewen, het is reeds definitief stopgezet. | error11: Kan geen volgende editie bepalen voor het huidige abonnement | error10: Het abonnement is reeds gerenewed. | error9: De abonnementsoort van het huidige abonnement is niet van een geldig type |
 * error8: Het huidige abonnement is niet gestopt. | error7: Als renewNaarAbonnement=ander, mag alleen renewNaarAbosoortCode of renewNaarActieCode of renewNaarPakketCode gevuld zijn. | error6: Als renewNaarAbonnement=zelfde, moeten
 * renewNaarAbosoortCode, renewNaarActieCode en renewNaarPakketCode leeg zijn | error5: renewNaarAbonnement heeft een ongeldige waarde | error4: renewPerEditie moet groter zijn dan de huidige stopeditie van het abonnement | error3: renewPerEditie mag
 * alleen worden opgegeven als renewPerWanneer=specifieke_editie | error2: renewPerWanneer heeft een ongeldige waarde. | error1: Kan geen abonnement vinden voor opgegeven aboNo of uitgaveCode+relatieNo/emailAdres
 * @subpackage Structs
 * @date 20240419 package
 */
class RenewAbonnementResponse extends AbstractStructBase
{
    /**
     * The abonnementen
     * Meta information extracted from the WSDL
     * - documentation: Lijst met aangemaakte abonnementen. Kunnen er meerdere zijn, indien er naar een pakket wordt gerenewed.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboInfoTab
     */
    public $abonnementen;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij.<br/> De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for renewAbonnementResponse
     * @uses RenewAbonnementResponse::setAbonnementen()
     * @uses RenewAbonnementResponse::setRequestTag()
     * @param \AbonnementApiV6\StructType\AboInfoTab $abonnementen
     * @param string $requestTag
     */
    public function __construct(\AbonnementApiV6\StructType\AboInfoTab $abonnementen = null, $requestTag = null)
    {
        $this
            ->setAbonnementen($abonnementen)
            ->setRequestTag($requestTag);
    }
    /**
     * Get abonnementen value
     * @return \AbonnementApiV6\StructType\AboInfoTab
     */
    public function getAbonnementen()
    {
        return $this->abonnementen;
    }
    /**
     * Set abonnementen value
     * @param \AbonnementApiV6\StructType\AboInfoTab $abonnementen
     * @return \AbonnementApiV6\StructType\RenewAbonnementResponse
     */
    public function setAbonnementen(\AbonnementApiV6\StructType\AboInfoTab $abonnementen = null)
    {
        $this->abonnementen = $abonnementen;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\RenewAbonnementResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
