<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for renewAbonnementRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Een bestaand, gestopt abonnement, renewen. Hierbij moet een van deze combinatie aan parameters meegegeven worden:<br/> <ul><li>aboNo</li> <li>uitgaveCode en relatieNo</li> <li>uitgaveCode en emailAdres</li> </ul>
 * @subpackage Structs
 * @date 20240419 package
 */
class RenewAbonnementRequest extends AbstractStructBase
{
    /**
     * The renewPerWanneer
     * Meta information extracted from the WSDL
     * - documentation: {aansluitend,eerstvolgende_editie,specifieke_editie}Per wanneer moet het renewal-abonnement ingaan? <ul><li>aansluitend: Het renewalabonnement sluit aan op het huidige abonnement. Indien er al nummers verschenen zijn, worden deze
     * nagestuurd</li><li>eerstvolgende_editie: Het renewal abonnement start per de eerstvolgende editie die verschijnt</li><li>specifieke_editie: Het renewal abonnement start op de editie, opgegeven in renewPerEditie</li></ul>
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $renewPerWanneer;
    /**
     * The renewNaarAbonnement
     * Meta information extracted from the WSDL
     * - documentation: {zelfde,ander} Geeft aan wat voor soort abonnement het renewalabonnement krijgt. <ul><li>zelfde: het renewalabonnement krijgt dezelfde abonnementsoort en pakket als het oorspronkelijke abonnement</li><li>ander: Het abonnement wordt
     * gerenewed naar een andere soort. Geef in een van de velden renewNaarAbosoortCode, renewNaarActieCode of renewNaarPekketCode de juiste soort door</li></ul>
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $renewNaarAbonnement;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij.<br/> De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementnummer van het abonnement dat renewed moet worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave van het bestaand abonnement. Wordt gebruikt om te bepalen welk abonnement er genewed moet worden indien geen aboNo is opgegeven. Indien uitgaveCode en aboNo leeg is, wordt het bestaande abonnement opgezicht obv de
     * uitgave waarnaar gerenewed wordt.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The relatieNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de relatie. Wordt gebruikt in combinatie met uitgaveCode om te bepalen welk abonnement er genewed moet worden indien geen aboNo is opgegeven.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNo;
    /**
     * The emailAdres
     * Meta information extracted from the WSDL
     * - documentation: E-mail adres vsn de relatie. Wordt gebruikt in combinatie met uitgaveCode om te bepalen welk abonnement er genewed moet worden indien geen aboNo is opgegeven.
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $emailAdres;
    /**
     * The renewPerEditie
     * Meta information extracted from the WSDL
     * - documentation: Indien renewPerWanneer=specifieke_editie, kan hier het editienummer opgegeven worden per wanneer het renewalabonnement gestart moet worden. Editienummer opgeven in de vorm yyyynn(n)
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $renewPerEditie;
    /**
     * The renewNaarAbosoortCode
     * Meta information extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van de abonnementsoort waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarAbosoortCode;
    /**
     * The renewNaarActieCode
     * Meta information extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van de actie waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarActieCode;
    /**
     * The renewNaarPakketCode
     * Meta information extracted from the WSDL
     * - documentation: Wordt alleen gebruikt indien renewNaarAbonnement=ander. Code van het pakket waar het abonnement naartoe gerenewed moet worden
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $renewNaarPakketCode;
    /**
     * The betaalwijze
     * Meta information extracted from the WSDL
     * - documentation: [0,1,3,4,7] Betaalwijze: 0 = factuur, 1 = incasso, 3 = Eenmalige iDeal, 4 = Factuur per mail, 7 = Creditcard
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $betaalwijze;
    /**
     * The betaalReferentie
     * Meta information extracted from the WSDL
     * - documentation: Betaalreferentie in geval van betaling via eenmalige iDeal.
     * - base: xsd:string
     * - maxLength: 64
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $betaalReferentie;
    /**
     * The aboOrdernummer
     * Meta information extracted from the WSDL
     * - documentation: Ordernummer van besteller ter referentie.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboOrdernummer;
    /**
     * The adresObject
     * Meta information extracted from the WSDL
     * - documentation: Optioneel, het adres waar het blad naartoe gestuurd moet worden. Als dit afwijkt van het adres op de relatie van het gevonden abonnement, wordt het bijgewerkt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $adresObject;
    /**
     * Constructor method for renewAbonnementRequest
     * @uses RenewAbonnementRequest::setRenewPerWanneer()
     * @uses RenewAbonnementRequest::setRenewNaarAbonnement()
     * @uses RenewAbonnementRequest::setRequestTag()
     * @uses RenewAbonnementRequest::setAboNo()
     * @uses RenewAbonnementRequest::setUitgaveCode()
     * @uses RenewAbonnementRequest::setRelatieNo()
     * @uses RenewAbonnementRequest::setEmailAdres()
     * @uses RenewAbonnementRequest::setRenewPerEditie()
     * @uses RenewAbonnementRequest::setRenewNaarAbosoortCode()
     * @uses RenewAbonnementRequest::setRenewNaarActieCode()
     * @uses RenewAbonnementRequest::setRenewNaarPakketCode()
     * @uses RenewAbonnementRequest::setBetaalwijze()
     * @uses RenewAbonnementRequest::setBetaalReferentie()
     * @uses RenewAbonnementRequest::setAboOrdernummer()
     * @uses RenewAbonnementRequest::setAdresObject()
     * @param string $renewPerWanneer
     * @param string $renewNaarAbonnement
     * @param string $requestTag
     * @param int $aboNo
     * @param string $uitgaveCode
     * @param int $relatieNo
     * @param string $emailAdres
     * @param int $renewPerEditie
     * @param string $renewNaarAbosoortCode
     * @param string $renewNaarActieCode
     * @param string $renewNaarPakketCode
     * @param int $betaalwijze
     * @param string $betaalReferentie
     * @param string $aboOrdernummer
     * @param \AbonnementApiV6\StructType\AdresObject $adresObject
     */
    public function __construct($renewPerWanneer = null, $renewNaarAbonnement = null, $requestTag = null, $aboNo = null, $uitgaveCode = null, $relatieNo = null, $emailAdres = null, $renewPerEditie = null, $renewNaarAbosoortCode = null, $renewNaarActieCode = null, $renewNaarPakketCode = null, $betaalwijze = null, $betaalReferentie = null, $aboOrdernummer = null, \AbonnementApiV6\StructType\AdresObject $adresObject = null)
    {
        $this
            ->setRenewPerWanneer($renewPerWanneer)
            ->setRenewNaarAbonnement($renewNaarAbonnement)
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setUitgaveCode($uitgaveCode)
            ->setRelatieNo($relatieNo)
            ->setEmailAdres($emailAdres)
            ->setRenewPerEditie($renewPerEditie)
            ->setRenewNaarAbosoortCode($renewNaarAbosoortCode)
            ->setRenewNaarActieCode($renewNaarActieCode)
            ->setRenewNaarPakketCode($renewNaarPakketCode)
            ->setBetaalwijze($betaalwijze)
            ->setBetaalReferentie($betaalReferentie)
            ->setAboOrdernummer($aboOrdernummer)
            ->setAdresObject($adresObject);
    }
    /**
     * Get renewPerWanneer value
     * @return string
     */
    public function getRenewPerWanneer()
    {
        return $this->renewPerWanneer;
    }
    /**
     * Set renewPerWanneer value
     * @param string $renewPerWanneer
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewPerWanneer($renewPerWanneer = null)
    {
        // validation for constraint: string
        if (!is_null($renewPerWanneer) && !is_string($renewPerWanneer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewPerWanneer, true), gettype($renewPerWanneer)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($renewPerWanneer) && mb_strlen($renewPerWanneer) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($renewPerWanneer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($renewPerWanneer) && mb_strlen($renewPerWanneer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($renewPerWanneer)), __LINE__);
        }
        $this->renewPerWanneer = $renewPerWanneer;
        return $this;
    }
    /**
     * Get renewNaarAbonnement value
     * @return string
     */
    public function getRenewNaarAbonnement()
    {
        return $this->renewNaarAbonnement;
    }
    /**
     * Set renewNaarAbonnement value
     * @param string $renewNaarAbonnement
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarAbonnement($renewNaarAbonnement = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarAbonnement) && !is_string($renewNaarAbonnement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarAbonnement, true), gettype($renewNaarAbonnement)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($renewNaarAbonnement) && mb_strlen($renewNaarAbonnement) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($renewNaarAbonnement)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($renewNaarAbonnement) && mb_strlen($renewNaarAbonnement) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($renewNaarAbonnement)), __LINE__);
        }
        $this->renewNaarAbonnement = $renewNaarAbonnement;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get relatieNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNo()
    {
        return isset($this->relatieNo) ? $this->relatieNo : null;
    }
    /**
     * Set relatieNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNo
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRelatieNo($relatieNo = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNo) && !(is_int($relatieNo) || ctype_digit($relatieNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNo, true), gettype($relatieNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNo) && mb_strlen(preg_replace('/(\D)/', '', $relatieNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNo, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNo))), __LINE__);
        }
        if (is_null($relatieNo) || (is_array($relatieNo) && empty($relatieNo))) {
            unset($this->relatieNo);
        } else {
            $this->relatieNo = $relatieNo;
        }
        return $this;
    }
    /**
     * Get emailAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAdres()
    {
        return isset($this->emailAdres) ? $this->emailAdres : null;
    }
    /**
     * Set emailAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAdres
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setEmailAdres($emailAdres = null)
    {
        // validation for constraint: string
        if (!is_null($emailAdres) && !is_string($emailAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAdres, true), gettype($emailAdres)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($emailAdres) && mb_strlen($emailAdres) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($emailAdres)), __LINE__);
        }
        if (is_null($emailAdres) || (is_array($emailAdres) && empty($emailAdres))) {
            unset($this->emailAdres);
        } else {
            $this->emailAdres = $emailAdres;
        }
        return $this;
    }
    /**
     * Get renewPerEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRenewPerEditie()
    {
        return isset($this->renewPerEditie) ? $this->renewPerEditie : null;
    }
    /**
     * Set renewPerEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $renewPerEditie
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewPerEditie($renewPerEditie = null)
    {
        // validation for constraint: int
        if (!is_null($renewPerEditie) && !(is_int($renewPerEditie) || ctype_digit($renewPerEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($renewPerEditie, true), gettype($renewPerEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($renewPerEditie) && mb_strlen(preg_replace('/(\D)/', '', $renewPerEditie)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($renewPerEditie, true), mb_strlen(preg_replace('/(\D)/', '', $renewPerEditie))), __LINE__);
        }
        if (is_null($renewPerEditie) || (is_array($renewPerEditie) && empty($renewPerEditie))) {
            unset($this->renewPerEditie);
        } else {
            $this->renewPerEditie = $renewPerEditie;
        }
        return $this;
    }
    /**
     * Get renewNaarAbosoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarAbosoortCode()
    {
        return isset($this->renewNaarAbosoortCode) ? $this->renewNaarAbosoortCode : null;
    }
    /**
     * Set renewNaarAbosoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarAbosoortCode
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarAbosoortCode($renewNaarAbosoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarAbosoortCode) && !is_string($renewNaarAbosoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarAbosoortCode, true), gettype($renewNaarAbosoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($renewNaarAbosoortCode) && mb_strlen($renewNaarAbosoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($renewNaarAbosoortCode)), __LINE__);
        }
        if (is_null($renewNaarAbosoortCode) || (is_array($renewNaarAbosoortCode) && empty($renewNaarAbosoortCode))) {
            unset($this->renewNaarAbosoortCode);
        } else {
            $this->renewNaarAbosoortCode = $renewNaarAbosoortCode;
        }
        return $this;
    }
    /**
     * Get renewNaarActieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarActieCode()
    {
        return isset($this->renewNaarActieCode) ? $this->renewNaarActieCode : null;
    }
    /**
     * Set renewNaarActieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarActieCode
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarActieCode($renewNaarActieCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarActieCode) && !is_string($renewNaarActieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarActieCode, true), gettype($renewNaarActieCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($renewNaarActieCode) && mb_strlen($renewNaarActieCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($renewNaarActieCode)), __LINE__);
        }
        if (is_null($renewNaarActieCode) || (is_array($renewNaarActieCode) && empty($renewNaarActieCode))) {
            unset($this->renewNaarActieCode);
        } else {
            $this->renewNaarActieCode = $renewNaarActieCode;
        }
        return $this;
    }
    /**
     * Get renewNaarPakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewNaarPakketCode()
    {
        return isset($this->renewNaarPakketCode) ? $this->renewNaarPakketCode : null;
    }
    /**
     * Set renewNaarPakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewNaarPakketCode
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setRenewNaarPakketCode($renewNaarPakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($renewNaarPakketCode) && !is_string($renewNaarPakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewNaarPakketCode, true), gettype($renewNaarPakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($renewNaarPakketCode) && mb_strlen($renewNaarPakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($renewNaarPakketCode)), __LINE__);
        }
        if (is_null($renewNaarPakketCode) || (is_array($renewNaarPakketCode) && empty($renewNaarPakketCode))) {
            unset($this->renewNaarPakketCode);
        } else {
            $this->renewNaarPakketCode = $renewNaarPakketCode;
        }
        return $this;
    }
    /**
     * Get betaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBetaalwijze()
    {
        return isset($this->betaalwijze) ? $this->betaalwijze : null;
    }
    /**
     * Set betaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $betaalwijze
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: int
        if (!is_null($betaalwijze) && !(is_int($betaalwijze) || ctype_digit($betaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($betaalwijze, true), gettype($betaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($betaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $betaalwijze)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($betaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $betaalwijze))), __LINE__);
        }
        if (is_null($betaalwijze) || (is_array($betaalwijze) && empty($betaalwijze))) {
            unset($this->betaalwijze);
        } else {
            $this->betaalwijze = $betaalwijze;
        }
        return $this;
    }
    /**
     * Get betaalReferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBetaalReferentie()
    {
        return isset($this->betaalReferentie) ? $this->betaalReferentie : null;
    }
    /**
     * Set betaalReferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $betaalReferentie
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setBetaalReferentie($betaalReferentie = null)
    {
        // validation for constraint: string
        if (!is_null($betaalReferentie) && !is_string($betaalReferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betaalReferentie, true), gettype($betaalReferentie)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($betaalReferentie) && mb_strlen($betaalReferentie) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($betaalReferentie)), __LINE__);
        }
        if (is_null($betaalReferentie) || (is_array($betaalReferentie) && empty($betaalReferentie))) {
            unset($this->betaalReferentie);
        } else {
            $this->betaalReferentie = $betaalReferentie;
        }
        return $this;
    }
    /**
     * Get aboOrdernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboOrdernummer()
    {
        return isset($this->aboOrdernummer) ? $this->aboOrdernummer : null;
    }
    /**
     * Set aboOrdernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboOrdernummer
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setAboOrdernummer($aboOrdernummer = null)
    {
        // validation for constraint: string
        if (!is_null($aboOrdernummer) && !is_string($aboOrdernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboOrdernummer, true), gettype($aboOrdernummer)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($aboOrdernummer) && mb_strlen($aboOrdernummer) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($aboOrdernummer)), __LINE__);
        }
        if (is_null($aboOrdernummer) || (is_array($aboOrdernummer) && empty($aboOrdernummer))) {
            unset($this->aboOrdernummer);
        } else {
            $this->aboOrdernummer = $aboOrdernummer;
        }
        return $this;
    }
    /**
     * Get adresObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AdresObject|null
     */
    public function getAdresObject()
    {
        return isset($this->adresObject) ? $this->adresObject : null;
    }
    /**
     * Set adresObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AdresObject $adresObject
     * @return \AbonnementApiV6\StructType\RenewAbonnementRequest
     */
    public function setAdresObject(\AbonnementApiV6\StructType\AdresObject $adresObject = null)
    {
        if (is_null($adresObject) || (is_array($adresObject) && empty($adresObject))) {
            unset($this->adresObject);
        } else {
            $this->adresObject = $adresObject;
        }
        return $this;
    }
}
