<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicentiehouderInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Een lijst met de gevonden licentiehouders.
 * @subpackage Structs
 * @date 20240419 package
 */
class LicentiehouderInfo extends AbstractStructBase
{
    /**
     * The licentiehouder
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met de gevonden licentiehouders.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Licentiehouder[]
     */
    public $licentiehouder;
    /**
     * Constructor method for LicentiehouderInfo
     * @uses LicentiehouderInfo::setLicentiehouder()
     * @param \AbonnementApiV6\StructType\Licentiehouder[] $licentiehouder
     */
    public function __construct(array $licentiehouder = array())
    {
        $this
            ->setLicentiehouder($licentiehouder);
    }
    /**
     * Get licentiehouder value
     * @return \AbonnementApiV6\StructType\Licentiehouder[]|null
     */
    public function getLicentiehouder()
    {
        return $this->licentiehouder;
    }
    /**
     * This method is responsible for validating the values passed to the setLicentiehouder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLicentiehouder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLicentiehouderForArrayConstraintsFromSetLicentiehouder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $licentiehouderInfoLicentiehouderItem) {
            // validation for constraint: itemType
            if (!$licentiehouderInfoLicentiehouderItem instanceof \AbonnementApiV6\StructType\Licentiehouder) {
                $invalidValues[] = is_object($licentiehouderInfoLicentiehouderItem) ? get_class($licentiehouderInfoLicentiehouderItem) : sprintf('%s(%s)', gettype($licentiehouderInfoLicentiehouderItem), var_export($licentiehouderInfoLicentiehouderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The licentiehouder property can only contain items of type \AbonnementApiV6\StructType\Licentiehouder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set licentiehouder value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Licentiehouder[] $licentiehouder
     * @return \AbonnementApiV6\StructType\LicentiehouderInfo
     */
    public function setLicentiehouder(array $licentiehouder = array())
    {
        // validation for constraint: array
        if ('' !== ($licentiehouderArrayErrorMessage = self::validateLicentiehouderForArrayConstraintsFromSetLicentiehouder($licentiehouder))) {
            throw new \InvalidArgumentException($licentiehouderArrayErrorMessage, __LINE__);
        }
        $this->licentiehouder = $licentiehouder;
        return $this;
    }
    /**
     * Add item to licentiehouder value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Licentiehouder $item
     * @return \AbonnementApiV6\StructType\LicentiehouderInfo
     */
    public function addToLicentiehouder(\AbonnementApiV6\StructType\Licentiehouder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Licentiehouder) {
            throw new \InvalidArgumentException(sprintf('The licentiehouder property can only contain items of type \AbonnementApiV6\StructType\Licentiehouder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->licentiehouder[] = $item;
        return $this;
    }
}
