<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KlachtTab StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst klachten.
 * @subpackage Structs
 * @date 20240419 package
 */
class KlachtTab extends AbstractStructBase
{
    /**
     * The klacht
     * Meta information extracted from the WSDL
     * - documentation: Lijst klachten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Klacht[]
     */
    public $klacht;
    /**
     * Constructor method for KlachtTab
     * @uses KlachtTab::setKlacht()
     * @param \AbonnementApiV6\StructType\Klacht[] $klacht
     */
    public function __construct(array $klacht = array())
    {
        $this
            ->setKlacht($klacht);
    }
    /**
     * Get klacht value
     * @return \AbonnementApiV6\StructType\Klacht[]|null
     */
    public function getKlacht()
    {
        return $this->klacht;
    }
    /**
     * This method is responsible for validating the values passed to the setKlacht method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlacht method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlachtForArrayConstraintsFromSetKlacht(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $klachtTabKlachtItem) {
            // validation for constraint: itemType
            if (!$klachtTabKlachtItem instanceof \AbonnementApiV6\StructType\Klacht) {
                $invalidValues[] = is_object($klachtTabKlachtItem) ? get_class($klachtTabKlachtItem) : sprintf('%s(%s)', gettype($klachtTabKlachtItem), var_export($klachtTabKlachtItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The klacht property can only contain items of type \AbonnementApiV6\StructType\Klacht, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set klacht value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Klacht[] $klacht
     * @return \AbonnementApiV6\StructType\KlachtTab
     */
    public function setKlacht(array $klacht = array())
    {
        // validation for constraint: array
        if ('' !== ($klachtArrayErrorMessage = self::validateKlachtForArrayConstraintsFromSetKlacht($klacht))) {
            throw new \InvalidArgumentException($klachtArrayErrorMessage, __LINE__);
        }
        $this->klacht = $klacht;
        return $this;
    }
    /**
     * Add item to klacht value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Klacht $item
     * @return \AbonnementApiV6\StructType\KlachtTab
     */
    public function addToKlacht(\AbonnementApiV6\StructType\Klacht $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Klacht) {
            throw new \InvalidArgumentException(sprintf('The klacht property can only contain items of type \AbonnementApiV6\StructType\Klacht, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->klacht[] = $item;
        return $this;
    }
}
