<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HerkomstInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met herkomsten.
 * @subpackage Structs
 * @date 20240419 package
 */
class HerkomstInfo extends AbstractStructBase
{
    /**
     * The herkomst
     * Meta information extracted from the WSDL
     * - documentation: Lijst met herkomsten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Herkomst[]
     */
    public $herkomst;
    /**
     * Constructor method for HerkomstInfo
     * @uses HerkomstInfo::setHerkomst()
     * @param \AbonnementApiV6\StructType\Herkomst[] $herkomst
     */
    public function __construct(array $herkomst = array())
    {
        $this
            ->setHerkomst($herkomst);
    }
    /**
     * Get herkomst value
     * @return \AbonnementApiV6\StructType\Herkomst[]|null
     */
    public function getHerkomst()
    {
        return $this->herkomst;
    }
    /**
     * This method is responsible for validating the values passed to the setHerkomst method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHerkomst method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHerkomstForArrayConstraintsFromSetHerkomst(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herkomstInfoHerkomstItem) {
            // validation for constraint: itemType
            if (!$herkomstInfoHerkomstItem instanceof \AbonnementApiV6\StructType\Herkomst) {
                $invalidValues[] = is_object($herkomstInfoHerkomstItem) ? get_class($herkomstInfoHerkomstItem) : sprintf('%s(%s)', gettype($herkomstInfoHerkomstItem), var_export($herkomstInfoHerkomstItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The herkomst property can only contain items of type \AbonnementApiV6\StructType\Herkomst, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set herkomst value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Herkomst[] $herkomst
     * @return \AbonnementApiV6\StructType\HerkomstInfo
     */
    public function setHerkomst(array $herkomst = array())
    {
        // validation for constraint: array
        if ('' !== ($herkomstArrayErrorMessage = self::validateHerkomstForArrayConstraintsFromSetHerkomst($herkomst))) {
            throw new \InvalidArgumentException($herkomstArrayErrorMessage, __LINE__);
        }
        $this->herkomst = $herkomst;
        return $this;
    }
    /**
     * Add item to herkomst value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Herkomst $item
     * @return \AbonnementApiV6\StructType\HerkomstInfo
     */
    public function addToHerkomst(\AbonnementApiV6\StructType\Herkomst $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Herkomst) {
            throw new \InvalidArgumentException(sprintf('The herkomst property can only contain items of type \AbonnementApiV6\StructType\Herkomst, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->herkomst[] = $item;
        return $this;
    }
}
