<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getToekomstigeMutatiesRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft een lijst met toekomstige mutaties per relatienummer. Toekomstige mutaties zijn bijvoorbeeld vakantie regelingen of verhuizingen.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetToekomstigeMutatiesRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de abonnee.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getToekomstigeMutatiesRequest
     * @uses GetToekomstigeMutatiesRequest::setRelNo()
     * @uses GetToekomstigeMutatiesRequest::setRequestTag()
     * @param int $relNo
     * @param string $requestTag
     */
    public function __construct($relNo = null, $requestTag = null)
    {
        $this
            ->setRelNo($relNo)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \AbonnementApiV6\StructType\GetToekomstigeMutatiesRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetToekomstigeMutatiesRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
