<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAbonnementInfoResponse StructType
 * @subpackage Structs
 * @date 20240419 package
 */
class GetAbonnementInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The return1
     * Meta information extracted from the WSDL
     * - documentation: Resultaat. De output van deze service bestaat uit 4 delen: <br/>De gegevens van de abonnee. <br/>De gegevens van het abonnement. <br/>De gegevens van Ã©Ã©n of meerdere klachten bij het abonnement. <br/>De recente verschijningen
     * van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\AbonnementInfo
     */
    public $return1;
    /**
     * Constructor method for getAbonnementInfoResponse
     * @uses GetAbonnementInfoResponse::setRequestTag()
     * @uses GetAbonnementInfoResponse::setReturn1()
     * @param string $requestTag
     * @param \AbonnementApiV6\StructType\AbonnementInfo $return1
     */
    public function __construct($requestTag = null, \AbonnementApiV6\StructType\AbonnementInfo $return1 = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setReturn1($return1);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get return1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\AbonnementInfo|null
     */
    public function getReturn1()
    {
        return isset($this->return1) ? $this->return1 : null;
    }
    /**
     * Set return1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\AbonnementInfo $return1
     * @return \AbonnementApiV6\StructType\GetAbonnementInfoResponse
     */
    public function setReturn1(\AbonnementApiV6\StructType\AbonnementInfo $return1 = null)
    {
        if (is_null($return1) || (is_array($return1) && empty($return1))) {
            unset($this->return1);
        } else {
            $this->return1 = $return1;
        }
        return $this;
    }
}
