<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactuurAdres StructType
 * Meta information extracted from the WSDL
 * - documentation: Het factuuradres bestaat uit de volgende velden:
 * @subpackage Structs
 * @date 20240419 package
 */
class FactuurAdres extends AbstractStructBase
{
    /**
     * The bedrijfsNaam
     * Meta information extracted from the WSDL
     * - documentation: Bedrijfsnaam.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bedrijfsNaam;
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: Afdeling.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdeling;
    /**
     * The voorLettersNaam
     * Meta information extracted from the WSDL
     * - documentation: Voorletters of voornaam afhankelijk van hoe dat ingesteld staat in Zeno.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorLettersNaam;
    /**
     * The tussenvoegsels
     * Meta information extracted from the WSDL
     * - documentation: Tussenvoegsels.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tussenvoegsels;
    /**
     * The achterNaam
     * Meta information extracted from the WSDL
     * - documentation: Achternaam.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achterNaam;
    /**
     * The straat
     * Meta information extracted from the WSDL
     * - documentation: Straatnaam.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $straat;
    /**
     * The huisNummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer, groter dan 0.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $huisNummer;
    /**
     * The huisNummerToev
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer toevoeging.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisNummerToev;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode.
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postcode;
    /**
     * The plaats
     * Meta information extracted from the WSDL
     * - documentation: Woonplaats.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $plaats;
    /**
     * The land
     * Meta information extracted from the WSDL
     * - documentation: Land.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $land;
    /**
     * Constructor method for FactuurAdres
     * @uses FactuurAdres::setBedrijfsNaam()
     * @uses FactuurAdres::setAfdeling()
     * @uses FactuurAdres::setVoorLettersNaam()
     * @uses FactuurAdres::setTussenvoegsels()
     * @uses FactuurAdres::setAchterNaam()
     * @uses FactuurAdres::setStraat()
     * @uses FactuurAdres::setHuisNummer()
     * @uses FactuurAdres::setHuisNummerToev()
     * @uses FactuurAdres::setPostcode()
     * @uses FactuurAdres::setPlaats()
     * @uses FactuurAdres::setLand()
     * @param string $bedrijfsNaam
     * @param string $afdeling
     * @param string $voorLettersNaam
     * @param string $tussenvoegsels
     * @param string $achterNaam
     * @param string $straat
     * @param int $huisNummer
     * @param string $huisNummerToev
     * @param string $postcode
     * @param string $plaats
     * @param string $land
     */
    public function __construct($bedrijfsNaam = null, $afdeling = null, $voorLettersNaam = null, $tussenvoegsels = null, $achterNaam = null, $straat = null, $huisNummer = null, $huisNummerToev = null, $postcode = null, $plaats = null, $land = null)
    {
        $this
            ->setBedrijfsNaam($bedrijfsNaam)
            ->setAfdeling($afdeling)
            ->setVoorLettersNaam($voorLettersNaam)
            ->setTussenvoegsels($tussenvoegsels)
            ->setAchterNaam($achterNaam)
            ->setStraat($straat)
            ->setHuisNummer($huisNummer)
            ->setHuisNummerToev($huisNummerToev)
            ->setPostcode($postcode)
            ->setPlaats($plaats)
            ->setLand($land);
    }
    /**
     * Get bedrijfsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsNaam()
    {
        return isset($this->bedrijfsNaam) ? $this->bedrijfsNaam : null;
    }
    /**
     * Set bedrijfsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsNaam
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setBedrijfsNaam($bedrijfsNaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsNaam) && !is_string($bedrijfsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bedrijfsNaam, true), gettype($bedrijfsNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($bedrijfsNaam) && mb_strlen($bedrijfsNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($bedrijfsNaam)), __LINE__);
        }
        if (is_null($bedrijfsNaam) || (is_array($bedrijfsNaam) && empty($bedrijfsNaam))) {
            unset($this->bedrijfsNaam);
        } else {
            $this->bedrijfsNaam = $bedrijfsNaam;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdeling, true), gettype($afdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdeling) && mb_strlen($afdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
    /**
     * Get voorLettersNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorLettersNaam()
    {
        return isset($this->voorLettersNaam) ? $this->voorLettersNaam : null;
    }
    /**
     * Set voorLettersNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorLettersNaam
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setVoorLettersNaam($voorLettersNaam = null)
    {
        // validation for constraint: string
        if (!is_null($voorLettersNaam) && !is_string($voorLettersNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorLettersNaam, true), gettype($voorLettersNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($voorLettersNaam) && mb_strlen($voorLettersNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($voorLettersNaam)), __LINE__);
        }
        if (is_null($voorLettersNaam) || (is_array($voorLettersNaam) && empty($voorLettersNaam))) {
            unset($this->voorLettersNaam);
        } else {
            $this->voorLettersNaam = $voorLettersNaam;
        }
        return $this;
    }
    /**
     * Get tussenvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsels()
    {
        return isset($this->tussenvoegsels) ? $this->tussenvoegsels : null;
    }
    /**
     * Set tussenvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsels
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setTussenvoegsels($tussenvoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsels) && !is_string($tussenvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tussenvoegsels, true), gettype($tussenvoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tussenvoegsels) && mb_strlen($tussenvoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tussenvoegsels)), __LINE__);
        }
        if (is_null($tussenvoegsels) || (is_array($tussenvoegsels) && empty($tussenvoegsels))) {
            unset($this->tussenvoegsels);
        } else {
            $this->tussenvoegsels = $tussenvoegsels;
        }
        return $this;
    }
    /**
     * Get achterNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchterNaam()
    {
        return isset($this->achterNaam) ? $this->achterNaam : null;
    }
    /**
     * Set achterNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achterNaam
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setAchterNaam($achterNaam = null)
    {
        // validation for constraint: string
        if (!is_null($achterNaam) && !is_string($achterNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achterNaam, true), gettype($achterNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achterNaam) && mb_strlen($achterNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achterNaam)), __LINE__);
        }
        if (is_null($achterNaam) || (is_array($achterNaam) && empty($achterNaam))) {
            unset($this->achterNaam);
        } else {
            $this->achterNaam = $achterNaam;
        }
        return $this;
    }
    /**
     * Get straat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStraat()
    {
        return isset($this->straat) ? $this->straat : null;
    }
    /**
     * Set straat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $straat
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setStraat($straat = null)
    {
        // validation for constraint: string
        if (!is_null($straat) && !is_string($straat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($straat, true), gettype($straat)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($straat) && mb_strlen($straat) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($straat)), __LINE__);
        }
        if (is_null($straat) || (is_array($straat) && empty($straat))) {
            unset($this->straat);
        } else {
            $this->straat = $straat;
        }
        return $this;
    }
    /**
     * Get huisNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHuisNummer()
    {
        return isset($this->huisNummer) ? $this->huisNummer : null;
    }
    /**
     * Set huisNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $huisNummer
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setHuisNummer($huisNummer = null)
    {
        // validation for constraint: int
        if (!is_null($huisNummer) && !(is_int($huisNummer) || ctype_digit($huisNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($huisNummer, true), gettype($huisNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($huisNummer) && mb_strlen(preg_replace('/(\D)/', '', $huisNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($huisNummer, true), mb_strlen(preg_replace('/(\D)/', '', $huisNummer))), __LINE__);
        }
        if (is_null($huisNummer) || (is_array($huisNummer) && empty($huisNummer))) {
            unset($this->huisNummer);
        } else {
            $this->huisNummer = $huisNummer;
        }
        return $this;
    }
    /**
     * Get huisNummerToev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisNummerToev()
    {
        return isset($this->huisNummerToev) ? $this->huisNummerToev : null;
    }
    /**
     * Set huisNummerToev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisNummerToev
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setHuisNummerToev($huisNummerToev = null)
    {
        // validation for constraint: string
        if (!is_null($huisNummerToev) && !is_string($huisNummerToev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisNummerToev, true), gettype($huisNummerToev)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($huisNummerToev) && mb_strlen($huisNummerToev) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($huisNummerToev)), __LINE__);
        }
        if (is_null($huisNummerToev) || (is_array($huisNummerToev) && empty($huisNummerToev))) {
            unset($this->huisNummerToev);
        } else {
            $this->huisNummerToev = $huisNummerToev;
        }
        return $this;
    }
    /**
     * Get postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->postcode) ? $this->postcode : null;
    }
    /**
     * Set postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->postcode);
        } else {
            $this->postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get plaats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPlaats()
    {
        return isset($this->plaats) ? $this->plaats : null;
    }
    /**
     * Set plaats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $plaats
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setPlaats($plaats = null)
    {
        // validation for constraint: string
        if (!is_null($plaats) && !is_string($plaats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaats, true), gettype($plaats)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plaats) && mb_strlen($plaats) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($plaats)), __LINE__);
        }
        if (is_null($plaats) || (is_array($plaats) && empty($plaats))) {
            unset($this->plaats);
        } else {
            $this->plaats = $plaats;
        }
        return $this;
    }
    /**
     * Get land value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLand()
    {
        return isset($this->land) ? $this->land : null;
    }
    /**
     * Set land value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $land
     * @return \AbonnementApiV6\StructType\FactuurAdres
     */
    public function setLand($land = null)
    {
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($land, true), gettype($land)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($land) && mb_strlen($land) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($land)), __LINE__);
        }
        if (is_null($land) || (is_array($land) && empty($land))) {
            unset($this->land);
        } else {
            $this->land = $land;
        }
        return $this;
    }
}
