<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatSubtot StructType
 * Meta information extracted from the WSDL
 * - documentation: Subtotaal regels van een factuur samenvatting.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvatSubtot extends AbstractStructBase
{
    /**
     * The subtotaalBedragExclBtw
     * Meta information extracted from the WSDL
     * - documentation: Subtotaal bedrag exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $subtotaalBedragExclBtw;
    /**
     * The omschrijving
     * Meta information extracted from the WSDL
     * - documentation: Regel omschrijving.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijving;
    /**
     * The periodeVan
     * Meta information extracted from the WSDL
     * - documentation: Periode, datum vanaf.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $periodeVan;
    /**
     * The periodeTm
     * Meta information extracted from the WSDL
     * - documentation: Periode, datum tot en met.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $periodeTm;
    /**
     * Constructor method for FactSamenvatSubtot
     * @uses FactSamenvatSubtot::setSubtotaalBedragExclBtw()
     * @uses FactSamenvatSubtot::setOmschrijving()
     * @uses FactSamenvatSubtot::setPeriodeVan()
     * @uses FactSamenvatSubtot::setPeriodeTm()
     * @param float $subtotaalBedragExclBtw
     * @param string $omschrijving
     * @param string $periodeVan
     * @param string $periodeTm
     */
    public function __construct($subtotaalBedragExclBtw = null, $omschrijving = null, $periodeVan = null, $periodeTm = null)
    {
        $this
            ->setSubtotaalBedragExclBtw($subtotaalBedragExclBtw)
            ->setOmschrijving($omschrijving)
            ->setPeriodeVan($periodeVan)
            ->setPeriodeTm($periodeTm);
    }
    /**
     * Get subtotaalBedragExclBtw value
     * @return float
     */
    public function getSubtotaalBedragExclBtw()
    {
        return $this->subtotaalBedragExclBtw;
    }
    /**
     * Set subtotaalBedragExclBtw value
     * @param float $subtotaalBedragExclBtw
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtot
     */
    public function setSubtotaalBedragExclBtw($subtotaalBedragExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($subtotaalBedragExclBtw) && !(is_float($subtotaalBedragExclBtw) || is_numeric($subtotaalBedragExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subtotaalBedragExclBtw, true), gettype($subtotaalBedragExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($subtotaalBedragExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $subtotaalBedragExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($subtotaalBedragExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $subtotaalBedragExclBtw))), __LINE__);
        }
        $this->subtotaalBedragExclBtw = $subtotaalBedragExclBtw;
        return $this;
    }
    /**
     * Get omschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijving()
    {
        return isset($this->omschrijving) ? $this->omschrijving : null;
    }
    /**
     * Set omschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijving
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtot
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($omschrijving)), __LINE__);
        }
        if (is_null($omschrijving) || (is_array($omschrijving) && empty($omschrijving))) {
            unset($this->omschrijving);
        } else {
            $this->omschrijving = $omschrijving;
        }
        return $this;
    }
    /**
     * Get periodeVan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodeVan()
    {
        return isset($this->periodeVan) ? $this->periodeVan : null;
    }
    /**
     * Set periodeVan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodeVan
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtot
     */
    public function setPeriodeVan($periodeVan = null)
    {
        // validation for constraint: string
        if (!is_null($periodeVan) && !is_string($periodeVan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodeVan, true), gettype($periodeVan)), __LINE__);
        }
        if (is_null($periodeVan) || (is_array($periodeVan) && empty($periodeVan))) {
            unset($this->periodeVan);
        } else {
            $this->periodeVan = $periodeVan;
        }
        return $this;
    }
    /**
     * Get periodeTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodeTm()
    {
        return isset($this->periodeTm) ? $this->periodeTm : null;
    }
    /**
     * Set periodeTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodeTm
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtot
     */
    public function setPeriodeTm($periodeTm = null)
    {
        // validation for constraint: string
        if (!is_null($periodeTm) && !is_string($periodeTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodeTm, true), gettype($periodeTm)), __LINE__);
        }
        if (is_null($periodeTm) || (is_array($periodeTm) && empty($periodeTm))) {
            unset($this->periodeTm);
        } else {
            $this->periodeTm = $periodeTm;
        }
        return $this;
    }
}
