<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvat StructType
 * Meta information extracted from the WSDL
 * - documentation: Samengevatte gegevens van een factuur.
 * @subpackage Structs
 * @date 20240419 package
 */
class FactSamenvat extends AbstractStructBase
{
    /**
     * The factuurNo
     * Meta information extracted from the WSDL
     * - documentation: Factuurnummer.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $factuurNo;
    /**
     * The factuurDatum
     * Meta information extracted from the WSDL
     * - documentation: Factuurdatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $factuurDatum;
    /**
     * The vervalDatum
     * Meta information extracted from the WSDL
     * - documentation: Vervaldatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $vervalDatum;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3,4,5] Status van de factuur: 0 = Voldaan, 1 = Niet voldaan, 2 = Vervallen, 3 = Naar incassobureau, 4 = Automatische incasso, 5 = Creditcard incasso.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The totaalExclBtw
     * Meta information extracted from the WSDL
     * - documentation: Totaal bedrag exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalExclBtw;
    /**
     * The totaalInclBtw
     * Meta information extracted from the WSDL
     * - documentation: Totaal bedrag inclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalInclBtw;
    /**
     * The subtotaalInfo
     * Meta information extracted from the WSDL
     * - documentation: Samengevatte factuur subtotaal info.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\FactSamenvatSubtotInfo
     */
    public $subtotaalInfo;
    /**
     * The btwInfo
     * Meta information extracted from the WSDL
     * - documentation: BTW gegevens van de factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\FactSamenvatBtwInfo
     */
    public $btwInfo;
    /**
     * Constructor method for FactSamenvat
     * @uses FactSamenvat::setFactuurNo()
     * @uses FactSamenvat::setFactuurDatum()
     * @uses FactSamenvat::setVervalDatum()
     * @uses FactSamenvat::setStatus()
     * @uses FactSamenvat::setTotaalExclBtw()
     * @uses FactSamenvat::setTotaalInclBtw()
     * @uses FactSamenvat::setSubtotaalInfo()
     * @uses FactSamenvat::setBtwInfo()
     * @param string $factuurNo
     * @param string $factuurDatum
     * @param string $vervalDatum
     * @param float $status
     * @param float $totaalExclBtw
     * @param float $totaalInclBtw
     * @param \AbonnementApiV6\StructType\FactSamenvatSubtotInfo $subtotaalInfo
     * @param \AbonnementApiV6\StructType\FactSamenvatBtwInfo $btwInfo
     */
    public function __construct($factuurNo = null, $factuurDatum = null, $vervalDatum = null, $status = null, $totaalExclBtw = null, $totaalInclBtw = null, \AbonnementApiV6\StructType\FactSamenvatSubtotInfo $subtotaalInfo = null, \AbonnementApiV6\StructType\FactSamenvatBtwInfo $btwInfo = null)
    {
        $this
            ->setFactuurNo($factuurNo)
            ->setFactuurDatum($factuurDatum)
            ->setVervalDatum($vervalDatum)
            ->setStatus($status)
            ->setTotaalExclBtw($totaalExclBtw)
            ->setTotaalInclBtw($totaalInclBtw)
            ->setSubtotaalInfo($subtotaalInfo)
            ->setBtwInfo($btwInfo);
    }
    /**
     * Get factuurNo value
     * @return string
     */
    public function getFactuurNo()
    {
        return $this->factuurNo;
    }
    /**
     * Set factuurNo value
     * @param string $factuurNo
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setFactuurNo($factuurNo = null)
    {
        // validation for constraint: string
        if (!is_null($factuurNo) && !is_string($factuurNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factuurNo, true), gettype($factuurNo)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($factuurNo) && mb_strlen($factuurNo) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($factuurNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($factuurNo) && mb_strlen($factuurNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($factuurNo)), __LINE__);
        }
        $this->factuurNo = $factuurNo;
        return $this;
    }
    /**
     * Get factuurDatum value
     * @return string
     */
    public function getFactuurDatum()
    {
        return $this->factuurDatum;
    }
    /**
     * Set factuurDatum value
     * @param string $factuurDatum
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setFactuurDatum($factuurDatum = null)
    {
        // validation for constraint: string
        if (!is_null($factuurDatum) && !is_string($factuurDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factuurDatum, true), gettype($factuurDatum)), __LINE__);
        }
        $this->factuurDatum = $factuurDatum;
        return $this;
    }
    /**
     * Get vervalDatum value
     * @return string
     */
    public function getVervalDatum()
    {
        return $this->vervalDatum;
    }
    /**
     * Set vervalDatum value
     * @param string $vervalDatum
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setVervalDatum($vervalDatum = null)
    {
        // validation for constraint: string
        if (!is_null($vervalDatum) && !is_string($vervalDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vervalDatum, true), gettype($vervalDatum)), __LINE__);
        }
        $this->vervalDatum = $vervalDatum;
        return $this;
    }
    /**
     * Get status value
     * @return float
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param float $status
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get totaalExclBtw value
     * @return float
     */
    public function getTotaalExclBtw()
    {
        return $this->totaalExclBtw;
    }
    /**
     * Set totaalExclBtw value
     * @param float $totaalExclBtw
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setTotaalExclBtw($totaalExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalExclBtw) && !(is_float($totaalExclBtw) || is_numeric($totaalExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalExclBtw, true), gettype($totaalExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw))), __LINE__);
        }
        $this->totaalExclBtw = $totaalExclBtw;
        return $this;
    }
    /**
     * Get totaalInclBtw value
     * @return float
     */
    public function getTotaalInclBtw()
    {
        return $this->totaalInclBtw;
    }
    /**
     * Set totaalInclBtw value
     * @param float $totaalInclBtw
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setTotaalInclBtw($totaalInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalInclBtw) && !(is_float($totaalInclBtw) || is_numeric($totaalInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalInclBtw, true), gettype($totaalInclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw))), __LINE__);
        }
        $this->totaalInclBtw = $totaalInclBtw;
        return $this;
    }
    /**
     * Get subtotaalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\FactSamenvatSubtotInfo|null
     */
    public function getSubtotaalInfo()
    {
        return isset($this->subtotaalInfo) ? $this->subtotaalInfo : null;
    }
    /**
     * Set subtotaalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\FactSamenvatSubtotInfo $subtotaalInfo
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setSubtotaalInfo(\AbonnementApiV6\StructType\FactSamenvatSubtotInfo $subtotaalInfo = null)
    {
        if (is_null($subtotaalInfo) || (is_array($subtotaalInfo) && empty($subtotaalInfo))) {
            unset($this->subtotaalInfo);
        } else {
            $this->subtotaalInfo = $subtotaalInfo;
        }
        return $this;
    }
    /**
     * Get btwInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\FactSamenvatBtwInfo|null
     */
    public function getBtwInfo()
    {
        return isset($this->btwInfo) ? $this->btwInfo : null;
    }
    /**
     * Set btwInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\FactSamenvatBtwInfo $btwInfo
     * @return \AbonnementApiV6\StructType\FactSamenvat
     */
    public function setBtwInfo(\AbonnementApiV6\StructType\FactSamenvatBtwInfo $btwInfo = null)
    {
        if (is_null($btwInfo) || (is_array($btwInfo) && empty($btwInfo))) {
            unset($this->btwInfo);
        } else {
            $this->btwInfo = $btwInfo;
        }
        return $this;
    }
}
