<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditieInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met edities
 * @subpackage Structs
 * @date 20240419 package
 */
class EditieInfo extends AbstractStructBase
{
    /**
     * The editie
     * Meta information extracted from the WSDL
     * - documentation: Lijst met edities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Editie[]
     */
    public $editie;
    /**
     * Constructor method for EditieInfo
     * @uses EditieInfo::setEditie()
     * @param \AbonnementApiV6\StructType\Editie[] $editie
     */
    public function __construct(array $editie = array())
    {
        $this
            ->setEditie($editie);
    }
    /**
     * Get editie value
     * @return \AbonnementApiV6\StructType\Editie[]|null
     */
    public function getEditie()
    {
        return $this->editie;
    }
    /**
     * This method is responsible for validating the values passed to the setEditie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEditie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEditieForArrayConstraintsFromSetEditie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $editieInfoEditieItem) {
            // validation for constraint: itemType
            if (!$editieInfoEditieItem instanceof \AbonnementApiV6\StructType\Editie) {
                $invalidValues[] = is_object($editieInfoEditieItem) ? get_class($editieInfoEditieItem) : sprintf('%s(%s)', gettype($editieInfoEditieItem), var_export($editieInfoEditieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The editie property can only contain items of type \AbonnementApiV6\StructType\Editie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set editie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Editie[] $editie
     * @return \AbonnementApiV6\StructType\EditieInfo
     */
    public function setEditie(array $editie = array())
    {
        // validation for constraint: array
        if ('' !== ($editieArrayErrorMessage = self::validateEditieForArrayConstraintsFromSetEditie($editie))) {
            throw new \InvalidArgumentException($editieArrayErrorMessage, __LINE__);
        }
        $this->editie = $editie;
        return $this;
    }
    /**
     * Add item to editie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Editie $item
     * @return \AbonnementApiV6\StructType\EditieInfo
     */
    public function addToEditie(\AbonnementApiV6\StructType\Editie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Editie) {
            throw new \InvalidArgumentException(sprintf('The editie property can only contain items of type \AbonnementApiV6\StructType\Editie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->editie[] = $item;
        return $this;
    }
}
