<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Editie StructType
 * Meta information extracted from the WSDL
 * - documentation: Gegevens van de editie.
 * @subpackage Structs
 * @date 20240419 package
 */
class Editie extends AbstractStructBase
{
    /**
     * The editieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de editie.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $editieCode;
    /**
     * The editieNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de editie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $editieNaam;
    /**
     * The editieNummer
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de editie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $editieNummer;
    /**
     * The editieVerschijndatum
     * Meta information extracted from the WSDL
     * - documentation: Verschijndatum van de editie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $editieVerschijndatum;
    /**
     * Constructor method for Editie
     * @uses Editie::setEditieCode()
     * @uses Editie::setEditieNaam()
     * @uses Editie::setEditieNummer()
     * @uses Editie::setEditieVerschijndatum()
     * @param string $editieCode
     * @param string $editieNaam
     * @param int $editieNummer
     * @param string $editieVerschijndatum
     */
    public function __construct($editieCode = null, $editieNaam = null, $editieNummer = null, $editieVerschijndatum = null)
    {
        $this
            ->setEditieCode($editieCode)
            ->setEditieNaam($editieNaam)
            ->setEditieNummer($editieNummer)
            ->setEditieVerschijndatum($editieVerschijndatum);
    }
    /**
     * Get editieCode value
     * @return string
     */
    public function getEditieCode()
    {
        return $this->editieCode;
    }
    /**
     * Set editieCode value
     * @param string $editieCode
     * @return \AbonnementApiV6\StructType\Editie
     */
    public function setEditieCode($editieCode = null)
    {
        // validation for constraint: string
        if (!is_null($editieCode) && !is_string($editieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($editieCode, true), gettype($editieCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($editieCode) && mb_strlen($editieCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($editieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($editieCode) && mb_strlen($editieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($editieCode)), __LINE__);
        }
        $this->editieCode = $editieCode;
        return $this;
    }
    /**
     * Get editieNaam value
     * @return string
     */
    public function getEditieNaam()
    {
        return $this->editieNaam;
    }
    /**
     * Set editieNaam value
     * @param string $editieNaam
     * @return \AbonnementApiV6\StructType\Editie
     */
    public function setEditieNaam($editieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($editieNaam) && !is_string($editieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($editieNaam, true), gettype($editieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($editieNaam) && mb_strlen($editieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($editieNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($editieNaam) && mb_strlen($editieNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($editieNaam)), __LINE__);
        }
        $this->editieNaam = $editieNaam;
        return $this;
    }
    /**
     * Get editieNummer value
     * @return int
     */
    public function getEditieNummer()
    {
        return $this->editieNummer;
    }
    /**
     * Set editieNummer value
     * @param int $editieNummer
     * @return \AbonnementApiV6\StructType\Editie
     */
    public function setEditieNummer($editieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($editieNummer) && !(is_int($editieNummer) || ctype_digit($editieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($editieNummer, true), gettype($editieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($editieNummer) && mb_strlen(preg_replace('/(\D)/', '', $editieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($editieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $editieNummer))), __LINE__);
        }
        $this->editieNummer = $editieNummer;
        return $this;
    }
    /**
     * Get editieVerschijndatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEditieVerschijndatum()
    {
        return isset($this->editieVerschijndatum) ? $this->editieVerschijndatum : null;
    }
    /**
     * Set editieVerschijndatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $editieVerschijndatum
     * @return \AbonnementApiV6\StructType\Editie
     */
    public function setEditieVerschijndatum($editieVerschijndatum = null)
    {
        // validation for constraint: string
        if (!is_null($editieVerschijndatum) && !is_string($editieVerschijndatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($editieVerschijndatum, true), gettype($editieVerschijndatum)), __LINE__);
        }
        if (is_null($editieVerschijndatum) || (is_array($editieVerschijndatum) && empty($editieVerschijndatum))) {
            unset($this->editieVerschijndatum);
        } else {
            $this->editieVerschijndatum = $editieVerschijndatum;
        }
        return $this;
    }
}
