<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createKlantPersoonResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error606: Er zijn afwijkende kandidaten gevonden | error601: Er zijn meerdere kandidaten gevonden | error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error218: Het IBAN nummer dient samen met de BIC code
 * opgegeven te worden | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht | error216: De BIC code is ongeldig | error215: Het IBAN nummer is ongeldig | error104: Het opgegeven geslacht is niet geldig | error90: De
 * opgegeven geboortedatum is niet geldig | error81: Het adres is niet gevonden in de postcodetabel | error72: Voor een provincie is een land verplicht | error69: De provincie is niet gekoppeld aan het land | error66: De provincie is niet gevonden |
 * error63: Het mobiele telefoonnummer is niet geldig | error62: De titulatuur is niet bekend | error38: Het telefoonnummer is niet geldig | error32: De adresgegevens ontbreken | error31: Het e-mail adres voldoet niet aan de eisen | error30: De
 * adresgegevens zijn niet compleet | error28: Bij een relatie is een naam verplicht | error2: Het land is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateKlantPersoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The isNieuweRelatie
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of een nieuwe relatie is aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatie;
    /**
     * The relNoResult
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van de relatie die is aangemaakt. Als isNieuweRelatie=0, dan wordt het relatienummer van de bestaande relatie terug gegeven.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for createKlantPersoonResponse
     * @uses CreateKlantPersoonResponse::setRequestTag()
     * @uses CreateKlantPersoonResponse::setIsNieuweRelatie()
     * @uses CreateKlantPersoonResponse::setRelNoResult()
     * @param string $requestTag
     * @param bool $isNieuweRelatie
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, $isNieuweRelatie = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setIsNieuweRelatie($isNieuweRelatie)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatie()
    {
        return isset($this->isNieuweRelatie) ? $this->isNieuweRelatie : null;
    }
    /**
     * Set isNieuweRelatie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatie
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonResponse
     */
    public function setIsNieuweRelatie($isNieuweRelatie = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatie) && !is_bool($isNieuweRelatie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatie, true), gettype($isNieuweRelatie)), __LINE__);
        }
        if (is_null($isNieuweRelatie) || (is_array($isNieuweRelatie) && empty($isNieuweRelatie))) {
            unset($this->isNieuweRelatie);
        } else {
            $this->isNieuweRelatie = $isNieuweRelatie;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \AbonnementApiV6\StructType\CreateKlantPersoonResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoResult) && !(is_int($relNoResult) || ctype_digit($relNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoResult, true), gettype($relNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoResult))), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
}
