<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createBezKlachtRelUitgaveResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error759: Onterechte niet bezorgd klacht. Op verschijningsdatum gold voor het abonnement een verzendstop | error758: Onterechte niet nabezorgd klacht. Termijn voor nabezorging is nog niet verstreken | error757: Onterechte niet
 * nabezorgd klacht. Bij de niet bezorgd klacht is niet om nazending verzocht | error756: Onterechte niet nabezorgd klacht. Er is geen niet bezorgd klacht gevonden voor de verschijning | error755: Klacht is reeds aangemeld | error754: Geen nazending
 * mogelijk voor post of ritbezorging | error753: Geen nazending mogelijk voor deze uitgave | error752: Verzoek tot nazending niet mogelijk. Verschijning is langer dan 3 dagen geleden | error751: Onterechte niet bezorgd klacht. Uiterste tijdstip
 * bezorging is niet verstreken | error267: Bij gekozen klachtonderwerp is nabezorging niet toegestaan | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden herleid | error123: LVK-punt was op de opgegeven datum
 * gesloten | error122: LVK-punt was op de opgegeven datum niet meer actief | error121: Het abonnement had op de opgegeven datum een vakantiestop | error120: Het abonnement werd op de opgegeven datum doorgestuurd naar een goed doel en ontving dus geen
 * blad | error119: Het abonnement krijgt op de opgegeven datum bonnen en geen blad | error118: Het abonnement had op de opgegeven datum geen recht op een blad of was niet actief | error117: Uiterste bezorgtijd is nog niet verstreken. Klacht is niet
 * geregistreerd | error116: Deze klacht is niet aan een abonnement en niet aan een LVK-punt gekoppeld en kan daarom niet ingevoerd worden | error80: Het klachtonderwerp is niet actief | error79: De klachtsoort is niet actief | error78: Op basis van de
 * klachtdatum is geen editie gevonden | error77: Het klachtonderwerp is niet gekoppeld bij de klachtsoort | error25: Er is geen datum voor de klacht opgegeven | error18: Er is geen klachtsoort opgegeven | error17: De default klachtstatus is niet
 * gevonden | error15: Het klachtonderwerp is niet bekend | error14: De klachtsoort is niet bekend | error13: Er is geen klachtsoort opgegeven | error12: Er is geen abonnement opgegeven | error1: Het abonnement is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateBezKlachtRelUitgaveResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The klachtToelichting
     * Meta information extracted from the WSDL
     * - documentation: Korte toelichting van de klacht. Kan door Zeno in het response aangevuld worden met een code t.b.v. het signaleren van herhaalde/erntige klachten, door bijv. de code '1HEK' toe te voegen aan de toelichting.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $klachtToelichting;
    /**
     * The klachtErnstig
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de klacht als ernstige klacht aangemerkt staat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtErnstig;
    /**
     * The klachtHerhaald
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de klacht als herhaalde klacht aangemerkt staat.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $klachtHerhaald;
    /**
     * The klachtNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de aangemaakte klacht.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $klachtNo;
    /**
     * The nabezorgingMogelijk
     * Meta information extracted from the WSDL
     * - documentation: Mogelijkheden voor nabezorging. [0,1,2,3]. 0 = Vandaag nog mogelijk, 1 = Na vandaag mogelijk, 2 = Niet meer mogelijk, 3 = Niet ondersteund.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $nabezorgingMogelijk;
    /**
     * Constructor method for createBezKlachtRelUitgaveResponse
     * @uses CreateBezKlachtRelUitgaveResponse::setRequestTag()
     * @uses CreateBezKlachtRelUitgaveResponse::setKlachtToelichting()
     * @uses CreateBezKlachtRelUitgaveResponse::setKlachtErnstig()
     * @uses CreateBezKlachtRelUitgaveResponse::setKlachtHerhaald()
     * @uses CreateBezKlachtRelUitgaveResponse::setKlachtNo()
     * @uses CreateBezKlachtRelUitgaveResponse::setNabezorgingMogelijk()
     * @param string $requestTag
     * @param string $klachtToelichting
     * @param bool $klachtErnstig
     * @param bool $klachtHerhaald
     * @param int $klachtNo
     * @param float $nabezorgingMogelijk
     */
    public function __construct($requestTag = null, $klachtToelichting = null, $klachtErnstig = null, $klachtHerhaald = null, $klachtNo = null, $nabezorgingMogelijk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setKlachtToelichting($klachtToelichting)
            ->setKlachtErnstig($klachtErnstig)
            ->setKlachtHerhaald($klachtHerhaald)
            ->setKlachtNo($klachtNo)
            ->setNabezorgingMogelijk($nabezorgingMogelijk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get klachtToelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKlachtToelichting()
    {
        return isset($this->klachtToelichting) ? $this->klachtToelichting : null;
    }
    /**
     * Set klachtToelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $klachtToelichting
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setKlachtToelichting($klachtToelichting = null)
    {
        // validation for constraint: string
        if (!is_null($klachtToelichting) && !is_string($klachtToelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klachtToelichting, true), gettype($klachtToelichting)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($klachtToelichting) && mb_strlen($klachtToelichting) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($klachtToelichting)), __LINE__);
        }
        if (is_null($klachtToelichting) || (is_array($klachtToelichting) && empty($klachtToelichting))) {
            unset($this->klachtToelichting);
        } else {
            $this->klachtToelichting = $klachtToelichting;
        }
        return $this;
    }
    /**
     * Get klachtErnstig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtErnstig()
    {
        return isset($this->klachtErnstig) ? $this->klachtErnstig : null;
    }
    /**
     * Set klachtErnstig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtErnstig
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setKlachtErnstig($klachtErnstig = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtErnstig) && !is_bool($klachtErnstig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtErnstig, true), gettype($klachtErnstig)), __LINE__);
        }
        if (is_null($klachtErnstig) || (is_array($klachtErnstig) && empty($klachtErnstig))) {
            unset($this->klachtErnstig);
        } else {
            $this->klachtErnstig = $klachtErnstig;
        }
        return $this;
    }
    /**
     * Get klachtHerhaald value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKlachtHerhaald()
    {
        return isset($this->klachtHerhaald) ? $this->klachtHerhaald : null;
    }
    /**
     * Set klachtHerhaald value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $klachtHerhaald
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setKlachtHerhaald($klachtHerhaald = null)
    {
        // validation for constraint: boolean
        if (!is_null($klachtHerhaald) && !is_bool($klachtHerhaald)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($klachtHerhaald, true), gettype($klachtHerhaald)), __LINE__);
        }
        if (is_null($klachtHerhaald) || (is_array($klachtHerhaald) && empty($klachtHerhaald))) {
            unset($this->klachtHerhaald);
        } else {
            $this->klachtHerhaald = $klachtHerhaald;
        }
        return $this;
    }
    /**
     * Get klachtNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKlachtNo()
    {
        return isset($this->klachtNo) ? $this->klachtNo : null;
    }
    /**
     * Set klachtNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $klachtNo
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setKlachtNo($klachtNo = null)
    {
        // validation for constraint: int
        if (!is_null($klachtNo) && !(is_int($klachtNo) || ctype_digit($klachtNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($klachtNo, true), gettype($klachtNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($klachtNo) && mb_strlen(preg_replace('/(\D)/', '', $klachtNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($klachtNo, true), mb_strlen(preg_replace('/(\D)/', '', $klachtNo))), __LINE__);
        }
        if (is_null($klachtNo) || (is_array($klachtNo) && empty($klachtNo))) {
            unset($this->klachtNo);
        } else {
            $this->klachtNo = $klachtNo;
        }
        return $this;
    }
    /**
     * Get nabezorgingMogelijk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getNabezorgingMogelijk()
    {
        return isset($this->nabezorgingMogelijk) ? $this->nabezorgingMogelijk : null;
    }
    /**
     * Set nabezorgingMogelijk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $nabezorgingMogelijk
     * @return \AbonnementApiV6\StructType\CreateBezKlachtRelUitgaveResponse
     */
    public function setNabezorgingMogelijk($nabezorgingMogelijk = null)
    {
        // validation for constraint: float
        if (!is_null($nabezorgingMogelijk) && !(is_float($nabezorgingMogelijk) || is_numeric($nabezorgingMogelijk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nabezorgingMogelijk, true), gettype($nabezorgingMogelijk)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($nabezorgingMogelijk) && mb_strlen(preg_replace('/(\D)/', '', $nabezorgingMogelijk)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($nabezorgingMogelijk, true), mb_strlen(preg_replace('/(\D)/', '', $nabezorgingMogelijk))), __LINE__);
        }
        if (is_null($nabezorgingMogelijk) || (is_array($nabezorgingMogelijk) && empty($nabezorgingMogelijk))) {
            unset($this->nabezorgingMogelijk);
        } else {
            $this->nabezorgingMogelijk = $nabezorgingMogelijk;
        }
        return $this;
    }
}
