<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboDebNawAboNoResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error702: Bij een abonnement is een actie verplicht | error701: Bij een abonnement is een herkomst verplicht | error608: Er zijn afwijkende kandidaten gevonden voor de debiteur | error603: Er zijn meerdere kandidaten gevonden voor de
 * debiteur | error601: LET OP: Deze fout krijgt voortaan een ander nummer 603: Er zijn meerdere kandidaten gevonden voor de debiteur | error283: Het op te volgen abonnement is geen actieabonnement | error282: Het is niet mogelijk een actieabonnement
 * aan te maken | error279: De eenmalige korting kan niet gebruikt worden in combinatie met de abonnementsoort | error278: De eenmalige korting is al tot het maximum aantal keer gebruikt | error277: De eenmalige korting valt buiten zijn
 * geldigheidsperiode | error273: Bij betaalwijze betaling via derden dient de debiteur voor betaling via derden geregistreerd te zijn | error269: Een abonnement mag maximaal 1 kortingsbedrag of kortingspercentage bevatten | error268: Een kortingsbedrag
 * of percentage mag niet negatief zijn | error265: Een betaalwijze anders dan factuur per mail is niet toegestaan voor dit abonnement | error264: Bij betaalwijze creditcard zijn gegevens van de creditcard verplicht | error263: De opgegeven vrije code 4
 * is niet bekend | error262: De opgegeven vrije code 2 is niet bekend | error261: De opgegeven vrije code 1 is niet bekend | error260: Een propositiecode dient in combinatie met een actiecode opgegeven te worden | error259: De opgegeven vrije code 3 is
 * niet bekend | error258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevonden | error257: De propositie is niet actief | error256: De proposie is niet gevonden | error242: Een losse eenmalige korting
 * mag niet in combinatie met een voorgedefinieerde eenmalige korting toegekend worden | error241: De eenmalige korting is niet actief en mag niet toegekend worden | error240: De eenmalige korting is niet gevonden | error227: De bij de debiteur
 * opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error226: Bij de debiteur dient het IBAN nummer samen met de BIC code opgegeven te worden | error225: De BIC code van de debiteur is ongeldig | error224: Het IBAN nummer van de debiteur is
 * ongeldig | error219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error218: Het IBAN nummer dient samen met de BIC code opgegeven te worden | error217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplicht |
 * error216: De BIC code is ongeldig | error215: Het IBAN nummer is ongeldig | error131: Een betaalwijze anders dan incasso is niet toegestaan voor dit abonnement | error129: Datum heeft een verkeerd formaat of kan niet tot een bestaande datum worden
 * herleid | error128: Het pakket is niet gekoppeld aan de actie | error127: De abonnementsoort is niet gekoppeld aan de actie | error107: Het abonnement kan niet aangemaakt worden. Voor de debiteur geldt een leververbod | error106: Het opgegeven
 * geslacht voor de debiteur is niet geldig | error98: De premium voor de debiteur is niet gekoppeld aan de propositie | error97: De premium voor de abonnee is niet gekoppeld aan de propositie | error96: De einddatum van de actie is verstreken |
 * error95: De ingangsdatum van de actie is nog niet ingegaan | error94: Er is geen abonnee opgegeven | error93: De abonnee is niet gevonden | error92: De abonnementsoort is niet bekend | error91: De premium voor de debiteur is niet actief | error89:
 * Het opgegeven pakket is niet actief | error88: Het opgegeven pakket is niet bekend | error85: Het is niet mogelijk een proefabonnement aan te maken | error84: Voor de abonnee is al een actief abonnement met dezelfde uitgave aanwezig (deze melding kan
 * dus niet optreden als geenControleLopendAbo als 1 meegegeven is in het request) | error83: Het adres voor de debiteur is niet gevonden in de postcodetabel | error76: Titulatuur voor de debiteur is niet gevonden | error74: Voor de provincie voor de
 * debiteur is een land verplicht | error71: De provincie voor de debiteur is niet gekoppeld aan het land | error68: De provincie voor de debiteur is niet gevonden | error65: Het mobiele telefoonnummer voor de debiteur is niet geldig | error58: De
 * premium voor de abonnee is niet actief | error57: De actie is niet actief | error56: De abonnementsoort is niet actief | error55: Het telefoonnummer van de debiteur is niet geldig | error54: Het e-mail adres van de debiteur voldoet niet aan de eisen
 * | error53: Het adres van de debiteur is incompleet | error52: Voor de debiteur ontbreken adresgegevens | error51: Voor de debiteur ontbreekt de achternaam | error48: Het land voor de debiteur is niet gevonden | error36: De herkomst is niet bekend |
 * error34: De actie is niet gevonden | error33: Geef of een abonnementsoort- of een pakketcode op | error26: Het opgegeven rekeningnummer voldoet niet | error16: De editie is niet gevonden | error4: Bij automatische incasso is een rekeningnummer
 * verplicht | error3: De betaalwijze is niet bekend
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAboDebNawAboNoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van het aangemaakte abonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The ingangsDatum
     * Meta information extracted from the WSDL
     * - documentation: Eerst mogelijke ingangsdatum van het abonnement. Afhankelijk van het type abonnementsoort is dit de verschijningsdatum van de eerstvolgende editie of de eerstvolgende datum waarop het abonnement kan starten, rekeninghoudend met zon-
     * en feestdagen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ingangsDatum;
    /**
     * The isNieuweRelatieDeb
     * Meta information extracted from the WSDL
     * - documentation: Terugkoppeling over het aanmaken van een nieuwe debiteur-relatie of het gebruiken van bestaande. false=Een bestaande relatie is gevonden, true=Een nieuwe relatie is aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isNieuweRelatieDeb;
    /**
     * The relNoAboResult
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van gebruikte relatie (kan afwijken van relNoAbo input in geval van ontdubbelde relatie).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAboResult;
    /**
     * The relNoDebResult
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de aangemaakte / bijgewerkte debiteur.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDebResult;
    /**
     * The machtigingsKenmerk
     * Meta information extracted from the WSDL
     * - documentation: Door Zeno aangemaakt machtigingskenmerk in geval van betaalwijze SEPA incasso.
     * - base: xsd:string
     * - maxLength: 35
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * Constructor method for createAboDebNawAboNoResponse
     * @uses CreateAboDebNawAboNoResponse::setRequestTag()
     * @uses CreateAboDebNawAboNoResponse::setAboNo()
     * @uses CreateAboDebNawAboNoResponse::setIngangsDatum()
     * @uses CreateAboDebNawAboNoResponse::setIsNieuweRelatieDeb()
     * @uses CreateAboDebNawAboNoResponse::setRelNoAboResult()
     * @uses CreateAboDebNawAboNoResponse::setRelNoDebResult()
     * @uses CreateAboDebNawAboNoResponse::setMachtigingsKenmerk()
     * @param string $requestTag
     * @param int $aboNo
     * @param string $ingangsDatum
     * @param bool $isNieuweRelatieDeb
     * @param int $relNoAboResult
     * @param int $relNoDebResult
     * @param string $machtigingsKenmerk
     */
    public function __construct($requestTag = null, $aboNo = null, $ingangsDatum = null, $isNieuweRelatieDeb = null, $relNoAboResult = null, $relNoDebResult = null, $machtigingsKenmerk = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setAboNo($aboNo)
            ->setIngangsDatum($ingangsDatum)
            ->setIsNieuweRelatieDeb($isNieuweRelatieDeb)
            ->setRelNoAboResult($relNoAboResult)
            ->setRelNoDebResult($relNoDebResult)
            ->setMachtigingsKenmerk($machtigingsKenmerk);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get ingangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngangsDatum()
    {
        return isset($this->ingangsDatum) ? $this->ingangsDatum : null;
    }
    /**
     * Set ingangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingangsDatum
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setIngangsDatum($ingangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($ingangsDatum) && !is_string($ingangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ingangsDatum, true), gettype($ingangsDatum)), __LINE__);
        }
        if (is_null($ingangsDatum) || (is_array($ingangsDatum) && empty($ingangsDatum))) {
            unset($this->ingangsDatum);
        } else {
            $this->ingangsDatum = $ingangsDatum;
        }
        return $this;
    }
    /**
     * Get isNieuweRelatieDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNieuweRelatieDeb()
    {
        return isset($this->isNieuweRelatieDeb) ? $this->isNieuweRelatieDeb : null;
    }
    /**
     * Set isNieuweRelatieDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNieuweRelatieDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setIsNieuweRelatieDeb($isNieuweRelatieDeb = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNieuweRelatieDeb) && !is_bool($isNieuweRelatieDeb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNieuweRelatieDeb, true), gettype($isNieuweRelatieDeb)), __LINE__);
        }
        if (is_null($isNieuweRelatieDeb) || (is_array($isNieuweRelatieDeb) && empty($isNieuweRelatieDeb))) {
            unset($this->isNieuweRelatieDeb);
        } else {
            $this->isNieuweRelatieDeb = $isNieuweRelatieDeb;
        }
        return $this;
    }
    /**
     * Get relNoAboResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAboResult()
    {
        return isset($this->relNoAboResult) ? $this->relNoAboResult : null;
    }
    /**
     * Set relNoAboResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAboResult
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setRelNoAboResult($relNoAboResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoAboResult) && !(is_int($relNoAboResult) || ctype_digit($relNoAboResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoAboResult, true), gettype($relNoAboResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoAboResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoAboResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoAboResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoAboResult))), __LINE__);
        }
        if (is_null($relNoAboResult) || (is_array($relNoAboResult) && empty($relNoAboResult))) {
            unset($this->relNoAboResult);
        } else {
            $this->relNoAboResult = $relNoAboResult;
        }
        return $this;
    }
    /**
     * Get relNoDebResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDebResult()
    {
        return isset($this->relNoDebResult) ? $this->relNoDebResult : null;
    }
    /**
     * Set relNoDebResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDebResult
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setRelNoDebResult($relNoDebResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoDebResult) && !(is_int($relNoDebResult) || ctype_digit($relNoDebResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoDebResult, true), gettype($relNoDebResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoDebResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoDebResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoDebResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoDebResult))), __LINE__);
        }
        if (is_null($relNoDebResult) || (is_array($relNoDebResult) && empty($relNoDebResult))) {
            unset($this->relNoDebResult);
        } else {
            $this->relNoDebResult = $relNoDebResult;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoResponse
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machtigingsKenmerk, true), gettype($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($machtigingsKenmerk) && mb_strlen($machtigingsKenmerk) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
}
