<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAboDebNawAboNoRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>createAboDebNoAboNo</b> te gebruiken i.c.m. de RelatieApiV6 om de relatie
 * aan te maken. </br></u> <br/> Aanmaken van een nieuw abonnement voor een relatie, waarbij het relatienummer van de abonnee en de NAW gegevens van de debiteur meegegeven kan worden.
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAboDebNawAboNoRequest extends AbstractStructBase
{
    /**
     * The relNoAbo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van de abonnee.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoAbo;
    /**
     * The persoonsObjectDeb
     * Meta information extracted from the WSDL
     * - documentation: Persoonsgegevens voor de betaler.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\PersoonsObject
     */
    public $persoonsObjectDeb;
    /**
     * The adresObjectDeb
     * Meta information extracted from the WSDL
     * - documentation: Adresgegevens voor de betaler.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AdresObject
     */
    public $adresObjectDeb;
    /**
     * The aboObject
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsgegevens.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboObject
     */
    public $aboObject;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The geenControleLopendAbo
     * Meta information extracted from the WSDL
     * - documentation: Controle actief abonnement niet uitvoeren voor deze aanvraag. Default false dus wel uitvoeren.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $geenControleLopendAbo;
    /**
     * The forceerNieuweKlant
     * Meta information extracted from the WSDL
     * - documentation: Aanmaken nieuwe klant forceren, dus niet controleren of de klant al bestaat. Default false dus wel controleren en eventueel bestaande klant gebruiken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerNieuweKlant;
    /**
     * The canCreate
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen relatie en abonnement aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createAboDebNawAboNoRequest
     * @uses CreateAboDebNawAboNoRequest::setRelNoAbo()
     * @uses CreateAboDebNawAboNoRequest::setPersoonsObjectDeb()
     * @uses CreateAboDebNawAboNoRequest::setAdresObjectDeb()
     * @uses CreateAboDebNawAboNoRequest::setAboObject()
     * @uses CreateAboDebNawAboNoRequest::setRequestTag()
     * @uses CreateAboDebNawAboNoRequest::setGeenControleLopendAbo()
     * @uses CreateAboDebNawAboNoRequest::setForceerNieuweKlant()
     * @uses CreateAboDebNawAboNoRequest::setCanCreate()
     * @param int $relNoAbo
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectDeb
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @param string $requestTag
     * @param bool $geenControleLopendAbo
     * @param bool $forceerNieuweKlant
     * @param bool $canCreate
     */
    public function __construct($relNoAbo = null, \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb = null, \AbonnementApiV6\StructType\AdresObject $adresObjectDeb = null, \AbonnementApiV6\StructType\AboObject $aboObject = null, $requestTag = null, $geenControleLopendAbo = null, $forceerNieuweKlant = null, $canCreate = null)
    {
        $this
            ->setRelNoAbo($relNoAbo)
            ->setPersoonsObjectDeb($persoonsObjectDeb)
            ->setAdresObjectDeb($adresObjectDeb)
            ->setAboObject($aboObject)
            ->setRequestTag($requestTag)
            ->setGeenControleLopendAbo($geenControleLopendAbo)
            ->setForceerNieuweKlant($forceerNieuweKlant)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNoAbo value
     * @return int
     */
    public function getRelNoAbo()
    {
        return $this->relNoAbo;
    }
    /**
     * Set relNoAbo value
     * @param int $relNoAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setRelNoAbo($relNoAbo = null)
    {
        // validation for constraint: int
        if (!is_null($relNoAbo) && !(is_int($relNoAbo) || ctype_digit($relNoAbo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoAbo, true), gettype($relNoAbo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoAbo) && mb_strlen(preg_replace('/(\D)/', '', $relNoAbo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoAbo, true), mb_strlen(preg_replace('/(\D)/', '', $relNoAbo))), __LINE__);
        }
        $this->relNoAbo = $relNoAbo;
        return $this;
    }
    /**
     * Get persoonsObjectDeb value
     * @return \AbonnementApiV6\StructType\PersoonsObject
     */
    public function getPersoonsObjectDeb()
    {
        return $this->persoonsObjectDeb;
    }
    /**
     * Set persoonsObjectDeb value
     * @param \AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setPersoonsObjectDeb(\AbonnementApiV6\StructType\PersoonsObject $persoonsObjectDeb = null)
    {
        $this->persoonsObjectDeb = $persoonsObjectDeb;
        return $this;
    }
    /**
     * Get adresObjectDeb value
     * @return \AbonnementApiV6\StructType\AdresObject
     */
    public function getAdresObjectDeb()
    {
        return $this->adresObjectDeb;
    }
    /**
     * Set adresObjectDeb value
     * @param \AbonnementApiV6\StructType\AdresObject $adresObjectDeb
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setAdresObjectDeb(\AbonnementApiV6\StructType\AdresObject $adresObjectDeb = null)
    {
        $this->adresObjectDeb = $adresObjectDeb;
        return $this;
    }
    /**
     * Get aboObject value
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function getAboObject()
    {
        return $this->aboObject;
    }
    /**
     * Set aboObject value
     * @param \AbonnementApiV6\StructType\AboObject $aboObject
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setAboObject(\AbonnementApiV6\StructType\AboObject $aboObject = null)
    {
        $this->aboObject = $aboObject;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get geenControleLopendAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGeenControleLopendAbo()
    {
        return isset($this->geenControleLopendAbo) ? $this->geenControleLopendAbo : null;
    }
    /**
     * Set geenControleLopendAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $geenControleLopendAbo
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setGeenControleLopendAbo($geenControleLopendAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($geenControleLopendAbo) && !is_bool($geenControleLopendAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geenControleLopendAbo, true), gettype($geenControleLopendAbo)), __LINE__);
        }
        if (is_null($geenControleLopendAbo) || (is_array($geenControleLopendAbo) && empty($geenControleLopendAbo))) {
            unset($this->geenControleLopendAbo);
        } else {
            $this->geenControleLopendAbo = $geenControleLopendAbo;
        }
        return $this;
    }
    /**
     * Get forceerNieuweKlant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerNieuweKlant()
    {
        return isset($this->forceerNieuweKlant) ? $this->forceerNieuweKlant : null;
    }
    /**
     * Set forceerNieuweKlant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerNieuweKlant
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setForceerNieuweKlant($forceerNieuweKlant = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerNieuweKlant) && !is_bool($forceerNieuweKlant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerNieuweKlant, true), gettype($forceerNieuweKlant)), __LINE__);
        }
        if (is_null($forceerNieuweKlant) || (is_array($forceerNieuweKlant) && empty($forceerNieuweKlant))) {
            unset($this->forceerNieuweKlant);
        } else {
            $this->forceerNieuweKlant = $forceerNieuweKlant;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \AbonnementApiV6\StructType\CreateAboDebNawAboNoRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
}
