<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addLicentiehouderRolRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Toevoegen van een rol aan een licentiehouder van een abonnement.
 * @subpackage Structs
 * @date 20240419 package
 */
class AddLicentiehouderRolRequest extends AbstractStructBase
{
    /**
     * The licentieNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de licentie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $licentieNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The rolOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de rol. Rol moet een bestaande rol bij de uitgave rollen zijn.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rolOmschrijving;
    /**
     * Constructor method for addLicentiehouderRolRequest
     * @uses AddLicentiehouderRolRequest::setLicentieNo()
     * @uses AddLicentiehouderRolRequest::setRequestTag()
     * @uses AddLicentiehouderRolRequest::setRolOmschrijving()
     * @param int $licentieNo
     * @param string $requestTag
     * @param string $rolOmschrijving
     */
    public function __construct($licentieNo = null, $requestTag = null, $rolOmschrijving = null)
    {
        $this
            ->setLicentieNo($licentieNo)
            ->setRequestTag($requestTag)
            ->setRolOmschrijving($rolOmschrijving);
    }
    /**
     * Get licentieNo value
     * @return int
     */
    public function getLicentieNo()
    {
        return $this->licentieNo;
    }
    /**
     * Set licentieNo value
     * @param int $licentieNo
     * @return \AbonnementApiV6\StructType\AddLicentiehouderRolRequest
     */
    public function setLicentieNo($licentieNo = null)
    {
        // validation for constraint: int
        if (!is_null($licentieNo) && !(is_int($licentieNo) || ctype_digit($licentieNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($licentieNo, true), gettype($licentieNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($licentieNo) && mb_strlen(preg_replace('/(\D)/', '', $licentieNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($licentieNo, true), mb_strlen(preg_replace('/(\D)/', '', $licentieNo))), __LINE__);
        }
        $this->licentieNo = $licentieNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\AddLicentiehouderRolRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get rolOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRolOmschrijving()
    {
        return isset($this->rolOmschrijving) ? $this->rolOmschrijving : null;
    }
    /**
     * Set rolOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rolOmschrijving
     * @return \AbonnementApiV6\StructType\AddLicentiehouderRolRequest
     */
    public function setRolOmschrijving($rolOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($rolOmschrijving) && !is_string($rolOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rolOmschrijving, true), gettype($rolOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($rolOmschrijving) && mb_strlen($rolOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($rolOmschrijving)), __LINE__);
        }
        if (is_null($rolOmschrijving) || (is_array($rolOmschrijving) && empty($rolOmschrijving))) {
            unset($this->rolOmschrijving);
        } else {
            $this->rolOmschrijving = $rolOmschrijving;
        }
        return $this;
    }
}
