<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActieInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden acties.
 * @subpackage Structs
 * @date 20240419 package
 */
class ActieInfo extends AbstractStructBase
{
    /**
     * The actie
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden acties.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\Actie[]
     */
    public $actie;
    /**
     * Constructor method for ActieInfo
     * @uses ActieInfo::setActie()
     * @param \AbonnementApiV6\StructType\Actie[] $actie
     */
    public function __construct(array $actie = array())
    {
        $this
            ->setActie($actie);
    }
    /**
     * Get actie value
     * @return \AbonnementApiV6\StructType\Actie[]|null
     */
    public function getActie()
    {
        return $this->actie;
    }
    /**
     * This method is responsible for validating the values passed to the setActie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActieForArrayConstraintsFromSetActie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $actieInfoActieItem) {
            // validation for constraint: itemType
            if (!$actieInfoActieItem instanceof \AbonnementApiV6\StructType\Actie) {
                $invalidValues[] = is_object($actieInfoActieItem) ? get_class($actieInfoActieItem) : sprintf('%s(%s)', gettype($actieInfoActieItem), var_export($actieInfoActieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The actie property can only contain items of type \AbonnementApiV6\StructType\Actie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set actie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Actie[] $actie
     * @return \AbonnementApiV6\StructType\ActieInfo
     */
    public function setActie(array $actie = array())
    {
        // validation for constraint: array
        if ('' !== ($actieArrayErrorMessage = self::validateActieForArrayConstraintsFromSetActie($actie))) {
            throw new \InvalidArgumentException($actieArrayErrorMessage, __LINE__);
        }
        $this->actie = $actie;
        return $this;
    }
    /**
     * Add item to actie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\Actie $item
     * @return \AbonnementApiV6\StructType\ActieInfo
     */
    public function addToActie(\AbonnementApiV6\StructType\Actie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\Actie) {
            throw new \InvalidArgumentException(sprintf('The actie property can only contain items of type \AbonnementApiV6\StructType\Actie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->actie[] = $item;
        return $this;
    }
}
