<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbonnementInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst relaties met gevonden abonnementen.
 * @subpackage Structs
 * @date 20240419 package
 */
class AbonnementInfo extends AbstractStructBase
{
    /**
     * The aboRelatie
     * Meta information extracted from the WSDL
     * - documentation: Lijst relaties met gevonden abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboRelatie[]
     */
    public $aboRelatie;
    /**
     * Constructor method for AbonnementInfo
     * @uses AbonnementInfo::setAboRelatie()
     * @param \AbonnementApiV6\StructType\AboRelatie[] $aboRelatie
     */
    public function __construct(array $aboRelatie = array())
    {
        $this
            ->setAboRelatie($aboRelatie);
    }
    /**
     * Get aboRelatie value
     * @return \AbonnementApiV6\StructType\AboRelatie[]|null
     */
    public function getAboRelatie()
    {
        return $this->aboRelatie;
    }
    /**
     * This method is responsible for validating the values passed to the setAboRelatie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAboRelatie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAboRelatieForArrayConstraintsFromSetAboRelatie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abonnementInfoAboRelatieItem) {
            // validation for constraint: itemType
            if (!$abonnementInfoAboRelatieItem instanceof \AbonnementApiV6\StructType\AboRelatie) {
                $invalidValues[] = is_object($abonnementInfoAboRelatieItem) ? get_class($abonnementInfoAboRelatieItem) : sprintf('%s(%s)', gettype($abonnementInfoAboRelatieItem), var_export($abonnementInfoAboRelatieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aboRelatie property can only contain items of type \AbonnementApiV6\StructType\AboRelatie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aboRelatie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboRelatie[] $aboRelatie
     * @return \AbonnementApiV6\StructType\AbonnementInfo
     */
    public function setAboRelatie(array $aboRelatie = array())
    {
        // validation for constraint: array
        if ('' !== ($aboRelatieArrayErrorMessage = self::validateAboRelatieForArrayConstraintsFromSetAboRelatie($aboRelatie))) {
            throw new \InvalidArgumentException($aboRelatieArrayErrorMessage, __LINE__);
        }
        $this->aboRelatie = $aboRelatie;
        return $this;
    }
    /**
     * Add item to aboRelatie value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboRelatie $item
     * @return \AbonnementApiV6\StructType\AbonnementInfo
     */
    public function addToAboRelatie(\AbonnementApiV6\StructType\AboRelatie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\AboRelatie) {
            throw new \InvalidArgumentException(sprintf('The aboRelatie property can only contain items of type \AbonnementApiV6\StructType\AboRelatie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aboRelatie[] = $item;
        return $this;
    }
}
