<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Abonnement StructType
 * Meta information extracted from the WSDL
 * - documentation: Abonnement.
 * @subpackage Structs
 * @date 20240419 package
 */
class Abonnement extends AbstractStructBase
{
    /**
     * The aboKlachten
     * Meta information extracted from the WSDL
     * - documentation: Klachten.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\KlachtTab
     */
    public $aboKlachten;
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Abonnementsnummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboNo;
    /**
     * The aboSoortIncassoVerplicht
     * Meta information extracted from the WSDL
     * - documentation: Indicatie automatisch incasso verplicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboSoortIncassoVerplicht;
    /**
     * The aboSoortProefAbo
     * Meta information extracted from the WSDL
     * - documentation: Indicatie proefabonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboSoortProefAbo;
    /**
     * The aboSoortActieAbo
     * Meta information extracted from the WSDL
     * - documentation: Indicatie actieabonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboSoortActieAbo;
    /**
     * The aboSoortVrijeCode1
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 1 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode1;
    /**
     * The aboSoortVrijeCode2
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 2 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode2;
    /**
     * The aboSoortVrijeCode3
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 3 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode3;
    /**
     * The aboSoortVrijeCode4
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 4 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode4;
    /**
     * The aboSoortVrijeCode5
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 5 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode5;
    /**
     * The aboSoortVrijeCode6
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 6 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode6;
    /**
     * The aboSoortVrijeCode7
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 7 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode7;
    /**
     * The aboSoortVrijeCode8
     * Meta information extracted from the WSDL
     * - documentation: Vrije code 8 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeCode8;
    /**
     * The aboSoortVrijeTekst1
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 1 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst1;
    /**
     * The aboSoortVrijeTekst2
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 2 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst2;
    /**
     * The aboSoortVrijeTekst3
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 3 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst3;
    /**
     * The aboSoortVrijeTekst4
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 4 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst4;
    /**
     * The aboSoortVrijeTekst5
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 5 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst5;
    /**
     * The aboSoortVrijeTekst6
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 6 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst6;
    /**
     * The aboSoortVrijeTekst7
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 7 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst7;
    /**
     * The aboSoortVrijeTekst8
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 8 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst8;
    /**
     * The aboSoortVrijeTekst9
     * Meta information extracted from the WSDL
     * - documentation: Vrije tekst 9 abonnementsoort.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboSoortVrijeTekst9;
    /**
     * The aboVerschInfos
     * Meta information extracted from the WSDL
     * - documentation: Verschijningen retourneert een lijst met recente verschijningen van het abonnement. De informatie van de verschijningen bepaalt o.a. of er (nu) over een verschijning geklaagd mag worden, en of het mogelijk is een klacht in te voeren
     * met een verzoek om nabezorging. <br/>Business rules: <br/>N.B. indien op basis van het redelivery-type van PCM, dat in de P5 koppeling wordt doorgegeven aan Zeno, bepaald is dat voor een verschijning niet kan worden nabezorgd, dan worden de velden
     * NaBezZelfdeDagMogelijkTot en NaBezorgingMogelijkTot als NULL (=Leeg) teruggegeven.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VerschInfoTab
     */
    public $aboVerschInfos;
    /**
     * The aboVrijeVelden
     * Meta information extracted from the WSDL
     * - documentation: Vrije velden van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijeVeldenAboRec
     */
    public $aboVrijeVelden;
    /**
     * The abonnementSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de abonnementsoort van het abonnement.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementSoortCode;
    /**
     * The abonnementSoortNaam
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de abonnementsoort van het abonnement.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementSoortNaam;
    /**
     * The actieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de actie van het abonnement.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieCode;
    /**
     * The actieNaam
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de actie van het abonnement.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieNaam;
    /**
     * The artikelGroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de artikelgroep van het abonnement (N.B. => Oude product).
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepCode;
    /**
     * The artikelGroepNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de artikelgroep van het abonnement (N.B. => Oude product).
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepNaam;
    /**
     * The artikelHoofdGroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de artikelhoofdgroep van het abonnement.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelHoofdGroepCode;
    /**
     * The artikelHoofdGroepNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de artikelhoofdgroep van het abonnement.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelHoofdGroepNaam;
    /**
     * The bankRekeningNummer
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer voor het abonnement.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankRekeningNummer;
    /**
     * The bankIbanNummer
     * Meta information extracted from the WSDL
     * - documentation: IBAN voor het abonnement.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankIbanNummer;
    /**
     * The bankBicCode
     * Meta information extracted from the WSDL
     * - documentation: BIC voor het abonnement.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankBicCode;
    /**
     * The betaalwijze
     * Meta information extracted from the WSDL
     * - documentation: [0,1,3,4,7,9] Betaalwijze voor het abonnement: 0 = Factuur, 1 = Eenmalige incasso, 3 = Eenmalige ideal, 4 = Factuur per mail, 7 = Creditcard, 9 = Betaling via derden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $betaalwijze;
    /**
     * The eindDatum
     * Meta information extracted from the WSDL
     * - documentation: Einddatum van het abonnement (is een t/m datum, dus na deze dag is het abonnement niet meer actief).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $eindDatum;
    /**
     * The herkomstCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de herkomst van het abonnement.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $herkomstCode;
    /**
     * The herkomstNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de herkomst van het abonnement.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $herkomstNaam;
    /**
     * The ingangsDatum
     * Meta information extracted from the WSDL
     * - documentation: Daadwerkelijke ingangsdatum van het abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ingangsDatum;
    /**
     * The pakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het pakket van het abonnement.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van het pakket van het abonnement.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketNaam;
    /**
     * The premiumAboCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de premium voor de abonnee.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumAboCode;
    /**
     * The premiumAboNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de premium voor de abonnee.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumAboNaam;
    /**
     * The premiumDebCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de premium voor de debiteur.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumDebCode;
    /**
     * The premiumDebNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de premium voor de debiteur.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumDebNaam;
    /**
     * The relNoAbo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer abonnee.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoAbo;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave van het abonnement.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de uitgave.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The leverStatus
     * Meta information extracted from the WSDL
     * - documentation: Leverstatus van het abonnement (mogelijke waarden: ACTIEF, VERZENDSTOP, VERZENDFACTUURSTOP, INCOMPLEET = In afwachting van betaalmachtiging, WANBETALER = Geblokkeerd, INCOMPLEETVERLOPEN = Incompleet archief/verlopen, ARCHIEF).
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverStatus;
    /**
     * The aantalExemplaren
     * Meta information extracted from the WSDL
     * - documentation: Aantal exemplaren te verzenden bij dit abonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantalExemplaren;
    /**
     * The organisatieLicentie
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of dit een organisatie licentie abonnement betreft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $organisatieLicentie;
    /**
     * The machtigingsKenmerk
     * Meta information extracted from the WSDL
     * - documentation: Machtigingskenmerk in geval van automatische incasso i.c.m. SEPA.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $machtigingsKenmerk;
    /**
     * The aboRollen
     * Meta information extracted from the WSDL
     * - documentation: Abonnements rollen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\RolInfo
     */
    public $aboRollen;
    /**
     * The relNoDeb
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer debiteur.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoDeb;
    /**
     * The prijsExtern
     * Meta information extracted from the WSDL
     * - documentation: Extern bepaalde prijs voor het abonnement (let op, indien pakket geldt de prijs voor het hele pakket).
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijsExtern;
    /**
     * The prijsPropositie
     * Meta information extracted from the WSDL
     * - documentation: Propositieprijs geldend voor eerste contracttermijn (let op, indien pakket geldt de prijs voor het hele pakket).
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijsPropositie;
    /**
     * The propositieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de propositie waarmee het abonnement aangemaakt is
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $propositieCode;
    /**
     * The propositieNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de propositie waarmee het abonnement aangemaakt is
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $propositieNaam;
    /**
     * The pakketVrijeCode1
     * Meta information extracted from the WSDL
     * - documentation: De code van de vrije code 1 van het pakket
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketVrijeCode1;
    /**
     * The pakketVrijeNaam1
     * Meta information extracted from the WSDL
     * - documentation: De naam van de vrije code 1 van het pakket
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketVrijeNaam1;
    /**
     * The aboOrdernummer
     * Meta information extracted from the WSDL
     * - documentation: Ordernummer van besteller ter referentie
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboOrdernummer;
    /**
     * The aboCreditcard
     * Meta information extracted from the WSDL
     * - documentation: Creditcard gegevens (gevuld indien betaalwijze=7)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\Creditcard
     */
    public $aboCreditcard;
    /**
     * The factuurAdres
     * Meta information extracted from the WSDL
     * - documentation: Gegevens van het huidige factuur adres en tenaam stelling van de factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\FactuurAdres
     */
    public $factuurAdres;
    /**
     * The datumLaatstVerzEditie
     * Meta information extracted from the WSDL
     * - documentation: De verschijningsdatum van de laatst verzonden editie van dit abonnement, als die kan worden bepaald. Een dag later is bijvoorbeeld de eerst mogelijke verhuisdatum of de eerst mogelijke datum dat een vakantieregeling kan worden
     * aangemaakt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumLaatstVerzEditie;
    /**
     * The stopredenCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de stopreden.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $stopredenCode;
    /**
     * The stopredenNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de stopreden.
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $stopredenNaam;
    /**
     * The verzendingBestandType
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3,4] Bestandtype voor verzending: 0 (Default) is standaard verzending. 4 is Overig. Waarden 1, 2 en 3 zijn klantspecifiek toe te wijzen
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $verzendingBestandType;
    /**
     * The aboOnderbrekingActief
     * Meta information extracted from the WSDL
     * - documentation: Geeft aan of er momenteel een onderbreking actief is op dit abonnement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboOnderbrekingActief;
    /**
     * The pakketVolgnummer
     * Meta information extracted from the WSDL
     * - documentation: Pakket volgnummer (Kan gebruikt worden om abonnementen die samen in een pakket zitten te identificeren)
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $pakketVolgnummer;
    /**
     * The ingangsEditie
     * Meta information extracted from the WSDL
     * - documentation: Eerste editie waar de abonnee recht op heeft
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 7
     * @var int
     */
    public $ingangsEditie;
    /**
     * The eindeEditie
     * Meta information extracted from the WSDL
     * - documentation: Laatste editie waar de abonnee recht op heeft. Indien leeg: is het abonnement niet gestopt.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 7
     * @var int
     */
    public $eindeEditie;
    /**
     * Constructor method for Abonnement
     * @uses Abonnement::setAboKlachten()
     * @uses Abonnement::setAboNo()
     * @uses Abonnement::setAboSoortIncassoVerplicht()
     * @uses Abonnement::setAboSoortProefAbo()
     * @uses Abonnement::setAboSoortActieAbo()
     * @uses Abonnement::setAboSoortVrijeCode1()
     * @uses Abonnement::setAboSoortVrijeCode2()
     * @uses Abonnement::setAboSoortVrijeCode3()
     * @uses Abonnement::setAboSoortVrijeCode4()
     * @uses Abonnement::setAboSoortVrijeCode5()
     * @uses Abonnement::setAboSoortVrijeCode6()
     * @uses Abonnement::setAboSoortVrijeCode7()
     * @uses Abonnement::setAboSoortVrijeCode8()
     * @uses Abonnement::setAboSoortVrijeTekst1()
     * @uses Abonnement::setAboSoortVrijeTekst2()
     * @uses Abonnement::setAboSoortVrijeTekst3()
     * @uses Abonnement::setAboSoortVrijeTekst4()
     * @uses Abonnement::setAboSoortVrijeTekst5()
     * @uses Abonnement::setAboSoortVrijeTekst6()
     * @uses Abonnement::setAboSoortVrijeTekst7()
     * @uses Abonnement::setAboSoortVrijeTekst8()
     * @uses Abonnement::setAboSoortVrijeTekst9()
     * @uses Abonnement::setAboVerschInfos()
     * @uses Abonnement::setAboVrijeVelden()
     * @uses Abonnement::setAbonnementSoortCode()
     * @uses Abonnement::setAbonnementSoortNaam()
     * @uses Abonnement::setActieCode()
     * @uses Abonnement::setActieNaam()
     * @uses Abonnement::setArtikelGroepCode()
     * @uses Abonnement::setArtikelGroepNaam()
     * @uses Abonnement::setArtikelHoofdGroepCode()
     * @uses Abonnement::setArtikelHoofdGroepNaam()
     * @uses Abonnement::setBankRekeningNummer()
     * @uses Abonnement::setBankIbanNummer()
     * @uses Abonnement::setBankBicCode()
     * @uses Abonnement::setBetaalwijze()
     * @uses Abonnement::setEindDatum()
     * @uses Abonnement::setHerkomstCode()
     * @uses Abonnement::setHerkomstNaam()
     * @uses Abonnement::setIngangsDatum()
     * @uses Abonnement::setPakketCode()
     * @uses Abonnement::setPakketNaam()
     * @uses Abonnement::setPremiumAboCode()
     * @uses Abonnement::setPremiumAboNaam()
     * @uses Abonnement::setPremiumDebCode()
     * @uses Abonnement::setPremiumDebNaam()
     * @uses Abonnement::setRelNoAbo()
     * @uses Abonnement::setUitgaveCode()
     * @uses Abonnement::setUitgaveNaam()
     * @uses Abonnement::setLeverStatus()
     * @uses Abonnement::setAantalExemplaren()
     * @uses Abonnement::setOrganisatieLicentie()
     * @uses Abonnement::setMachtigingsKenmerk()
     * @uses Abonnement::setAboRollen()
     * @uses Abonnement::setRelNoDeb()
     * @uses Abonnement::setPrijsExtern()
     * @uses Abonnement::setPrijsPropositie()
     * @uses Abonnement::setPropositieCode()
     * @uses Abonnement::setPropositieNaam()
     * @uses Abonnement::setPakketVrijeCode1()
     * @uses Abonnement::setPakketVrijeNaam1()
     * @uses Abonnement::setAboOrdernummer()
     * @uses Abonnement::setAboCreditcard()
     * @uses Abonnement::setFactuurAdres()
     * @uses Abonnement::setDatumLaatstVerzEditie()
     * @uses Abonnement::setStopredenCode()
     * @uses Abonnement::setStopredenNaam()
     * @uses Abonnement::setVerzendingBestandType()
     * @uses Abonnement::setAboOnderbrekingActief()
     * @uses Abonnement::setPakketVolgnummer()
     * @uses Abonnement::setIngangsEditie()
     * @uses Abonnement::setEindeEditie()
     * @param \AbonnementApiV6\StructType\KlachtTab $aboKlachten
     * @param int $aboNo
     * @param bool $aboSoortIncassoVerplicht
     * @param bool $aboSoortProefAbo
     * @param bool $aboSoortActieAbo
     * @param string $aboSoortVrijeCode1
     * @param string $aboSoortVrijeCode2
     * @param string $aboSoortVrijeCode3
     * @param string $aboSoortVrijeCode4
     * @param string $aboSoortVrijeCode5
     * @param string $aboSoortVrijeCode6
     * @param string $aboSoortVrijeCode7
     * @param string $aboSoortVrijeCode8
     * @param string $aboSoortVrijeTekst1
     * @param string $aboSoortVrijeTekst2
     * @param string $aboSoortVrijeTekst3
     * @param string $aboSoortVrijeTekst4
     * @param string $aboSoortVrijeTekst5
     * @param string $aboSoortVrijeTekst6
     * @param string $aboSoortVrijeTekst7
     * @param string $aboSoortVrijeTekst8
     * @param string $aboSoortVrijeTekst9
     * @param \AbonnementApiV6\StructType\VerschInfoTab $aboVerschInfos
     * @param \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden
     * @param string $abonnementSoortCode
     * @param string $abonnementSoortNaam
     * @param string $actieCode
     * @param string $actieNaam
     * @param string $artikelGroepCode
     * @param string $artikelGroepNaam
     * @param string $artikelHoofdGroepCode
     * @param string $artikelHoofdGroepNaam
     * @param string $bankRekeningNummer
     * @param string $bankIbanNummer
     * @param string $bankBicCode
     * @param int $betaalwijze
     * @param string $eindDatum
     * @param string $herkomstCode
     * @param string $herkomstNaam
     * @param string $ingangsDatum
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param string $premiumAboCode
     * @param string $premiumAboNaam
     * @param string $premiumDebCode
     * @param string $premiumDebNaam
     * @param int $relNoAbo
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param string $leverStatus
     * @param int $aantalExemplaren
     * @param bool $organisatieLicentie
     * @param string $machtigingsKenmerk
     * @param \AbonnementApiV6\StructType\RolInfo $aboRollen
     * @param int $relNoDeb
     * @param float $prijsExtern
     * @param float $prijsPropositie
     * @param string $propositieCode
     * @param string $propositieNaam
     * @param string $pakketVrijeCode1
     * @param string $pakketVrijeNaam1
     * @param string $aboOrdernummer
     * @param \AbonnementApiV6\StructType\Creditcard $aboCreditcard
     * @param \AbonnementApiV6\StructType\FactuurAdres $factuurAdres
     * @param string $datumLaatstVerzEditie
     * @param string $stopredenCode
     * @param string $stopredenNaam
     * @param int $verzendingBestandType
     * @param bool $aboOnderbrekingActief
     * @param int $pakketVolgnummer
     * @param int $ingangsEditie
     * @param int $eindeEditie
     */
    public function __construct(\AbonnementApiV6\StructType\KlachtTab $aboKlachten = null, $aboNo = null, $aboSoortIncassoVerplicht = null, $aboSoortProefAbo = null, $aboSoortActieAbo = null, $aboSoortVrijeCode1 = null, $aboSoortVrijeCode2 = null, $aboSoortVrijeCode3 = null, $aboSoortVrijeCode4 = null, $aboSoortVrijeCode5 = null, $aboSoortVrijeCode6 = null, $aboSoortVrijeCode7 = null, $aboSoortVrijeCode8 = null, $aboSoortVrijeTekst1 = null, $aboSoortVrijeTekst2 = null, $aboSoortVrijeTekst3 = null, $aboSoortVrijeTekst4 = null, $aboSoortVrijeTekst5 = null, $aboSoortVrijeTekst6 = null, $aboSoortVrijeTekst7 = null, $aboSoortVrijeTekst8 = null, $aboSoortVrijeTekst9 = null, \AbonnementApiV6\StructType\VerschInfoTab $aboVerschInfos = null, \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden = null, $abonnementSoortCode = null, $abonnementSoortNaam = null, $actieCode = null, $actieNaam = null, $artikelGroepCode = null, $artikelGroepNaam = null, $artikelHoofdGroepCode = null, $artikelHoofdGroepNaam = null, $bankRekeningNummer = null, $bankIbanNummer = null, $bankBicCode = null, $betaalwijze = null, $eindDatum = null, $herkomstCode = null, $herkomstNaam = null, $ingangsDatum = null, $pakketCode = null, $pakketNaam = null, $premiumAboCode = null, $premiumAboNaam = null, $premiumDebCode = null, $premiumDebNaam = null, $relNoAbo = null, $uitgaveCode = null, $uitgaveNaam = null, $leverStatus = null, $aantalExemplaren = null, $organisatieLicentie = null, $machtigingsKenmerk = null, \AbonnementApiV6\StructType\RolInfo $aboRollen = null, $relNoDeb = null, $prijsExtern = null, $prijsPropositie = null, $propositieCode = null, $propositieNaam = null, $pakketVrijeCode1 = null, $pakketVrijeNaam1 = null, $aboOrdernummer = null, \AbonnementApiV6\StructType\Creditcard $aboCreditcard = null, \AbonnementApiV6\StructType\FactuurAdres $factuurAdres = null, $datumLaatstVerzEditie = null, $stopredenCode = null, $stopredenNaam = null, $verzendingBestandType = null, $aboOnderbrekingActief = null, $pakketVolgnummer = null, $ingangsEditie = null, $eindeEditie = null)
    {
        $this
            ->setAboKlachten($aboKlachten)
            ->setAboNo($aboNo)
            ->setAboSoortIncassoVerplicht($aboSoortIncassoVerplicht)
            ->setAboSoortProefAbo($aboSoortProefAbo)
            ->setAboSoortActieAbo($aboSoortActieAbo)
            ->setAboSoortVrijeCode1($aboSoortVrijeCode1)
            ->setAboSoortVrijeCode2($aboSoortVrijeCode2)
            ->setAboSoortVrijeCode3($aboSoortVrijeCode3)
            ->setAboSoortVrijeCode4($aboSoortVrijeCode4)
            ->setAboSoortVrijeCode5($aboSoortVrijeCode5)
            ->setAboSoortVrijeCode6($aboSoortVrijeCode6)
            ->setAboSoortVrijeCode7($aboSoortVrijeCode7)
            ->setAboSoortVrijeCode8($aboSoortVrijeCode8)
            ->setAboSoortVrijeTekst1($aboSoortVrijeTekst1)
            ->setAboSoortVrijeTekst2($aboSoortVrijeTekst2)
            ->setAboSoortVrijeTekst3($aboSoortVrijeTekst3)
            ->setAboSoortVrijeTekst4($aboSoortVrijeTekst4)
            ->setAboSoortVrijeTekst5($aboSoortVrijeTekst5)
            ->setAboSoortVrijeTekst6($aboSoortVrijeTekst6)
            ->setAboSoortVrijeTekst7($aboSoortVrijeTekst7)
            ->setAboSoortVrijeTekst8($aboSoortVrijeTekst8)
            ->setAboSoortVrijeTekst9($aboSoortVrijeTekst9)
            ->setAboVerschInfos($aboVerschInfos)
            ->setAboVrijeVelden($aboVrijeVelden)
            ->setAbonnementSoortCode($abonnementSoortCode)
            ->setAbonnementSoortNaam($abonnementSoortNaam)
            ->setActieCode($actieCode)
            ->setActieNaam($actieNaam)
            ->setArtikelGroepCode($artikelGroepCode)
            ->setArtikelGroepNaam($artikelGroepNaam)
            ->setArtikelHoofdGroepCode($artikelHoofdGroepCode)
            ->setArtikelHoofdGroepNaam($artikelHoofdGroepNaam)
            ->setBankRekeningNummer($bankRekeningNummer)
            ->setBankIbanNummer($bankIbanNummer)
            ->setBankBicCode($bankBicCode)
            ->setBetaalwijze($betaalwijze)
            ->setEindDatum($eindDatum)
            ->setHerkomstCode($herkomstCode)
            ->setHerkomstNaam($herkomstNaam)
            ->setIngangsDatum($ingangsDatum)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPremiumAboCode($premiumAboCode)
            ->setPremiumAboNaam($premiumAboNaam)
            ->setPremiumDebCode($premiumDebCode)
            ->setPremiumDebNaam($premiumDebNaam)
            ->setRelNoAbo($relNoAbo)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setLeverStatus($leverStatus)
            ->setAantalExemplaren($aantalExemplaren)
            ->setOrganisatieLicentie($organisatieLicentie)
            ->setMachtigingsKenmerk($machtigingsKenmerk)
            ->setAboRollen($aboRollen)
            ->setRelNoDeb($relNoDeb)
            ->setPrijsExtern($prijsExtern)
            ->setPrijsPropositie($prijsPropositie)
            ->setPropositieCode($propositieCode)
            ->setPropositieNaam($propositieNaam)
            ->setPakketVrijeCode1($pakketVrijeCode1)
            ->setPakketVrijeNaam1($pakketVrijeNaam1)
            ->setAboOrdernummer($aboOrdernummer)
            ->setAboCreditcard($aboCreditcard)
            ->setFactuurAdres($factuurAdres)
            ->setDatumLaatstVerzEditie($datumLaatstVerzEditie)
            ->setStopredenCode($stopredenCode)
            ->setStopredenNaam($stopredenNaam)
            ->setVerzendingBestandType($verzendingBestandType)
            ->setAboOnderbrekingActief($aboOnderbrekingActief)
            ->setPakketVolgnummer($pakketVolgnummer)
            ->setIngangsEditie($ingangsEditie)
            ->setEindeEditie($eindeEditie);
    }
    /**
     * Get aboKlachten value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\KlachtTab|null
     */
    public function getAboKlachten()
    {
        return isset($this->aboKlachten) ? $this->aboKlachten : null;
    }
    /**
     * Set aboKlachten value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\KlachtTab $aboKlachten
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboKlachten(\AbonnementApiV6\StructType\KlachtTab $aboKlachten = null)
    {
        if (is_null($aboKlachten) || (is_array($aboKlachten) && empty($aboKlachten))) {
            unset($this->aboKlachten);
        } else {
            $this->aboKlachten = $aboKlachten;
        }
        return $this;
    }
    /**
     * Get aboNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboNo()
    {
        return isset($this->aboNo) ? $this->aboNo : null;
    }
    /**
     * Set aboNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboNo
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: int
        if (!is_null($aboNo) && !(is_int($aboNo) || ctype_digit($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        if (is_null($aboNo) || (is_array($aboNo) && empty($aboNo))) {
            unset($this->aboNo);
        } else {
            $this->aboNo = $aboNo;
        }
        return $this;
    }
    /**
     * Get aboSoortIncassoVerplicht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboSoortIncassoVerplicht()
    {
        return isset($this->aboSoortIncassoVerplicht) ? $this->aboSoortIncassoVerplicht : null;
    }
    /**
     * Set aboSoortIncassoVerplicht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboSoortIncassoVerplicht
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortIncassoVerplicht($aboSoortIncassoVerplicht = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboSoortIncassoVerplicht) && !is_bool($aboSoortIncassoVerplicht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboSoortIncassoVerplicht, true), gettype($aboSoortIncassoVerplicht)), __LINE__);
        }
        if (is_null($aboSoortIncassoVerplicht) || (is_array($aboSoortIncassoVerplicht) && empty($aboSoortIncassoVerplicht))) {
            unset($this->aboSoortIncassoVerplicht);
        } else {
            $this->aboSoortIncassoVerplicht = $aboSoortIncassoVerplicht;
        }
        return $this;
    }
    /**
     * Get aboSoortProefAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboSoortProefAbo()
    {
        return isset($this->aboSoortProefAbo) ? $this->aboSoortProefAbo : null;
    }
    /**
     * Set aboSoortProefAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboSoortProefAbo
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortProefAbo($aboSoortProefAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboSoortProefAbo) && !is_bool($aboSoortProefAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboSoortProefAbo, true), gettype($aboSoortProefAbo)), __LINE__);
        }
        if (is_null($aboSoortProefAbo) || (is_array($aboSoortProefAbo) && empty($aboSoortProefAbo))) {
            unset($this->aboSoortProefAbo);
        } else {
            $this->aboSoortProefAbo = $aboSoortProefAbo;
        }
        return $this;
    }
    /**
     * Get aboSoortActieAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboSoortActieAbo()
    {
        return isset($this->aboSoortActieAbo) ? $this->aboSoortActieAbo : null;
    }
    /**
     * Set aboSoortActieAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboSoortActieAbo
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortActieAbo($aboSoortActieAbo = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboSoortActieAbo) && !is_bool($aboSoortActieAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboSoortActieAbo, true), gettype($aboSoortActieAbo)), __LINE__);
        }
        if (is_null($aboSoortActieAbo) || (is_array($aboSoortActieAbo) && empty($aboSoortActieAbo))) {
            unset($this->aboSoortActieAbo);
        } else {
            $this->aboSoortActieAbo = $aboSoortActieAbo;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode1()
    {
        return isset($this->aboSoortVrijeCode1) ? $this->aboSoortVrijeCode1 : null;
    }
    /**
     * Set aboSoortVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode1
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode1($aboSoortVrijeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode1) && !is_string($aboSoortVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode1, true), gettype($aboSoortVrijeCode1)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode1) && mb_strlen($aboSoortVrijeCode1) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode1)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode1) || (is_array($aboSoortVrijeCode1) && empty($aboSoortVrijeCode1))) {
            unset($this->aboSoortVrijeCode1);
        } else {
            $this->aboSoortVrijeCode1 = $aboSoortVrijeCode1;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode2()
    {
        return isset($this->aboSoortVrijeCode2) ? $this->aboSoortVrijeCode2 : null;
    }
    /**
     * Set aboSoortVrijeCode2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode2
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode2($aboSoortVrijeCode2 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode2) && !is_string($aboSoortVrijeCode2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode2, true), gettype($aboSoortVrijeCode2)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode2) && mb_strlen($aboSoortVrijeCode2) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode2)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode2) || (is_array($aboSoortVrijeCode2) && empty($aboSoortVrijeCode2))) {
            unset($this->aboSoortVrijeCode2);
        } else {
            $this->aboSoortVrijeCode2 = $aboSoortVrijeCode2;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode3()
    {
        return isset($this->aboSoortVrijeCode3) ? $this->aboSoortVrijeCode3 : null;
    }
    /**
     * Set aboSoortVrijeCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode3
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode3($aboSoortVrijeCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode3) && !is_string($aboSoortVrijeCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode3, true), gettype($aboSoortVrijeCode3)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode3) && mb_strlen($aboSoortVrijeCode3) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode3)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode3) || (is_array($aboSoortVrijeCode3) && empty($aboSoortVrijeCode3))) {
            unset($this->aboSoortVrijeCode3);
        } else {
            $this->aboSoortVrijeCode3 = $aboSoortVrijeCode3;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode4()
    {
        return isset($this->aboSoortVrijeCode4) ? $this->aboSoortVrijeCode4 : null;
    }
    /**
     * Set aboSoortVrijeCode4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode4
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode4($aboSoortVrijeCode4 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode4) && !is_string($aboSoortVrijeCode4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode4, true), gettype($aboSoortVrijeCode4)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode4) && mb_strlen($aboSoortVrijeCode4) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode4)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode4) || (is_array($aboSoortVrijeCode4) && empty($aboSoortVrijeCode4))) {
            unset($this->aboSoortVrijeCode4);
        } else {
            $this->aboSoortVrijeCode4 = $aboSoortVrijeCode4;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode5()
    {
        return isset($this->aboSoortVrijeCode5) ? $this->aboSoortVrijeCode5 : null;
    }
    /**
     * Set aboSoortVrijeCode5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode5
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode5($aboSoortVrijeCode5 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode5) && !is_string($aboSoortVrijeCode5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode5, true), gettype($aboSoortVrijeCode5)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode5) && mb_strlen($aboSoortVrijeCode5) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode5)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode5) || (is_array($aboSoortVrijeCode5) && empty($aboSoortVrijeCode5))) {
            unset($this->aboSoortVrijeCode5);
        } else {
            $this->aboSoortVrijeCode5 = $aboSoortVrijeCode5;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode6()
    {
        return isset($this->aboSoortVrijeCode6) ? $this->aboSoortVrijeCode6 : null;
    }
    /**
     * Set aboSoortVrijeCode6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode6
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode6($aboSoortVrijeCode6 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode6) && !is_string($aboSoortVrijeCode6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode6, true), gettype($aboSoortVrijeCode6)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode6) && mb_strlen($aboSoortVrijeCode6) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode6)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode6) || (is_array($aboSoortVrijeCode6) && empty($aboSoortVrijeCode6))) {
            unset($this->aboSoortVrijeCode6);
        } else {
            $this->aboSoortVrijeCode6 = $aboSoortVrijeCode6;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode7()
    {
        return isset($this->aboSoortVrijeCode7) ? $this->aboSoortVrijeCode7 : null;
    }
    /**
     * Set aboSoortVrijeCode7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode7
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode7($aboSoortVrijeCode7 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode7) && !is_string($aboSoortVrijeCode7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode7, true), gettype($aboSoortVrijeCode7)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode7) && mb_strlen($aboSoortVrijeCode7) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode7)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode7) || (is_array($aboSoortVrijeCode7) && empty($aboSoortVrijeCode7))) {
            unset($this->aboSoortVrijeCode7);
        } else {
            $this->aboSoortVrijeCode7 = $aboSoortVrijeCode7;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeCode8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeCode8()
    {
        return isset($this->aboSoortVrijeCode8) ? $this->aboSoortVrijeCode8 : null;
    }
    /**
     * Set aboSoortVrijeCode8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeCode8
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeCode8($aboSoortVrijeCode8 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeCode8) && !is_string($aboSoortVrijeCode8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeCode8, true), gettype($aboSoortVrijeCode8)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboSoortVrijeCode8) && mb_strlen($aboSoortVrijeCode8) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboSoortVrijeCode8)), __LINE__);
        }
        if (is_null($aboSoortVrijeCode8) || (is_array($aboSoortVrijeCode8) && empty($aboSoortVrijeCode8))) {
            unset($this->aboSoortVrijeCode8);
        } else {
            $this->aboSoortVrijeCode8 = $aboSoortVrijeCode8;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst1()
    {
        return isset($this->aboSoortVrijeTekst1) ? $this->aboSoortVrijeTekst1 : null;
    }
    /**
     * Set aboSoortVrijeTekst1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst1
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst1($aboSoortVrijeTekst1 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst1) && !is_string($aboSoortVrijeTekst1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst1, true), gettype($aboSoortVrijeTekst1)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst1) && mb_strlen($aboSoortVrijeTekst1) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst1)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst1) || (is_array($aboSoortVrijeTekst1) && empty($aboSoortVrijeTekst1))) {
            unset($this->aboSoortVrijeTekst1);
        } else {
            $this->aboSoortVrijeTekst1 = $aboSoortVrijeTekst1;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst2()
    {
        return isset($this->aboSoortVrijeTekst2) ? $this->aboSoortVrijeTekst2 : null;
    }
    /**
     * Set aboSoortVrijeTekst2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst2
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst2($aboSoortVrijeTekst2 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst2) && !is_string($aboSoortVrijeTekst2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst2, true), gettype($aboSoortVrijeTekst2)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst2) && mb_strlen($aboSoortVrijeTekst2) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst2)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst2) || (is_array($aboSoortVrijeTekst2) && empty($aboSoortVrijeTekst2))) {
            unset($this->aboSoortVrijeTekst2);
        } else {
            $this->aboSoortVrijeTekst2 = $aboSoortVrijeTekst2;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst3()
    {
        return isset($this->aboSoortVrijeTekst3) ? $this->aboSoortVrijeTekst3 : null;
    }
    /**
     * Set aboSoortVrijeTekst3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst3
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst3($aboSoortVrijeTekst3 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst3) && !is_string($aboSoortVrijeTekst3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst3, true), gettype($aboSoortVrijeTekst3)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst3) && mb_strlen($aboSoortVrijeTekst3) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst3)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst3) || (is_array($aboSoortVrijeTekst3) && empty($aboSoortVrijeTekst3))) {
            unset($this->aboSoortVrijeTekst3);
        } else {
            $this->aboSoortVrijeTekst3 = $aboSoortVrijeTekst3;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst4()
    {
        return isset($this->aboSoortVrijeTekst4) ? $this->aboSoortVrijeTekst4 : null;
    }
    /**
     * Set aboSoortVrijeTekst4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst4
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst4($aboSoortVrijeTekst4 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst4) && !is_string($aboSoortVrijeTekst4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst4, true), gettype($aboSoortVrijeTekst4)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst4) && mb_strlen($aboSoortVrijeTekst4) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst4)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst4) || (is_array($aboSoortVrijeTekst4) && empty($aboSoortVrijeTekst4))) {
            unset($this->aboSoortVrijeTekst4);
        } else {
            $this->aboSoortVrijeTekst4 = $aboSoortVrijeTekst4;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst5()
    {
        return isset($this->aboSoortVrijeTekst5) ? $this->aboSoortVrijeTekst5 : null;
    }
    /**
     * Set aboSoortVrijeTekst5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst5
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst5($aboSoortVrijeTekst5 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst5) && !is_string($aboSoortVrijeTekst5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst5, true), gettype($aboSoortVrijeTekst5)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst5) && mb_strlen($aboSoortVrijeTekst5) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst5)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst5) || (is_array($aboSoortVrijeTekst5) && empty($aboSoortVrijeTekst5))) {
            unset($this->aboSoortVrijeTekst5);
        } else {
            $this->aboSoortVrijeTekst5 = $aboSoortVrijeTekst5;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst6()
    {
        return isset($this->aboSoortVrijeTekst6) ? $this->aboSoortVrijeTekst6 : null;
    }
    /**
     * Set aboSoortVrijeTekst6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst6
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst6($aboSoortVrijeTekst6 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst6) && !is_string($aboSoortVrijeTekst6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst6, true), gettype($aboSoortVrijeTekst6)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst6) && mb_strlen($aboSoortVrijeTekst6) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst6)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst6) || (is_array($aboSoortVrijeTekst6) && empty($aboSoortVrijeTekst6))) {
            unset($this->aboSoortVrijeTekst6);
        } else {
            $this->aboSoortVrijeTekst6 = $aboSoortVrijeTekst6;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst7()
    {
        return isset($this->aboSoortVrijeTekst7) ? $this->aboSoortVrijeTekst7 : null;
    }
    /**
     * Set aboSoortVrijeTekst7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst7
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst7($aboSoortVrijeTekst7 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst7) && !is_string($aboSoortVrijeTekst7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst7, true), gettype($aboSoortVrijeTekst7)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst7) && mb_strlen($aboSoortVrijeTekst7) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst7)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst7) || (is_array($aboSoortVrijeTekst7) && empty($aboSoortVrijeTekst7))) {
            unset($this->aboSoortVrijeTekst7);
        } else {
            $this->aboSoortVrijeTekst7 = $aboSoortVrijeTekst7;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst8()
    {
        return isset($this->aboSoortVrijeTekst8) ? $this->aboSoortVrijeTekst8 : null;
    }
    /**
     * Set aboSoortVrijeTekst8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst8
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst8($aboSoortVrijeTekst8 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst8) && !is_string($aboSoortVrijeTekst8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst8, true), gettype($aboSoortVrijeTekst8)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst8) && mb_strlen($aboSoortVrijeTekst8) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst8)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst8) || (is_array($aboSoortVrijeTekst8) && empty($aboSoortVrijeTekst8))) {
            unset($this->aboSoortVrijeTekst8);
        } else {
            $this->aboSoortVrijeTekst8 = $aboSoortVrijeTekst8;
        }
        return $this;
    }
    /**
     * Get aboSoortVrijeTekst9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboSoortVrijeTekst9()
    {
        return isset($this->aboSoortVrijeTekst9) ? $this->aboSoortVrijeTekst9 : null;
    }
    /**
     * Set aboSoortVrijeTekst9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboSoortVrijeTekst9
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboSoortVrijeTekst9($aboSoortVrijeTekst9 = null)
    {
        // validation for constraint: string
        if (!is_null($aboSoortVrijeTekst9) && !is_string($aboSoortVrijeTekst9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboSoortVrijeTekst9, true), gettype($aboSoortVrijeTekst9)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($aboSoortVrijeTekst9) && mb_strlen($aboSoortVrijeTekst9) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($aboSoortVrijeTekst9)), __LINE__);
        }
        if (is_null($aboSoortVrijeTekst9) || (is_array($aboSoortVrijeTekst9) && empty($aboSoortVrijeTekst9))) {
            unset($this->aboSoortVrijeTekst9);
        } else {
            $this->aboSoortVrijeTekst9 = $aboSoortVrijeTekst9;
        }
        return $this;
    }
    /**
     * Get aboVerschInfos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VerschInfoTab|null
     */
    public function getAboVerschInfos()
    {
        return isset($this->aboVerschInfos) ? $this->aboVerschInfos : null;
    }
    /**
     * Set aboVerschInfos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VerschInfoTab $aboVerschInfos
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboVerschInfos(\AbonnementApiV6\StructType\VerschInfoTab $aboVerschInfos = null)
    {
        if (is_null($aboVerschInfos) || (is_array($aboVerschInfos) && empty($aboVerschInfos))) {
            unset($this->aboVerschInfos);
        } else {
            $this->aboVerschInfos = $aboVerschInfos;
        }
        return $this;
    }
    /**
     * Get aboVrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijeVeldenAboRec|null
     */
    public function getAboVrijeVelden()
    {
        return isset($this->aboVrijeVelden) ? $this->aboVrijeVelden : null;
    }
    /**
     * Set aboVrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboVrijeVelden(\AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden = null)
    {
        if (is_null($aboVrijeVelden) || (is_array($aboVrijeVelden) && empty($aboVrijeVelden))) {
            unset($this->aboVrijeVelden);
        } else {
            $this->aboVrijeVelden = $aboVrijeVelden;
        }
        return $this;
    }
    /**
     * Get abonnementSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortCode()
    {
        return isset($this->abonnementSoortCode) ? $this->abonnementSoortCode : null;
    }
    /**
     * Set abonnementSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAbonnementSoortCode($abonnementSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementSoortCode) && !is_string($abonnementSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementSoortCode, true), gettype($abonnementSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($abonnementSoortCode) && mb_strlen($abonnementSoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($abonnementSoortCode)), __LINE__);
        }
        if (is_null($abonnementSoortCode) || (is_array($abonnementSoortCode) && empty($abonnementSoortCode))) {
            unset($this->abonnementSoortCode);
        } else {
            $this->abonnementSoortCode = $abonnementSoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementSoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortNaam()
    {
        return isset($this->abonnementSoortNaam) ? $this->abonnementSoortNaam : null;
    }
    /**
     * Set abonnementSoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAbonnementSoortNaam($abonnementSoortNaam = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementSoortNaam) && !is_string($abonnementSoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementSoortNaam, true), gettype($abonnementSoortNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($abonnementSoortNaam) && mb_strlen($abonnementSoortNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($abonnementSoortNaam)), __LINE__);
        }
        if (is_null($abonnementSoortNaam) || (is_array($abonnementSoortNaam) && empty($abonnementSoortNaam))) {
            unset($this->abonnementSoortNaam);
        } else {
            $this->abonnementSoortNaam = $abonnementSoortNaam;
        }
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieCode, true), gettype($actieCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($actieCode) && mb_strlen($actieCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Get actieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieNaam()
    {
        return isset($this->actieNaam) ? $this->actieNaam : null;
    }
    /**
     * Set actieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setActieNaam($actieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($actieNaam) && !is_string($actieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieNaam, true), gettype($actieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($actieNaam) && mb_strlen($actieNaam) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($actieNaam)), __LINE__);
        }
        if (is_null($actieNaam) || (is_array($actieNaam) && empty($actieNaam))) {
            unset($this->actieNaam);
        } else {
            $this->actieNaam = $actieNaam;
        }
        return $this;
    }
    /**
     * Get artikelGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepCode()
    {
        return isset($this->artikelGroepCode) ? $this->artikelGroepCode : null;
    }
    /**
     * Set artikelGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setArtikelGroepCode($artikelGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepCode) && !is_string($artikelGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepCode, true), gettype($artikelGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($artikelGroepCode) && mb_strlen($artikelGroepCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($artikelGroepCode)), __LINE__);
        }
        if (is_null($artikelGroepCode) || (is_array($artikelGroepCode) && empty($artikelGroepCode))) {
            unset($this->artikelGroepCode);
        } else {
            $this->artikelGroepCode = $artikelGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepNaam()
    {
        return isset($this->artikelGroepNaam) ? $this->artikelGroepNaam : null;
    }
    /**
     * Set artikelGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setArtikelGroepNaam($artikelGroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepNaam) && !is_string($artikelGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepNaam, true), gettype($artikelGroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($artikelGroepNaam) && mb_strlen($artikelGroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($artikelGroepNaam)), __LINE__);
        }
        if (is_null($artikelGroepNaam) || (is_array($artikelGroepNaam) && empty($artikelGroepNaam))) {
            unset($this->artikelGroepNaam);
        } else {
            $this->artikelGroepNaam = $artikelGroepNaam;
        }
        return $this;
    }
    /**
     * Get artikelHoofdGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdGroepCode()
    {
        return isset($this->artikelHoofdGroepCode) ? $this->artikelHoofdGroepCode : null;
    }
    /**
     * Set artikelHoofdGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdGroepCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setArtikelHoofdGroepCode($artikelHoofdGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelHoofdGroepCode) && !is_string($artikelHoofdGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelHoofdGroepCode, true), gettype($artikelHoofdGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($artikelHoofdGroepCode) && mb_strlen($artikelHoofdGroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($artikelHoofdGroepCode)), __LINE__);
        }
        if (is_null($artikelHoofdGroepCode) || (is_array($artikelHoofdGroepCode) && empty($artikelHoofdGroepCode))) {
            unset($this->artikelHoofdGroepCode);
        } else {
            $this->artikelHoofdGroepCode = $artikelHoofdGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelHoofdGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelHoofdGroepNaam()
    {
        return isset($this->artikelHoofdGroepNaam) ? $this->artikelHoofdGroepNaam : null;
    }
    /**
     * Set artikelHoofdGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelHoofdGroepNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setArtikelHoofdGroepNaam($artikelHoofdGroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelHoofdGroepNaam) && !is_string($artikelHoofdGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelHoofdGroepNaam, true), gettype($artikelHoofdGroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($artikelHoofdGroepNaam) && mb_strlen($artikelHoofdGroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($artikelHoofdGroepNaam)), __LINE__);
        }
        if (is_null($artikelHoofdGroepNaam) || (is_array($artikelHoofdGroepNaam) && empty($artikelHoofdGroepNaam))) {
            unset($this->artikelHoofdGroepNaam);
        } else {
            $this->artikelHoofdGroepNaam = $artikelHoofdGroepNaam;
        }
        return $this;
    }
    /**
     * Get bankRekeningNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankRekeningNummer()
    {
        return isset($this->bankRekeningNummer) ? $this->bankRekeningNummer : null;
    }
    /**
     * Set bankRekeningNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankRekeningNummer
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setBankRekeningNummer($bankRekeningNummer = null)
    {
        // validation for constraint: string
        if (!is_null($bankRekeningNummer) && !is_string($bankRekeningNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankRekeningNummer, true), gettype($bankRekeningNummer)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($bankRekeningNummer) && mb_strlen($bankRekeningNummer) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($bankRekeningNummer)), __LINE__);
        }
        if (is_null($bankRekeningNummer) || (is_array($bankRekeningNummer) && empty($bankRekeningNummer))) {
            unset($this->bankRekeningNummer);
        } else {
            $this->bankRekeningNummer = $bankRekeningNummer;
        }
        return $this;
    }
    /**
     * Get bankIbanNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankIbanNummer()
    {
        return isset($this->bankIbanNummer) ? $this->bankIbanNummer : null;
    }
    /**
     * Set bankIbanNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankIbanNummer
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setBankIbanNummer($bankIbanNummer = null)
    {
        // validation for constraint: string
        if (!is_null($bankIbanNummer) && !is_string($bankIbanNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankIbanNummer, true), gettype($bankIbanNummer)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($bankIbanNummer) && mb_strlen($bankIbanNummer) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($bankIbanNummer)), __LINE__);
        }
        if (is_null($bankIbanNummer) || (is_array($bankIbanNummer) && empty($bankIbanNummer))) {
            unset($this->bankIbanNummer);
        } else {
            $this->bankIbanNummer = $bankIbanNummer;
        }
        return $this;
    }
    /**
     * Get bankBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankBicCode()
    {
        return isset($this->bankBicCode) ? $this->bankBicCode : null;
    }
    /**
     * Set bankBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankBicCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setBankBicCode($bankBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankBicCode) && !is_string($bankBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankBicCode, true), gettype($bankBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($bankBicCode) && mb_strlen($bankBicCode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($bankBicCode)), __LINE__);
        }
        if (is_null($bankBicCode) || (is_array($bankBicCode) && empty($bankBicCode))) {
            unset($this->bankBicCode);
        } else {
            $this->bankBicCode = $bankBicCode;
        }
        return $this;
    }
    /**
     * Get betaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBetaalwijze()
    {
        return isset($this->betaalwijze) ? $this->betaalwijze : null;
    }
    /**
     * Set betaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $betaalwijze
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: int
        if (!is_null($betaalwijze) && !(is_int($betaalwijze) || ctype_digit($betaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($betaalwijze, true), gettype($betaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($betaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $betaalwijze)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($betaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $betaalwijze))), __LINE__);
        }
        if (is_null($betaalwijze) || (is_array($betaalwijze) && empty($betaalwijze))) {
            unset($this->betaalwijze);
        } else {
            $this->betaalwijze = $betaalwijze;
        }
        return $this;
    }
    /**
     * Get eindDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEindDatum()
    {
        return isset($this->eindDatum) ? $this->eindDatum : null;
    }
    /**
     * Set eindDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eindDatum
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setEindDatum($eindDatum = null)
    {
        // validation for constraint: string
        if (!is_null($eindDatum) && !is_string($eindDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eindDatum, true), gettype($eindDatum)), __LINE__);
        }
        if (is_null($eindDatum) || (is_array($eindDatum) && empty($eindDatum))) {
            unset($this->eindDatum);
        } else {
            $this->eindDatum = $eindDatum;
        }
        return $this;
    }
    /**
     * Get herkomstCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHerkomstCode()
    {
        return isset($this->herkomstCode) ? $this->herkomstCode : null;
    }
    /**
     * Set herkomstCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $herkomstCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setHerkomstCode($herkomstCode = null)
    {
        // validation for constraint: string
        if (!is_null($herkomstCode) && !is_string($herkomstCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($herkomstCode, true), gettype($herkomstCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($herkomstCode) && mb_strlen($herkomstCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($herkomstCode)), __LINE__);
        }
        if (is_null($herkomstCode) || (is_array($herkomstCode) && empty($herkomstCode))) {
            unset($this->herkomstCode);
        } else {
            $this->herkomstCode = $herkomstCode;
        }
        return $this;
    }
    /**
     * Get herkomstNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHerkomstNaam()
    {
        return isset($this->herkomstNaam) ? $this->herkomstNaam : null;
    }
    /**
     * Set herkomstNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $herkomstNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setHerkomstNaam($herkomstNaam = null)
    {
        // validation for constraint: string
        if (!is_null($herkomstNaam) && !is_string($herkomstNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($herkomstNaam, true), gettype($herkomstNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($herkomstNaam) && mb_strlen($herkomstNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($herkomstNaam)), __LINE__);
        }
        if (is_null($herkomstNaam) || (is_array($herkomstNaam) && empty($herkomstNaam))) {
            unset($this->herkomstNaam);
        } else {
            $this->herkomstNaam = $herkomstNaam;
        }
        return $this;
    }
    /**
     * Get ingangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIngangsDatum()
    {
        return isset($this->ingangsDatum) ? $this->ingangsDatum : null;
    }
    /**
     * Set ingangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ingangsDatum
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setIngangsDatum($ingangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($ingangsDatum) && !is_string($ingangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ingangsDatum, true), gettype($ingangsDatum)), __LINE__);
        }
        if (is_null($ingangsDatum) || (is_array($ingangsDatum) && empty($ingangsDatum))) {
            unset($this->ingangsDatum);
        } else {
            $this->ingangsDatum = $ingangsDatum;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketNaam, true), gettype($pakketNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketNaam) && mb_strlen($pakketNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get premiumAboCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumAboCode()
    {
        return isset($this->premiumAboCode) ? $this->premiumAboCode : null;
    }
    /**
     * Set premiumAboCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumAboCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPremiumAboCode($premiumAboCode = null)
    {
        // validation for constraint: string
        if (!is_null($premiumAboCode) && !is_string($premiumAboCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumAboCode, true), gettype($premiumAboCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($premiumAboCode) && mb_strlen($premiumAboCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($premiumAboCode)), __LINE__);
        }
        if (is_null($premiumAboCode) || (is_array($premiumAboCode) && empty($premiumAboCode))) {
            unset($this->premiumAboCode);
        } else {
            $this->premiumAboCode = $premiumAboCode;
        }
        return $this;
    }
    /**
     * Get premiumAboNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumAboNaam()
    {
        return isset($this->premiumAboNaam) ? $this->premiumAboNaam : null;
    }
    /**
     * Set premiumAboNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumAboNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPremiumAboNaam($premiumAboNaam = null)
    {
        // validation for constraint: string
        if (!is_null($premiumAboNaam) && !is_string($premiumAboNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumAboNaam, true), gettype($premiumAboNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($premiumAboNaam) && mb_strlen($premiumAboNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($premiumAboNaam)), __LINE__);
        }
        if (is_null($premiumAboNaam) || (is_array($premiumAboNaam) && empty($premiumAboNaam))) {
            unset($this->premiumAboNaam);
        } else {
            $this->premiumAboNaam = $premiumAboNaam;
        }
        return $this;
    }
    /**
     * Get premiumDebCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumDebCode()
    {
        return isset($this->premiumDebCode) ? $this->premiumDebCode : null;
    }
    /**
     * Set premiumDebCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumDebCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPremiumDebCode($premiumDebCode = null)
    {
        // validation for constraint: string
        if (!is_null($premiumDebCode) && !is_string($premiumDebCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumDebCode, true), gettype($premiumDebCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($premiumDebCode) && mb_strlen($premiumDebCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($premiumDebCode)), __LINE__);
        }
        if (is_null($premiumDebCode) || (is_array($premiumDebCode) && empty($premiumDebCode))) {
            unset($this->premiumDebCode);
        } else {
            $this->premiumDebCode = $premiumDebCode;
        }
        return $this;
    }
    /**
     * Get premiumDebNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumDebNaam()
    {
        return isset($this->premiumDebNaam) ? $this->premiumDebNaam : null;
    }
    /**
     * Set premiumDebNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumDebNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPremiumDebNaam($premiumDebNaam = null)
    {
        // validation for constraint: string
        if (!is_null($premiumDebNaam) && !is_string($premiumDebNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumDebNaam, true), gettype($premiumDebNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($premiumDebNaam) && mb_strlen($premiumDebNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($premiumDebNaam)), __LINE__);
        }
        if (is_null($premiumDebNaam) || (is_array($premiumDebNaam) && empty($premiumDebNaam))) {
            unset($this->premiumDebNaam);
        } else {
            $this->premiumDebNaam = $premiumDebNaam;
        }
        return $this;
    }
    /**
     * Get relNoAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoAbo()
    {
        return isset($this->relNoAbo) ? $this->relNoAbo : null;
    }
    /**
     * Set relNoAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoAbo
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setRelNoAbo($relNoAbo = null)
    {
        // validation for constraint: int
        if (!is_null($relNoAbo) && !(is_int($relNoAbo) || ctype_digit($relNoAbo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoAbo, true), gettype($relNoAbo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoAbo) && mb_strlen(preg_replace('/(\D)/', '', $relNoAbo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoAbo, true), mb_strlen(preg_replace('/(\D)/', '', $relNoAbo))), __LINE__);
        }
        if (is_null($relNoAbo) || (is_array($relNoAbo) && empty($relNoAbo))) {
            unset($this->relNoAbo);
        } else {
            $this->relNoAbo = $relNoAbo;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get leverStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverStatus()
    {
        return isset($this->leverStatus) ? $this->leverStatus : null;
    }
    /**
     * Set leverStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverStatus
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setLeverStatus($leverStatus = null)
    {
        // validation for constraint: string
        if (!is_null($leverStatus) && !is_string($leverStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverStatus, true), gettype($leverStatus)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($leverStatus) && mb_strlen($leverStatus) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($leverStatus)), __LINE__);
        }
        if (is_null($leverStatus) || (is_array($leverStatus) && empty($leverStatus))) {
            unset($this->leverStatus);
        } else {
            $this->leverStatus = $leverStatus;
        }
        return $this;
    }
    /**
     * Get aantalExemplaren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalExemplaren()
    {
        return isset($this->aantalExemplaren) ? $this->aantalExemplaren : null;
    }
    /**
     * Set aantalExemplaren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalExemplaren
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAantalExemplaren($aantalExemplaren = null)
    {
        // validation for constraint: int
        if (!is_null($aantalExemplaren) && !(is_int($aantalExemplaren) || ctype_digit($aantalExemplaren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aantalExemplaren, true), gettype($aantalExemplaren)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aantalExemplaren) && mb_strlen(preg_replace('/(\D)/', '', $aantalExemplaren)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aantalExemplaren, true), mb_strlen(preg_replace('/(\D)/', '', $aantalExemplaren))), __LINE__);
        }
        if (is_null($aantalExemplaren) || (is_array($aantalExemplaren) && empty($aantalExemplaren))) {
            unset($this->aantalExemplaren);
        } else {
            $this->aantalExemplaren = $aantalExemplaren;
        }
        return $this;
    }
    /**
     * Get organisatieLicentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOrganisatieLicentie()
    {
        return isset($this->organisatieLicentie) ? $this->organisatieLicentie : null;
    }
    /**
     * Set organisatieLicentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $organisatieLicentie
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setOrganisatieLicentie($organisatieLicentie = null)
    {
        // validation for constraint: boolean
        if (!is_null($organisatieLicentie) && !is_bool($organisatieLicentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($organisatieLicentie, true), gettype($organisatieLicentie)), __LINE__);
        }
        if (is_null($organisatieLicentie) || (is_array($organisatieLicentie) && empty($organisatieLicentie))) {
            unset($this->organisatieLicentie);
        } else {
            $this->organisatieLicentie = $organisatieLicentie;
        }
        return $this;
    }
    /**
     * Get machtigingsKenmerk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMachtigingsKenmerk()
    {
        return isset($this->machtigingsKenmerk) ? $this->machtigingsKenmerk : null;
    }
    /**
     * Set machtigingsKenmerk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $machtigingsKenmerk
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setMachtigingsKenmerk($machtigingsKenmerk = null)
    {
        // validation for constraint: string
        if (!is_null($machtigingsKenmerk) && !is_string($machtigingsKenmerk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machtigingsKenmerk, true), gettype($machtigingsKenmerk)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($machtigingsKenmerk) && mb_strlen($machtigingsKenmerk) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($machtigingsKenmerk)), __LINE__);
        }
        if (is_null($machtigingsKenmerk) || (is_array($machtigingsKenmerk) && empty($machtigingsKenmerk))) {
            unset($this->machtigingsKenmerk);
        } else {
            $this->machtigingsKenmerk = $machtigingsKenmerk;
        }
        return $this;
    }
    /**
     * Get aboRollen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\RolInfo|null
     */
    public function getAboRollen()
    {
        return isset($this->aboRollen) ? $this->aboRollen : null;
    }
    /**
     * Set aboRollen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\RolInfo $aboRollen
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboRollen(\AbonnementApiV6\StructType\RolInfo $aboRollen = null)
    {
        if (is_null($aboRollen) || (is_array($aboRollen) && empty($aboRollen))) {
            unset($this->aboRollen);
        } else {
            $this->aboRollen = $aboRollen;
        }
        return $this;
    }
    /**
     * Get relNoDeb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoDeb()
    {
        return isset($this->relNoDeb) ? $this->relNoDeb : null;
    }
    /**
     * Set relNoDeb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoDeb
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setRelNoDeb($relNoDeb = null)
    {
        // validation for constraint: int
        if (!is_null($relNoDeb) && !(is_int($relNoDeb) || ctype_digit($relNoDeb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoDeb, true), gettype($relNoDeb)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoDeb) && mb_strlen(preg_replace('/(\D)/', '', $relNoDeb)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoDeb, true), mb_strlen(preg_replace('/(\D)/', '', $relNoDeb))), __LINE__);
        }
        if (is_null($relNoDeb) || (is_array($relNoDeb) && empty($relNoDeb))) {
            unset($this->relNoDeb);
        } else {
            $this->relNoDeb = $relNoDeb;
        }
        return $this;
    }
    /**
     * Get prijsExtern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExtern()
    {
        return isset($this->prijsExtern) ? $this->prijsExtern : null;
    }
    /**
     * Set prijsExtern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExtern
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPrijsExtern($prijsExtern = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExtern) && !(is_float($prijsExtern) || is_numeric($prijsExtern))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExtern, true), gettype($prijsExtern)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsExtern) && mb_strlen(mb_substr($prijsExtern, false !== mb_strpos($prijsExtern, '.') ? mb_strpos($prijsExtern, '.') + 1 : mb_strlen($prijsExtern))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsExtern, true), mb_strlen(mb_substr($prijsExtern, mb_strpos($prijsExtern, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsExtern) && mb_strlen(preg_replace('/(\D)/', '', $prijsExtern)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsExtern, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExtern))), __LINE__);
        }
        if (is_null($prijsExtern) || (is_array($prijsExtern) && empty($prijsExtern))) {
            unset($this->prijsExtern);
        } else {
            $this->prijsExtern = $prijsExtern;
        }
        return $this;
    }
    /**
     * Get prijsPropositie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsPropositie()
    {
        return isset($this->prijsPropositie) ? $this->prijsPropositie : null;
    }
    /**
     * Set prijsPropositie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsPropositie
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPrijsPropositie($prijsPropositie = null)
    {
        // validation for constraint: float
        if (!is_null($prijsPropositie) && !(is_float($prijsPropositie) || is_numeric($prijsPropositie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsPropositie, true), gettype($prijsPropositie)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsPropositie) && mb_strlen(mb_substr($prijsPropositie, false !== mb_strpos($prijsPropositie, '.') ? mb_strpos($prijsPropositie, '.') + 1 : mb_strlen($prijsPropositie))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsPropositie, true), mb_strlen(mb_substr($prijsPropositie, mb_strpos($prijsPropositie, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsPropositie) && mb_strlen(preg_replace('/(\D)/', '', $prijsPropositie)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsPropositie, true), mb_strlen(preg_replace('/(\D)/', '', $prijsPropositie))), __LINE__);
        }
        if (is_null($prijsPropositie) || (is_array($prijsPropositie) && empty($prijsPropositie))) {
            unset($this->prijsPropositie);
        } else {
            $this->prijsPropositie = $prijsPropositie;
        }
        return $this;
    }
    /**
     * Get propositieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropositieCode()
    {
        return isset($this->propositieCode) ? $this->propositieCode : null;
    }
    /**
     * Set propositieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propositieCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPropositieCode($propositieCode = null)
    {
        // validation for constraint: string
        if (!is_null($propositieCode) && !is_string($propositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propositieCode, true), gettype($propositieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($propositieCode) && mb_strlen($propositieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($propositieCode)), __LINE__);
        }
        if (is_null($propositieCode) || (is_array($propositieCode) && empty($propositieCode))) {
            unset($this->propositieCode);
        } else {
            $this->propositieCode = $propositieCode;
        }
        return $this;
    }
    /**
     * Get propositieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropositieNaam()
    {
        return isset($this->propositieNaam) ? $this->propositieNaam : null;
    }
    /**
     * Set propositieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propositieNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPropositieNaam($propositieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($propositieNaam) && !is_string($propositieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propositieNaam, true), gettype($propositieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($propositieNaam) && mb_strlen($propositieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($propositieNaam)), __LINE__);
        }
        if (is_null($propositieNaam) || (is_array($propositieNaam) && empty($propositieNaam))) {
            unset($this->propositieNaam);
        } else {
            $this->propositieNaam = $propositieNaam;
        }
        return $this;
    }
    /**
     * Get pakketVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeCode1()
    {
        return isset($this->pakketVrijeCode1) ? $this->pakketVrijeCode1 : null;
    }
    /**
     * Set pakketVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeCode1
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPakketVrijeCode1($pakketVrijeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($pakketVrijeCode1) && !is_string($pakketVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketVrijeCode1, true), gettype($pakketVrijeCode1)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketVrijeCode1) && mb_strlen($pakketVrijeCode1) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketVrijeCode1)), __LINE__);
        }
        if (is_null($pakketVrijeCode1) || (is_array($pakketVrijeCode1) && empty($pakketVrijeCode1))) {
            unset($this->pakketVrijeCode1);
        } else {
            $this->pakketVrijeCode1 = $pakketVrijeCode1;
        }
        return $this;
    }
    /**
     * Get pakketVrijeNaam1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeNaam1()
    {
        return isset($this->pakketVrijeNaam1) ? $this->pakketVrijeNaam1 : null;
    }
    /**
     * Set pakketVrijeNaam1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeNaam1
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPakketVrijeNaam1($pakketVrijeNaam1 = null)
    {
        // validation for constraint: string
        if (!is_null($pakketVrijeNaam1) && !is_string($pakketVrijeNaam1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketVrijeNaam1, true), gettype($pakketVrijeNaam1)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketVrijeNaam1) && mb_strlen($pakketVrijeNaam1) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketVrijeNaam1)), __LINE__);
        }
        if (is_null($pakketVrijeNaam1) || (is_array($pakketVrijeNaam1) && empty($pakketVrijeNaam1))) {
            unset($this->pakketVrijeNaam1);
        } else {
            $this->pakketVrijeNaam1 = $pakketVrijeNaam1;
        }
        return $this;
    }
    /**
     * Get aboOrdernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboOrdernummer()
    {
        return isset($this->aboOrdernummer) ? $this->aboOrdernummer : null;
    }
    /**
     * Set aboOrdernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboOrdernummer
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboOrdernummer($aboOrdernummer = null)
    {
        // validation for constraint: string
        if (!is_null($aboOrdernummer) && !is_string($aboOrdernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboOrdernummer, true), gettype($aboOrdernummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($aboOrdernummer) && mb_strlen($aboOrdernummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($aboOrdernummer)), __LINE__);
        }
        if (is_null($aboOrdernummer) || (is_array($aboOrdernummer) && empty($aboOrdernummer))) {
            unset($this->aboOrdernummer);
        } else {
            $this->aboOrdernummer = $aboOrdernummer;
        }
        return $this;
    }
    /**
     * Get aboCreditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\Creditcard|null
     */
    public function getAboCreditcard()
    {
        return isset($this->aboCreditcard) ? $this->aboCreditcard : null;
    }
    /**
     * Set aboCreditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\Creditcard $aboCreditcard
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboCreditcard(\AbonnementApiV6\StructType\Creditcard $aboCreditcard = null)
    {
        if (is_null($aboCreditcard) || (is_array($aboCreditcard) && empty($aboCreditcard))) {
            unset($this->aboCreditcard);
        } else {
            $this->aboCreditcard = $aboCreditcard;
        }
        return $this;
    }
    /**
     * Get factuurAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\FactuurAdres|null
     */
    public function getFactuurAdres()
    {
        return isset($this->factuurAdres) ? $this->factuurAdres : null;
    }
    /**
     * Set factuurAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\FactuurAdres $factuurAdres
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setFactuurAdres(\AbonnementApiV6\StructType\FactuurAdres $factuurAdres = null)
    {
        if (is_null($factuurAdres) || (is_array($factuurAdres) && empty($factuurAdres))) {
            unset($this->factuurAdres);
        } else {
            $this->factuurAdres = $factuurAdres;
        }
        return $this;
    }
    /**
     * Get datumLaatstVerzEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumLaatstVerzEditie()
    {
        return isset($this->datumLaatstVerzEditie) ? $this->datumLaatstVerzEditie : null;
    }
    /**
     * Set datumLaatstVerzEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumLaatstVerzEditie
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setDatumLaatstVerzEditie($datumLaatstVerzEditie = null)
    {
        // validation for constraint: string
        if (!is_null($datumLaatstVerzEditie) && !is_string($datumLaatstVerzEditie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumLaatstVerzEditie, true), gettype($datumLaatstVerzEditie)), __LINE__);
        }
        if (is_null($datumLaatstVerzEditie) || (is_array($datumLaatstVerzEditie) && empty($datumLaatstVerzEditie))) {
            unset($this->datumLaatstVerzEditie);
        } else {
            $this->datumLaatstVerzEditie = $datumLaatstVerzEditie;
        }
        return $this;
    }
    /**
     * Get stopredenCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopredenCode()
    {
        return isset($this->stopredenCode) ? $this->stopredenCode : null;
    }
    /**
     * Set stopredenCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopredenCode
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setStopredenCode($stopredenCode = null)
    {
        // validation for constraint: string
        if (!is_null($stopredenCode) && !is_string($stopredenCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopredenCode, true), gettype($stopredenCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($stopredenCode) && mb_strlen($stopredenCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($stopredenCode)), __LINE__);
        }
        if (is_null($stopredenCode) || (is_array($stopredenCode) && empty($stopredenCode))) {
            unset($this->stopredenCode);
        } else {
            $this->stopredenCode = $stopredenCode;
        }
        return $this;
    }
    /**
     * Get stopredenNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStopredenNaam()
    {
        return isset($this->stopredenNaam) ? $this->stopredenNaam : null;
    }
    /**
     * Set stopredenNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stopredenNaam
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setStopredenNaam($stopredenNaam = null)
    {
        // validation for constraint: string
        if (!is_null($stopredenNaam) && !is_string($stopredenNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopredenNaam, true), gettype($stopredenNaam)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($stopredenNaam) && mb_strlen($stopredenNaam) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($stopredenNaam)), __LINE__);
        }
        if (is_null($stopredenNaam) || (is_array($stopredenNaam) && empty($stopredenNaam))) {
            unset($this->stopredenNaam);
        } else {
            $this->stopredenNaam = $stopredenNaam;
        }
        return $this;
    }
    /**
     * Get verzendingBestandType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerzendingBestandType()
    {
        return isset($this->verzendingBestandType) ? $this->verzendingBestandType : null;
    }
    /**
     * Set verzendingBestandType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verzendingBestandType
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setVerzendingBestandType($verzendingBestandType = null)
    {
        // validation for constraint: int
        if (!is_null($verzendingBestandType) && !(is_int($verzendingBestandType) || ctype_digit($verzendingBestandType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verzendingBestandType, true), gettype($verzendingBestandType)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($verzendingBestandType) && mb_strlen(preg_replace('/(\D)/', '', $verzendingBestandType)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($verzendingBestandType, true), mb_strlen(preg_replace('/(\D)/', '', $verzendingBestandType))), __LINE__);
        }
        if (is_null($verzendingBestandType) || (is_array($verzendingBestandType) && empty($verzendingBestandType))) {
            unset($this->verzendingBestandType);
        } else {
            $this->verzendingBestandType = $verzendingBestandType;
        }
        return $this;
    }
    /**
     * Get aboOnderbrekingActief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboOnderbrekingActief()
    {
        return isset($this->aboOnderbrekingActief) ? $this->aboOnderbrekingActief : null;
    }
    /**
     * Set aboOnderbrekingActief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboOnderbrekingActief
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setAboOnderbrekingActief($aboOnderbrekingActief = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboOnderbrekingActief) && !is_bool($aboOnderbrekingActief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboOnderbrekingActief, true), gettype($aboOnderbrekingActief)), __LINE__);
        }
        if (is_null($aboOnderbrekingActief) || (is_array($aboOnderbrekingActief) && empty($aboOnderbrekingActief))) {
            unset($this->aboOnderbrekingActief);
        } else {
            $this->aboOnderbrekingActief = $aboOnderbrekingActief;
        }
        return $this;
    }
    /**
     * Get pakketVolgnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPakketVolgnummer()
    {
        return isset($this->pakketVolgnummer) ? $this->pakketVolgnummer : null;
    }
    /**
     * Set pakketVolgnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pakketVolgnummer
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setPakketVolgnummer($pakketVolgnummer = null)
    {
        // validation for constraint: int
        if (!is_null($pakketVolgnummer) && !(is_int($pakketVolgnummer) || ctype_digit($pakketVolgnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pakketVolgnummer, true), gettype($pakketVolgnummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($pakketVolgnummer) && mb_strlen(preg_replace('/(\D)/', '', $pakketVolgnummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($pakketVolgnummer, true), mb_strlen(preg_replace('/(\D)/', '', $pakketVolgnummer))), __LINE__);
        }
        if (is_null($pakketVolgnummer) || (is_array($pakketVolgnummer) && empty($pakketVolgnummer))) {
            unset($this->pakketVolgnummer);
        } else {
            $this->pakketVolgnummer = $pakketVolgnummer;
        }
        return $this;
    }
    /**
     * Get ingangsEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIngangsEditie()
    {
        return isset($this->ingangsEditie) ? $this->ingangsEditie : null;
    }
    /**
     * Set ingangsEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ingangsEditie
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setIngangsEditie($ingangsEditie = null)
    {
        // validation for constraint: int
        if (!is_null($ingangsEditie) && !(is_int($ingangsEditie) || ctype_digit($ingangsEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ingangsEditie, true), gettype($ingangsEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($ingangsEditie) && mb_strlen(preg_replace('/(\D)/', '', $ingangsEditie)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($ingangsEditie, true), mb_strlen(preg_replace('/(\D)/', '', $ingangsEditie))), __LINE__);
        }
        if (is_null($ingangsEditie) || (is_array($ingangsEditie) && empty($ingangsEditie))) {
            unset($this->ingangsEditie);
        } else {
            $this->ingangsEditie = $ingangsEditie;
        }
        return $this;
    }
    /**
     * Get eindeEditie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEindeEditie()
    {
        return isset($this->eindeEditie) ? $this->eindeEditie : null;
    }
    /**
     * Set eindeEditie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eindeEditie
     * @return \AbonnementApiV6\StructType\Abonnement
     */
    public function setEindeEditie($eindeEditie = null)
    {
        // validation for constraint: int
        if (!is_null($eindeEditie) && !(is_int($eindeEditie) || ctype_digit($eindeEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eindeEditie, true), gettype($eindeEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($eindeEditie) && mb_strlen(preg_replace('/(\D)/', '', $eindeEditie)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($eindeEditie, true), mb_strlen(preg_replace('/(\D)/', '', $eindeEditie))), __LINE__);
        }
        if (is_null($eindeEditie) || (is_array($eindeEditie) && empty($eindeEditie))) {
            unset($this->eindeEditie);
        } else {
            $this->eindeEditie = $eindeEditie;
        }
        return $this;
    }
}
