<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboObject StructType
 * Meta information extracted from the WSDL
 * - documentation: Abonnement object.
 * @subpackage Structs
 * @date 20240419 package
 */
class AboObject extends AbstractStructBase
{
    /**
     * The aboAboSoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de abonnementsoort Indien abosoort niet gevuld is dient pakket gevuld te zijn. Moet bestaan in abonnementsoort tabel. Moet een actieve abosoort zijn.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboAboSoortCode;
    /**
     * The aboActieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de actie. Code moet bestaan in actie tabel. Moet een actieve actie zijn.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboActieCode;
    /**
     * The aboBetaalReferentie
     * Meta information extracted from the WSDL
     * - documentation: Betaalreferentie in geval van betaling via eenmalige iDeal.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboBetaalReferentie;
    /**
     * The aboBetaalwijze
     * Meta information extracted from the WSDL
     * - documentation: [0,1,3,4,7,9] Betaalwijze: 0 = factuur, 1 = incasso, 3 = Eenmalige iDeal, 4 = Factuur per mail, 7 = Creditcard, 9 = Betaling via derden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboBetaalwijze;
    /**
     * The aboHerkomstCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de herkomst. Code moet bestaan in herkomst tabel.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboHerkomstCode;
    /**
     * The aboIngangsDatum
     * Meta information extracted from the WSDL
     * - documentation: Ingangsdatum van het abonnement, indien leeg eerstvolgende verschijning.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboIngangsDatum;
    /**
     * The aboPakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het pakket Indien pakket niet gevuld is dient abosoort gevuld te zijn. Moet bestaan in paketten tabel. Moet een actief pakket zijn.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboPakketCode;
    /**
     * The aboPremiumCodeAbo
     * Meta information extracted from the WSDL
     * - documentation: Code van premium voor abonnee Moet bestaan in de Premium tabel. Moet een actief Premium zijn.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboPremiumCodeAbo;
    /**
     * The aboPremiumCodeBetaler
     * Meta information extracted from the WSDL
     * - documentation: Code van premium voor betaler Moet bestaan in de Premium tabel. Moet een actief Premium zijn.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboPremiumCodeBetaler;
    /**
     * The aboRekNr
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer Gironr begint met P en niet langer dan 7 cijfers, banknr 11-proef. Igv incasso + pre Sepa verplicht.
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekNr;
    /**
     * The aboRekIbanNr
     * Meta information extracted from the WSDL
     * - documentation: Iban nummer Iban nummer wordt gevalideerd als zijnde een valide Iban nummer. Igv incasso + Sepa verplicht.
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekIbanNr;
    /**
     * The aboRekBicCode
     * Meta information extracted from the WSDL
     * - documentation: Bic Code Bic code van de bankrekening. Wordt gevalideerd als zijnde een valide Bic code. Igv incasso + Sepa verplicht.
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboRekBicCode;
    /**
     * The aboMachtigingsDatum
     * Meta information extracted from the WSDL
     * - documentation: Machtigingsdatum voor de incasso Wordt bij de incasso machtiging opgeslagen als machtigings datum (Default vandaag).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboMachtigingsDatum;
    /**
     * The aboAantalExemplaren
     * Meta information extracted from the WSDL
     * - documentation: Aantal exemplaren (Default 1). Aantal gewenste exemplaren van het abonnement.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboAantalExemplaren;
    /**
     * The aboAdresType
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2] Indicatie naar welk adres het abonnement verzonden moet worden (Default 0). Toegestane waarden: 0=Correspondentie, 1=Bezoek, 2=Prive.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $aboAdresType;
    /**
     * The aboFactuurNaarPriveadres
     * Meta information extracted from the WSDL
     * - documentation: Indicatie factuur naar privÃ© adres (Default niet naar privÃ©).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $aboFactuurNaarPriveadres;
    /**
     * The aboVastKortingBedr
     * Meta information extracted from the WSDL
     * - documentation: Bedrag van de vaste korting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $aboVastKortingBedr;
    /**
     * The aboVastKortingPerc
     * Meta information extracted from the WSDL
     * - documentation: Percentage van de vaste korting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $aboVastKortingPerc;
    /**
     * The aboVastKortingOmschr
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de vaste korting.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboVastKortingOmschr;
    /**
     * The aboEenmaligeKortingBedr
     * Meta information extracted from the WSDL
     * - documentation: Bedrag van de eenmalige korting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $aboEenmaligeKortingBedr;
    /**
     * The aboEenmaligeKortingPerc
     * Meta information extracted from the WSDL
     * - documentation: Percentage van de eenmalige korting.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $aboEenmaligeKortingPerc;
    /**
     * The aboEenmaligeKortingOmschr
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de eenmalige korting.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboEenmaligeKortingOmschr;
    /**
     * The aboEenmaligeKortingCode
     * Meta information extracted from the WSDL
     * - documentation: Code van vaste eenmalige korting Moet de code zijn van een bestaande eenmalige korting.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboEenmaligeKortingCode;
    /**
     * The aboPropositieCode
     * Meta information extracted from the WSDL
     * - documentation: Unieke code van de propositie Propositie moet bestaan en actief zijn. Obv de propositie wordt het abonnement aan een actie + abosoort of pakket gekoppeld.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboPropositieCode;
    /**
     * The aboPrijsPropositie
     * Meta information extracted from the WSDL
     * - documentation: Prijs voor de propositie Propositieprijs geldend voor de eerste factuur of contractperiode. Overruled de propositieprijs opgegeven op de propositie zelf.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $aboPrijsPropositie;
    /**
     * The aboIngevoerdDoor
     * Meta information extracted from the WSDL
     * - documentation: Abonnement ingevoerd door.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboIngevoerdDoor;
    /**
     * The aboVrijeVelden
     * Meta information extracted from the WSDL
     * - documentation: De vrije velden van het abonnement
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\VrijeVeldenAboRec
     */
    public $aboVrijeVelden;
    /**
     * The aboOrdernummer
     * Meta information extracted from the WSDL
     * - documentation: Ordernummer van besteller ter referentie.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboOrdernummer;
    /**
     * The aboCreditcard
     * Meta information extracted from the WSDL
     * - documentation: Creditcardgegevens in geval van betaalwijze creditcard
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AbonnementApiV6\StructType\Creditcard
     */
    public $aboCreditcard;
    /**
     * The aboVerzendingBestandType
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3,4] Bestandtype voor verzending: 0 (Default) is standaard verzending. 4 is Overig. Waarden 1, 2 en 3 zijn klantspecifiek toe te wijzen
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aboVerzendingBestandType;
    /**
     * Constructor method for AboObject
     * @uses AboObject::setAboAboSoortCode()
     * @uses AboObject::setAboActieCode()
     * @uses AboObject::setAboBetaalReferentie()
     * @uses AboObject::setAboBetaalwijze()
     * @uses AboObject::setAboHerkomstCode()
     * @uses AboObject::setAboIngangsDatum()
     * @uses AboObject::setAboPakketCode()
     * @uses AboObject::setAboPremiumCodeAbo()
     * @uses AboObject::setAboPremiumCodeBetaler()
     * @uses AboObject::setAboRekNr()
     * @uses AboObject::setAboRekIbanNr()
     * @uses AboObject::setAboRekBicCode()
     * @uses AboObject::setAboMachtigingsDatum()
     * @uses AboObject::setAboAantalExemplaren()
     * @uses AboObject::setAboAdresType()
     * @uses AboObject::setAboFactuurNaarPriveadres()
     * @uses AboObject::setAboVastKortingBedr()
     * @uses AboObject::setAboVastKortingPerc()
     * @uses AboObject::setAboVastKortingOmschr()
     * @uses AboObject::setAboEenmaligeKortingBedr()
     * @uses AboObject::setAboEenmaligeKortingPerc()
     * @uses AboObject::setAboEenmaligeKortingOmschr()
     * @uses AboObject::setAboEenmaligeKortingCode()
     * @uses AboObject::setAboPropositieCode()
     * @uses AboObject::setAboPrijsPropositie()
     * @uses AboObject::setAboIngevoerdDoor()
     * @uses AboObject::setAboVrijeVelden()
     * @uses AboObject::setAboOrdernummer()
     * @uses AboObject::setAboCreditcard()
     * @uses AboObject::setAboVerzendingBestandType()
     * @param string $aboAboSoortCode
     * @param string $aboActieCode
     * @param string $aboBetaalReferentie
     * @param int $aboBetaalwijze
     * @param string $aboHerkomstCode
     * @param string $aboIngangsDatum
     * @param string $aboPakketCode
     * @param string $aboPremiumCodeAbo
     * @param string $aboPremiumCodeBetaler
     * @param string $aboRekNr
     * @param string $aboRekIbanNr
     * @param string $aboRekBicCode
     * @param string $aboMachtigingsDatum
     * @param int $aboAantalExemplaren
     * @param int $aboAdresType
     * @param bool $aboFactuurNaarPriveadres
     * @param float $aboVastKortingBedr
     * @param float $aboVastKortingPerc
     * @param string $aboVastKortingOmschr
     * @param float $aboEenmaligeKortingBedr
     * @param float $aboEenmaligeKortingPerc
     * @param string $aboEenmaligeKortingOmschr
     * @param string $aboEenmaligeKortingCode
     * @param string $aboPropositieCode
     * @param float $aboPrijsPropositie
     * @param string $aboIngevoerdDoor
     * @param \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden
     * @param string $aboOrdernummer
     * @param \AbonnementApiV6\StructType\Creditcard $aboCreditcard
     * @param int $aboVerzendingBestandType
     */
    public function __construct($aboAboSoortCode = null, $aboActieCode = null, $aboBetaalReferentie = null, $aboBetaalwijze = null, $aboHerkomstCode = null, $aboIngangsDatum = null, $aboPakketCode = null, $aboPremiumCodeAbo = null, $aboPremiumCodeBetaler = null, $aboRekNr = null, $aboRekIbanNr = null, $aboRekBicCode = null, $aboMachtigingsDatum = null, $aboAantalExemplaren = null, $aboAdresType = null, $aboFactuurNaarPriveadres = null, $aboVastKortingBedr = null, $aboVastKortingPerc = null, $aboVastKortingOmschr = null, $aboEenmaligeKortingBedr = null, $aboEenmaligeKortingPerc = null, $aboEenmaligeKortingOmschr = null, $aboEenmaligeKortingCode = null, $aboPropositieCode = null, $aboPrijsPropositie = null, $aboIngevoerdDoor = null, \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden = null, $aboOrdernummer = null, \AbonnementApiV6\StructType\Creditcard $aboCreditcard = null, $aboVerzendingBestandType = null)
    {
        $this
            ->setAboAboSoortCode($aboAboSoortCode)
            ->setAboActieCode($aboActieCode)
            ->setAboBetaalReferentie($aboBetaalReferentie)
            ->setAboBetaalwijze($aboBetaalwijze)
            ->setAboHerkomstCode($aboHerkomstCode)
            ->setAboIngangsDatum($aboIngangsDatum)
            ->setAboPakketCode($aboPakketCode)
            ->setAboPremiumCodeAbo($aboPremiumCodeAbo)
            ->setAboPremiumCodeBetaler($aboPremiumCodeBetaler)
            ->setAboRekNr($aboRekNr)
            ->setAboRekIbanNr($aboRekIbanNr)
            ->setAboRekBicCode($aboRekBicCode)
            ->setAboMachtigingsDatum($aboMachtigingsDatum)
            ->setAboAantalExemplaren($aboAantalExemplaren)
            ->setAboAdresType($aboAdresType)
            ->setAboFactuurNaarPriveadres($aboFactuurNaarPriveadres)
            ->setAboVastKortingBedr($aboVastKortingBedr)
            ->setAboVastKortingPerc($aboVastKortingPerc)
            ->setAboVastKortingOmschr($aboVastKortingOmschr)
            ->setAboEenmaligeKortingBedr($aboEenmaligeKortingBedr)
            ->setAboEenmaligeKortingPerc($aboEenmaligeKortingPerc)
            ->setAboEenmaligeKortingOmschr($aboEenmaligeKortingOmschr)
            ->setAboEenmaligeKortingCode($aboEenmaligeKortingCode)
            ->setAboPropositieCode($aboPropositieCode)
            ->setAboPrijsPropositie($aboPrijsPropositie)
            ->setAboIngevoerdDoor($aboIngevoerdDoor)
            ->setAboVrijeVelden($aboVrijeVelden)
            ->setAboOrdernummer($aboOrdernummer)
            ->setAboCreditcard($aboCreditcard)
            ->setAboVerzendingBestandType($aboVerzendingBestandType);
    }
    /**
     * Get aboAboSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboAboSoortCode()
    {
        return isset($this->aboAboSoortCode) ? $this->aboAboSoortCode : null;
    }
    /**
     * Set aboAboSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboAboSoortCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboAboSoortCode($aboAboSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboAboSoortCode) && !is_string($aboAboSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboAboSoortCode, true), gettype($aboAboSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aboAboSoortCode) && mb_strlen($aboAboSoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aboAboSoortCode)), __LINE__);
        }
        if (is_null($aboAboSoortCode) || (is_array($aboAboSoortCode) && empty($aboAboSoortCode))) {
            unset($this->aboAboSoortCode);
        } else {
            $this->aboAboSoortCode = $aboAboSoortCode;
        }
        return $this;
    }
    /**
     * Get aboActieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboActieCode()
    {
        return isset($this->aboActieCode) ? $this->aboActieCode : null;
    }
    /**
     * Set aboActieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboActieCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboActieCode($aboActieCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboActieCode) && !is_string($aboActieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboActieCode, true), gettype($aboActieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboActieCode) && mb_strlen($aboActieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboActieCode)), __LINE__);
        }
        if (is_null($aboActieCode) || (is_array($aboActieCode) && empty($aboActieCode))) {
            unset($this->aboActieCode);
        } else {
            $this->aboActieCode = $aboActieCode;
        }
        return $this;
    }
    /**
     * Get aboBetaalReferentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboBetaalReferentie()
    {
        return isset($this->aboBetaalReferentie) ? $this->aboBetaalReferentie : null;
    }
    /**
     * Set aboBetaalReferentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboBetaalReferentie
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboBetaalReferentie($aboBetaalReferentie = null)
    {
        // validation for constraint: string
        if (!is_null($aboBetaalReferentie) && !is_string($aboBetaalReferentie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboBetaalReferentie, true), gettype($aboBetaalReferentie)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($aboBetaalReferentie) && mb_strlen($aboBetaalReferentie) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($aboBetaalReferentie)), __LINE__);
        }
        if (is_null($aboBetaalReferentie) || (is_array($aboBetaalReferentie) && empty($aboBetaalReferentie))) {
            unset($this->aboBetaalReferentie);
        } else {
            $this->aboBetaalReferentie = $aboBetaalReferentie;
        }
        return $this;
    }
    /**
     * Get aboBetaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboBetaalwijze()
    {
        return isset($this->aboBetaalwijze) ? $this->aboBetaalwijze : null;
    }
    /**
     * Set aboBetaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboBetaalwijze
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboBetaalwijze($aboBetaalwijze = null)
    {
        // validation for constraint: int
        if (!is_null($aboBetaalwijze) && !(is_int($aboBetaalwijze) || ctype_digit($aboBetaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboBetaalwijze, true), gettype($aboBetaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboBetaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $aboBetaalwijze)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboBetaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $aboBetaalwijze))), __LINE__);
        }
        if (is_null($aboBetaalwijze) || (is_array($aboBetaalwijze) && empty($aboBetaalwijze))) {
            unset($this->aboBetaalwijze);
        } else {
            $this->aboBetaalwijze = $aboBetaalwijze;
        }
        return $this;
    }
    /**
     * Get aboHerkomstCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboHerkomstCode()
    {
        return isset($this->aboHerkomstCode) ? $this->aboHerkomstCode : null;
    }
    /**
     * Set aboHerkomstCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboHerkomstCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboHerkomstCode($aboHerkomstCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboHerkomstCode) && !is_string($aboHerkomstCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboHerkomstCode, true), gettype($aboHerkomstCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aboHerkomstCode) && mb_strlen($aboHerkomstCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aboHerkomstCode)), __LINE__);
        }
        if (is_null($aboHerkomstCode) || (is_array($aboHerkomstCode) && empty($aboHerkomstCode))) {
            unset($this->aboHerkomstCode);
        } else {
            $this->aboHerkomstCode = $aboHerkomstCode;
        }
        return $this;
    }
    /**
     * Get aboIngangsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngangsDatum()
    {
        return isset($this->aboIngangsDatum) ? $this->aboIngangsDatum : null;
    }
    /**
     * Set aboIngangsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngangsDatum
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboIngangsDatum($aboIngangsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboIngangsDatum) && !is_string($aboIngangsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboIngangsDatum, true), gettype($aboIngangsDatum)), __LINE__);
        }
        if (is_null($aboIngangsDatum) || (is_array($aboIngangsDatum) && empty($aboIngangsDatum))) {
            unset($this->aboIngangsDatum);
        } else {
            $this->aboIngangsDatum = $aboIngangsDatum;
        }
        return $this;
    }
    /**
     * Get aboPakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPakketCode()
    {
        return isset($this->aboPakketCode) ? $this->aboPakketCode : null;
    }
    /**
     * Set aboPakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPakketCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboPakketCode($aboPakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboPakketCode) && !is_string($aboPakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboPakketCode, true), gettype($aboPakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboPakketCode) && mb_strlen($aboPakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboPakketCode)), __LINE__);
        }
        if (is_null($aboPakketCode) || (is_array($aboPakketCode) && empty($aboPakketCode))) {
            unset($this->aboPakketCode);
        } else {
            $this->aboPakketCode = $aboPakketCode;
        }
        return $this;
    }
    /**
     * Get aboPremiumCodeAbo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPremiumCodeAbo()
    {
        return isset($this->aboPremiumCodeAbo) ? $this->aboPremiumCodeAbo : null;
    }
    /**
     * Set aboPremiumCodeAbo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPremiumCodeAbo
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboPremiumCodeAbo($aboPremiumCodeAbo = null)
    {
        // validation for constraint: string
        if (!is_null($aboPremiumCodeAbo) && !is_string($aboPremiumCodeAbo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboPremiumCodeAbo, true), gettype($aboPremiumCodeAbo)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aboPremiumCodeAbo) && mb_strlen($aboPremiumCodeAbo) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aboPremiumCodeAbo)), __LINE__);
        }
        if (is_null($aboPremiumCodeAbo) || (is_array($aboPremiumCodeAbo) && empty($aboPremiumCodeAbo))) {
            unset($this->aboPremiumCodeAbo);
        } else {
            $this->aboPremiumCodeAbo = $aboPremiumCodeAbo;
        }
        return $this;
    }
    /**
     * Get aboPremiumCodeBetaler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPremiumCodeBetaler()
    {
        return isset($this->aboPremiumCodeBetaler) ? $this->aboPremiumCodeBetaler : null;
    }
    /**
     * Set aboPremiumCodeBetaler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPremiumCodeBetaler
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboPremiumCodeBetaler($aboPremiumCodeBetaler = null)
    {
        // validation for constraint: string
        if (!is_null($aboPremiumCodeBetaler) && !is_string($aboPremiumCodeBetaler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboPremiumCodeBetaler, true), gettype($aboPremiumCodeBetaler)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($aboPremiumCodeBetaler) && mb_strlen($aboPremiumCodeBetaler) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($aboPremiumCodeBetaler)), __LINE__);
        }
        if (is_null($aboPremiumCodeBetaler) || (is_array($aboPremiumCodeBetaler) && empty($aboPremiumCodeBetaler))) {
            unset($this->aboPremiumCodeBetaler);
        } else {
            $this->aboPremiumCodeBetaler = $aboPremiumCodeBetaler;
        }
        return $this;
    }
    /**
     * Get aboRekNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekNr()
    {
        return isset($this->aboRekNr) ? $this->aboRekNr : null;
    }
    /**
     * Set aboRekNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekNr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboRekNr($aboRekNr = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekNr) && !is_string($aboRekNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekNr, true), gettype($aboRekNr)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($aboRekNr) && mb_strlen($aboRekNr) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($aboRekNr)), __LINE__);
        }
        if (is_null($aboRekNr) || (is_array($aboRekNr) && empty($aboRekNr))) {
            unset($this->aboRekNr);
        } else {
            $this->aboRekNr = $aboRekNr;
        }
        return $this;
    }
    /**
     * Get aboRekIbanNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekIbanNr()
    {
        return isset($this->aboRekIbanNr) ? $this->aboRekIbanNr : null;
    }
    /**
     * Set aboRekIbanNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekIbanNr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboRekIbanNr($aboRekIbanNr = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekIbanNr) && !is_string($aboRekIbanNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekIbanNr, true), gettype($aboRekIbanNr)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($aboRekIbanNr) && mb_strlen($aboRekIbanNr) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($aboRekIbanNr)), __LINE__);
        }
        if (is_null($aboRekIbanNr) || (is_array($aboRekIbanNr) && empty($aboRekIbanNr))) {
            unset($this->aboRekIbanNr);
        } else {
            $this->aboRekIbanNr = $aboRekIbanNr;
        }
        return $this;
    }
    /**
     * Get aboRekBicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboRekBicCode()
    {
        return isset($this->aboRekBicCode) ? $this->aboRekBicCode : null;
    }
    /**
     * Set aboRekBicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboRekBicCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboRekBicCode($aboRekBicCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboRekBicCode) && !is_string($aboRekBicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboRekBicCode, true), gettype($aboRekBicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($aboRekBicCode) && mb_strlen($aboRekBicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($aboRekBicCode)), __LINE__);
        }
        if (is_null($aboRekBicCode) || (is_array($aboRekBicCode) && empty($aboRekBicCode))) {
            unset($this->aboRekBicCode);
        } else {
            $this->aboRekBicCode = $aboRekBicCode;
        }
        return $this;
    }
    /**
     * Get aboMachtigingsDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboMachtigingsDatum()
    {
        return isset($this->aboMachtigingsDatum) ? $this->aboMachtigingsDatum : null;
    }
    /**
     * Set aboMachtigingsDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboMachtigingsDatum
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboMachtigingsDatum($aboMachtigingsDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboMachtigingsDatum) && !is_string($aboMachtigingsDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboMachtigingsDatum, true), gettype($aboMachtigingsDatum)), __LINE__);
        }
        if (is_null($aboMachtigingsDatum) || (is_array($aboMachtigingsDatum) && empty($aboMachtigingsDatum))) {
            unset($this->aboMachtigingsDatum);
        } else {
            $this->aboMachtigingsDatum = $aboMachtigingsDatum;
        }
        return $this;
    }
    /**
     * Get aboAantalExemplaren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboAantalExemplaren()
    {
        return isset($this->aboAantalExemplaren) ? $this->aboAantalExemplaren : null;
    }
    /**
     * Set aboAantalExemplaren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboAantalExemplaren
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboAantalExemplaren($aboAantalExemplaren = null)
    {
        // validation for constraint: int
        if (!is_null($aboAantalExemplaren) && !(is_int($aboAantalExemplaren) || ctype_digit($aboAantalExemplaren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboAantalExemplaren, true), gettype($aboAantalExemplaren)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboAantalExemplaren) && mb_strlen(preg_replace('/(\D)/', '', $aboAantalExemplaren)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboAantalExemplaren, true), mb_strlen(preg_replace('/(\D)/', '', $aboAantalExemplaren))), __LINE__);
        }
        if (is_null($aboAantalExemplaren) || (is_array($aboAantalExemplaren) && empty($aboAantalExemplaren))) {
            unset($this->aboAantalExemplaren);
        } else {
            $this->aboAantalExemplaren = $aboAantalExemplaren;
        }
        return $this;
    }
    /**
     * Get aboAdresType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboAdresType()
    {
        return isset($this->aboAdresType) ? $this->aboAdresType : null;
    }
    /**
     * Set aboAdresType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboAdresType
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboAdresType($aboAdresType = null)
    {
        // validation for constraint: int
        if (!is_null($aboAdresType) && !(is_int($aboAdresType) || ctype_digit($aboAdresType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboAdresType, true), gettype($aboAdresType)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($aboAdresType) && mb_strlen(preg_replace('/(\D)/', '', $aboAdresType)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($aboAdresType, true), mb_strlen(preg_replace('/(\D)/', '', $aboAdresType))), __LINE__);
        }
        if (is_null($aboAdresType) || (is_array($aboAdresType) && empty($aboAdresType))) {
            unset($this->aboAdresType);
        } else {
            $this->aboAdresType = $aboAdresType;
        }
        return $this;
    }
    /**
     * Get aboFactuurNaarPriveadres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAboFactuurNaarPriveadres()
    {
        return isset($this->aboFactuurNaarPriveadres) ? $this->aboFactuurNaarPriveadres : null;
    }
    /**
     * Set aboFactuurNaarPriveadres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aboFactuurNaarPriveadres
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboFactuurNaarPriveadres($aboFactuurNaarPriveadres = null)
    {
        // validation for constraint: boolean
        if (!is_null($aboFactuurNaarPriveadres) && !is_bool($aboFactuurNaarPriveadres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aboFactuurNaarPriveadres, true), gettype($aboFactuurNaarPriveadres)), __LINE__);
        }
        if (is_null($aboFactuurNaarPriveadres) || (is_array($aboFactuurNaarPriveadres) && empty($aboFactuurNaarPriveadres))) {
            unset($this->aboFactuurNaarPriveadres);
        } else {
            $this->aboFactuurNaarPriveadres = $aboFactuurNaarPriveadres;
        }
        return $this;
    }
    /**
     * Get aboVastKortingBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboVastKortingBedr()
    {
        return isset($this->aboVastKortingBedr) ? $this->aboVastKortingBedr : null;
    }
    /**
     * Set aboVastKortingBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboVastKortingBedr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboVastKortingBedr($aboVastKortingBedr = null)
    {
        // validation for constraint: float
        if (!is_null($aboVastKortingBedr) && !(is_float($aboVastKortingBedr) || is_numeric($aboVastKortingBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboVastKortingBedr, true), gettype($aboVastKortingBedr)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($aboVastKortingBedr) && mb_strlen(mb_substr($aboVastKortingBedr, false !== mb_strpos($aboVastKortingBedr, '.') ? mb_strpos($aboVastKortingBedr, '.') + 1 : mb_strlen($aboVastKortingBedr))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($aboVastKortingBedr, true), mb_strlen(mb_substr($aboVastKortingBedr, mb_strpos($aboVastKortingBedr, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($aboVastKortingBedr) && mb_strlen(preg_replace('/(\D)/', '', $aboVastKortingBedr)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($aboVastKortingBedr, true), mb_strlen(preg_replace('/(\D)/', '', $aboVastKortingBedr))), __LINE__);
        }
        if (is_null($aboVastKortingBedr) || (is_array($aboVastKortingBedr) && empty($aboVastKortingBedr))) {
            unset($this->aboVastKortingBedr);
        } else {
            $this->aboVastKortingBedr = $aboVastKortingBedr;
        }
        return $this;
    }
    /**
     * Get aboVastKortingPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboVastKortingPerc()
    {
        return isset($this->aboVastKortingPerc) ? $this->aboVastKortingPerc : null;
    }
    /**
     * Set aboVastKortingPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboVastKortingPerc
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboVastKortingPerc($aboVastKortingPerc = null)
    {
        // validation for constraint: float
        if (!is_null($aboVastKortingPerc) && !(is_float($aboVastKortingPerc) || is_numeric($aboVastKortingPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboVastKortingPerc, true), gettype($aboVastKortingPerc)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($aboVastKortingPerc) && mb_strlen(mb_substr($aboVastKortingPerc, false !== mb_strpos($aboVastKortingPerc, '.') ? mb_strpos($aboVastKortingPerc, '.') + 1 : mb_strlen($aboVastKortingPerc))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($aboVastKortingPerc, true), mb_strlen(mb_substr($aboVastKortingPerc, mb_strpos($aboVastKortingPerc, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($aboVastKortingPerc) && mb_strlen(preg_replace('/(\D)/', '', $aboVastKortingPerc)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($aboVastKortingPerc, true), mb_strlen(preg_replace('/(\D)/', '', $aboVastKortingPerc))), __LINE__);
        }
        if (is_null($aboVastKortingPerc) || (is_array($aboVastKortingPerc) && empty($aboVastKortingPerc))) {
            unset($this->aboVastKortingPerc);
        } else {
            $this->aboVastKortingPerc = $aboVastKortingPerc;
        }
        return $this;
    }
    /**
     * Get aboVastKortingOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboVastKortingOmschr()
    {
        return isset($this->aboVastKortingOmschr) ? $this->aboVastKortingOmschr : null;
    }
    /**
     * Set aboVastKortingOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboVastKortingOmschr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboVastKortingOmschr($aboVastKortingOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($aboVastKortingOmschr) && !is_string($aboVastKortingOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboVastKortingOmschr, true), gettype($aboVastKortingOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($aboVastKortingOmschr) && mb_strlen($aboVastKortingOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($aboVastKortingOmschr)), __LINE__);
        }
        if (is_null($aboVastKortingOmschr) || (is_array($aboVastKortingOmschr) && empty($aboVastKortingOmschr))) {
            unset($this->aboVastKortingOmschr);
        } else {
            $this->aboVastKortingOmschr = $aboVastKortingOmschr;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingBedr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboEenmaligeKortingBedr()
    {
        return isset($this->aboEenmaligeKortingBedr) ? $this->aboEenmaligeKortingBedr : null;
    }
    /**
     * Set aboEenmaligeKortingBedr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboEenmaligeKortingBedr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboEenmaligeKortingBedr($aboEenmaligeKortingBedr = null)
    {
        // validation for constraint: float
        if (!is_null($aboEenmaligeKortingBedr) && !(is_float($aboEenmaligeKortingBedr) || is_numeric($aboEenmaligeKortingBedr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboEenmaligeKortingBedr, true), gettype($aboEenmaligeKortingBedr)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($aboEenmaligeKortingBedr) && mb_strlen(mb_substr($aboEenmaligeKortingBedr, false !== mb_strpos($aboEenmaligeKortingBedr, '.') ? mb_strpos($aboEenmaligeKortingBedr, '.') + 1 : mb_strlen($aboEenmaligeKortingBedr))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($aboEenmaligeKortingBedr, true), mb_strlen(mb_substr($aboEenmaligeKortingBedr, mb_strpos($aboEenmaligeKortingBedr, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($aboEenmaligeKortingBedr) && mb_strlen(preg_replace('/(\D)/', '', $aboEenmaligeKortingBedr)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($aboEenmaligeKortingBedr, true), mb_strlen(preg_replace('/(\D)/', '', $aboEenmaligeKortingBedr))), __LINE__);
        }
        if (is_null($aboEenmaligeKortingBedr) || (is_array($aboEenmaligeKortingBedr) && empty($aboEenmaligeKortingBedr))) {
            unset($this->aboEenmaligeKortingBedr);
        } else {
            $this->aboEenmaligeKortingBedr = $aboEenmaligeKortingBedr;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingPerc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboEenmaligeKortingPerc()
    {
        return isset($this->aboEenmaligeKortingPerc) ? $this->aboEenmaligeKortingPerc : null;
    }
    /**
     * Set aboEenmaligeKortingPerc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboEenmaligeKortingPerc
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboEenmaligeKortingPerc($aboEenmaligeKortingPerc = null)
    {
        // validation for constraint: float
        if (!is_null($aboEenmaligeKortingPerc) && !(is_float($aboEenmaligeKortingPerc) || is_numeric($aboEenmaligeKortingPerc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboEenmaligeKortingPerc, true), gettype($aboEenmaligeKortingPerc)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($aboEenmaligeKortingPerc) && mb_strlen(mb_substr($aboEenmaligeKortingPerc, false !== mb_strpos($aboEenmaligeKortingPerc, '.') ? mb_strpos($aboEenmaligeKortingPerc, '.') + 1 : mb_strlen($aboEenmaligeKortingPerc))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($aboEenmaligeKortingPerc, true), mb_strlen(mb_substr($aboEenmaligeKortingPerc, mb_strpos($aboEenmaligeKortingPerc, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($aboEenmaligeKortingPerc) && mb_strlen(preg_replace('/(\D)/', '', $aboEenmaligeKortingPerc)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($aboEenmaligeKortingPerc, true), mb_strlen(preg_replace('/(\D)/', '', $aboEenmaligeKortingPerc))), __LINE__);
        }
        if (is_null($aboEenmaligeKortingPerc) || (is_array($aboEenmaligeKortingPerc) && empty($aboEenmaligeKortingPerc))) {
            unset($this->aboEenmaligeKortingPerc);
        } else {
            $this->aboEenmaligeKortingPerc = $aboEenmaligeKortingPerc;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboEenmaligeKortingOmschr()
    {
        return isset($this->aboEenmaligeKortingOmschr) ? $this->aboEenmaligeKortingOmschr : null;
    }
    /**
     * Set aboEenmaligeKortingOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboEenmaligeKortingOmschr
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboEenmaligeKortingOmschr($aboEenmaligeKortingOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($aboEenmaligeKortingOmschr) && !is_string($aboEenmaligeKortingOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboEenmaligeKortingOmschr, true), gettype($aboEenmaligeKortingOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($aboEenmaligeKortingOmschr) && mb_strlen($aboEenmaligeKortingOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($aboEenmaligeKortingOmschr)), __LINE__);
        }
        if (is_null($aboEenmaligeKortingOmschr) || (is_array($aboEenmaligeKortingOmschr) && empty($aboEenmaligeKortingOmschr))) {
            unset($this->aboEenmaligeKortingOmschr);
        } else {
            $this->aboEenmaligeKortingOmschr = $aboEenmaligeKortingOmschr;
        }
        return $this;
    }
    /**
     * Get aboEenmaligeKortingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboEenmaligeKortingCode()
    {
        return isset($this->aboEenmaligeKortingCode) ? $this->aboEenmaligeKortingCode : null;
    }
    /**
     * Set aboEenmaligeKortingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboEenmaligeKortingCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboEenmaligeKortingCode($aboEenmaligeKortingCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboEenmaligeKortingCode) && !is_string($aboEenmaligeKortingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboEenmaligeKortingCode, true), gettype($aboEenmaligeKortingCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboEenmaligeKortingCode) && mb_strlen($aboEenmaligeKortingCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboEenmaligeKortingCode)), __LINE__);
        }
        if (is_null($aboEenmaligeKortingCode) || (is_array($aboEenmaligeKortingCode) && empty($aboEenmaligeKortingCode))) {
            unset($this->aboEenmaligeKortingCode);
        } else {
            $this->aboEenmaligeKortingCode = $aboEenmaligeKortingCode;
        }
        return $this;
    }
    /**
     * Get aboPropositieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboPropositieCode()
    {
        return isset($this->aboPropositieCode) ? $this->aboPropositieCode : null;
    }
    /**
     * Set aboPropositieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboPropositieCode
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboPropositieCode($aboPropositieCode = null)
    {
        // validation for constraint: string
        if (!is_null($aboPropositieCode) && !is_string($aboPropositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboPropositieCode, true), gettype($aboPropositieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aboPropositieCode) && mb_strlen($aboPropositieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aboPropositieCode)), __LINE__);
        }
        if (is_null($aboPropositieCode) || (is_array($aboPropositieCode) && empty($aboPropositieCode))) {
            unset($this->aboPropositieCode);
        } else {
            $this->aboPropositieCode = $aboPropositieCode;
        }
        return $this;
    }
    /**
     * Get aboPrijsPropositie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAboPrijsPropositie()
    {
        return isset($this->aboPrijsPropositie) ? $this->aboPrijsPropositie : null;
    }
    /**
     * Set aboPrijsPropositie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aboPrijsPropositie
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboPrijsPropositie($aboPrijsPropositie = null)
    {
        // validation for constraint: float
        if (!is_null($aboPrijsPropositie) && !(is_float($aboPrijsPropositie) || is_numeric($aboPrijsPropositie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboPrijsPropositie, true), gettype($aboPrijsPropositie)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($aboPrijsPropositie) && mb_strlen(mb_substr($aboPrijsPropositie, false !== mb_strpos($aboPrijsPropositie, '.') ? mb_strpos($aboPrijsPropositie, '.') + 1 : mb_strlen($aboPrijsPropositie))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($aboPrijsPropositie, true), mb_strlen(mb_substr($aboPrijsPropositie, mb_strpos($aboPrijsPropositie, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($aboPrijsPropositie) && mb_strlen(preg_replace('/(\D)/', '', $aboPrijsPropositie)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($aboPrijsPropositie, true), mb_strlen(preg_replace('/(\D)/', '', $aboPrijsPropositie))), __LINE__);
        }
        if (is_null($aboPrijsPropositie) || (is_array($aboPrijsPropositie) && empty($aboPrijsPropositie))) {
            unset($this->aboPrijsPropositie);
        } else {
            $this->aboPrijsPropositie = $aboPrijsPropositie;
        }
        return $this;
    }
    /**
     * Get aboIngevoerdDoor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboIngevoerdDoor()
    {
        return isset($this->aboIngevoerdDoor) ? $this->aboIngevoerdDoor : null;
    }
    /**
     * Set aboIngevoerdDoor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboIngevoerdDoor
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboIngevoerdDoor($aboIngevoerdDoor = null)
    {
        // validation for constraint: string
        if (!is_null($aboIngevoerdDoor) && !is_string($aboIngevoerdDoor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboIngevoerdDoor, true), gettype($aboIngevoerdDoor)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($aboIngevoerdDoor) && mb_strlen($aboIngevoerdDoor) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($aboIngevoerdDoor)), __LINE__);
        }
        if (is_null($aboIngevoerdDoor) || (is_array($aboIngevoerdDoor) && empty($aboIngevoerdDoor))) {
            unset($this->aboIngevoerdDoor);
        } else {
            $this->aboIngevoerdDoor = $aboIngevoerdDoor;
        }
        return $this;
    }
    /**
     * Get aboVrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\VrijeVeldenAboRec|null
     */
    public function getAboVrijeVelden()
    {
        return isset($this->aboVrijeVelden) ? $this->aboVrijeVelden : null;
    }
    /**
     * Set aboVrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboVrijeVelden(\AbonnementApiV6\StructType\VrijeVeldenAboRec $aboVrijeVelden = null)
    {
        if (is_null($aboVrijeVelden) || (is_array($aboVrijeVelden) && empty($aboVrijeVelden))) {
            unset($this->aboVrijeVelden);
        } else {
            $this->aboVrijeVelden = $aboVrijeVelden;
        }
        return $this;
    }
    /**
     * Get aboOrdernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboOrdernummer()
    {
        return isset($this->aboOrdernummer) ? $this->aboOrdernummer : null;
    }
    /**
     * Set aboOrdernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboOrdernummer
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboOrdernummer($aboOrdernummer = null)
    {
        // validation for constraint: string
        if (!is_null($aboOrdernummer) && !is_string($aboOrdernummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboOrdernummer, true), gettype($aboOrdernummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($aboOrdernummer) && mb_strlen($aboOrdernummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($aboOrdernummer)), __LINE__);
        }
        if (is_null($aboOrdernummer) || (is_array($aboOrdernummer) && empty($aboOrdernummer))) {
            unset($this->aboOrdernummer);
        } else {
            $this->aboOrdernummer = $aboOrdernummer;
        }
        return $this;
    }
    /**
     * Get aboCreditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AbonnementApiV6\StructType\Creditcard|null
     */
    public function getAboCreditcard()
    {
        return isset($this->aboCreditcard) ? $this->aboCreditcard : null;
    }
    /**
     * Set aboCreditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AbonnementApiV6\StructType\Creditcard $aboCreditcard
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboCreditcard(\AbonnementApiV6\StructType\Creditcard $aboCreditcard = null)
    {
        if (is_null($aboCreditcard) || (is_array($aboCreditcard) && empty($aboCreditcard))) {
            unset($this->aboCreditcard);
        } else {
            $this->aboCreditcard = $aboCreditcard;
        }
        return $this;
    }
    /**
     * Get aboVerzendingBestandType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAboVerzendingBestandType()
    {
        return isset($this->aboVerzendingBestandType) ? $this->aboVerzendingBestandType : null;
    }
    /**
     * Set aboVerzendingBestandType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aboVerzendingBestandType
     * @return \AbonnementApiV6\StructType\AboObject
     */
    public function setAboVerzendingBestandType($aboVerzendingBestandType = null)
    {
        // validation for constraint: int
        if (!is_null($aboVerzendingBestandType) && !(is_int($aboVerzendingBestandType) || ctype_digit($aboVerzendingBestandType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aboVerzendingBestandType, true), gettype($aboVerzendingBestandType)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aboVerzendingBestandType) && mb_strlen(preg_replace('/(\D)/', '', $aboVerzendingBestandType)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aboVerzendingBestandType, true), mb_strlen(preg_replace('/(\D)/', '', $aboVerzendingBestandType))), __LINE__);
        }
        if (is_null($aboVerzendingBestandType) || (is_array($aboVerzendingBestandType) && empty($aboVerzendingBestandType))) {
            unset($this->aboVerzendingBestandType);
        } else {
            $this->aboVerzendingBestandType = $aboVerzendingBestandType;
        }
        return $this;
    }
}
