<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Switch ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class _Switch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named switchAbonnement
     * Meta information extracted from the WSDL
     * - documentation: Een bestaand abonnement omzetten (switchen) naar een andere abonnementsvorm.error1: Het abonnement is niet gevondenerror12: Er is geen abonnement opgegevenerror23: De premium voor de abonnee is niet gevondenerror33: Geef of een
     * abonnementsoort- of een pakketcode operror34: De actie is niet gevondenerror36: De ingangsdatum van de actie is nog niet ingegaanerror56: De abonnementsoort is niet actieferror57: De actie is niet actieferror58: De premium voor de abonnee is niet
     * actieferror88: Het opgegeven pakket is niet bekenderror89: Het opgegeven pakket is niet actieferror91: De premium voor de debiteur is niet actieferror92: De abonnementsoort is niet bekenderror95: De ingangsdatum van de actie is nog niet
     * ingegaanerror96: De einddatum van de actie is verstrekenerror97: De premium voor de abonnee is niet gekoppeld aan de propositieerror98: De premium voor de debiteur is niet gekoppeld aan de propositieerror127: De abonnementsoort is niet gekoppeld aan
     * de actieerror128: Het pakket is niet gekoppeld aan de actieerror131: Een betaalwijze anders dan incasso is niet toegestaan voor dit abonnementerror181: De stopreden is niet gevondenerror215: Het IBAN nummer is ongeldigerror216: De BIC code is
     * ongeldigerror217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplichterror218: Het IBAN nummer dient samen met de BIC code opgegeven te wordenerror219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummererror240: De
     * eenmalige korting is niet gevondenerror241: De eenmalige korting is niet actief en mag niet toegekend wordenerror242: Een losse eenmalige korting mag niet in combinatie met een voorgedefinieerde eenmalige korting toegekend wordenerror256: De proposie
     * is niet gevondenerror257: De propositie is niet actieferror258: Op basis van de opgegeven abosoort/pakket/propositiecode en actiecode zijn meerdere proposities gevondenerror259: De opgegeven vrije code 3 is niet bekenderror260: Een propositiecode
     * dient in combinatie met een actiecode opgegeven te wordenerror261: De opgegeven vrije code 1 is niet bekenderror262: De opgegeven vrije code 2 is niet bekenderror263: De opgegeven vrije code 4 is niet bekenderror264: Bij betaalwijze creditcard zijn
     * gegevens van de creditcard verplichterror265: Een betaalwijze anders dan factuur per mail is niet toegestaan voor dit abonnementerror268: Een kortingsbedrag of percentage mag niet negatief zijnerror269: Een abonnement mag maximaal 1 kortingsbedrag of
     * kortingspercentage bevattenerror272: Bij het gekozen product is een abonnee met incomplete NAW gegevens niet toegestaanerror277: De eenmalige korting valt buiten zijn geldigheidsperiodeerror278: De eenmalige korting is al tot het maximum aantal keer
     * gebruikterror279: De eenmalige korting kan niet gebruikt worden in combinatie met de abonnementsoorterror280: De uitgave is niet leverbaar op dit adreserror281: De uitgave is binnenkort niet meer leverbaar op dit adres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\SwitchAbonnementRequest $request_parameters
     * @return \AbonnementApiV6\StructType\SwitchAbonnementResponse|bool
     */
    public function switchAbonnement(\AbonnementApiV6\StructType\SwitchAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->switchAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\SwitchAbonnementResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
