<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named testConnection
     * Meta information extracted from the WSDL
     * - documentation: Operatie t.b.v. het testen van de database verbinding, authenticatie en beschikbare operaties.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\TestConnectionRequest $request_parameters
     * @return \AbonnementApiV6\StructType\TestConnectionResponse|bool
     */
    public function testConnection(\AbonnementApiV6\StructType\TestConnectionRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->testConnection($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\TestConnectionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
