<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchAbonnement
     * Meta information extracted from the WSDL
     * - documentation: Zoeken van abonnements informatie.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\SearchAbonnementRequest $request_parameters
     * @return \AbonnementApiV6\StructType\SearchAbonnementResponse|bool
     */
    public function searchAbonnement(\AbonnementApiV6\StructType\SearchAbonnementRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchAbonnement($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchAbonnementByCred
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.error11: Op basis van de opgegeven username en password is er meer dan 1 abonnement gevondenerror12: Op basis van de opgegeven username
     * en password is er meer dan 1 relatie gevondenerror14: Op basis van de opgegeven username en password is geen relatie of abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\SearchAbonnementByCredRequest $request_parameters
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredResponse|bool
     */
    public function searchAbonnementByCred(\AbonnementApiV6\StructType\SearchAbonnementByCredRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchAbonnementByCred($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSmartcode
     * Meta information extracted from the WSDL
     * - documentation: Geeft het aboneementnummer terug van het abonnement behorende bij de smartcode.error1: Op basis van de smartcode is geen abonnement gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\SearchSmartcodeRequest $request_parameters
     * @return \AbonnementApiV6\StructType\SearchSmartcodeResponse|bool
     */
    public function searchSmartcode(\AbonnementApiV6\StructType\SearchSmartcodeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchSmartcode($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchRelNoByAboNo
     * Meta information extracted from the WSDL
     * - documentation: Geeft het relatienummer van het opgegeven abonnementnummer terug. Dat is afhankelijk van de gevraagde soort relatie de abonnee, de debiteur of de aanbrenger.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\SearchRelNoByAboNoRequest $request_parameters
     * @return \AbonnementApiV6\StructType\SearchRelNoByAboNoResponse|bool
     */
    public function searchRelNoByAboNo(\AbonnementApiV6\StructType\SearchRelNoByAboNoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchRelNoByAboNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\SearchAbonnementByCredResponse|\AbonnementApiV6\StructType\SearchAbonnementResponse|\AbonnementApiV6\StructType\SearchRelNoByAboNoResponse|\AbonnementApiV6\StructType\SearchSmartcodeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
