<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancelBezorgKlacht
     * Meta information extracted from the WSDL
     * - documentation: Annuleert een bezorg klacht als de abonnee vindt dat het bij nader inzien een onterechte klacht is. Of annulering van een bezorgklacht nog is toegestaan wordt aangegeven door het element canCancel in het type KlachtV4. Als een klacht
     * bijvoorbeeld al is afgehandeld kan deze niet meer worden geannuleerd, actie is dan namelijk al ondernomen.error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de opgegeven relNo.error3: Er is geen
     * bezorgklacht nummer opgegeven.error4: Het bezorgklacht nummer is niet gevonden.error5: De relatie die wil annuleren is niet de melder van de klacht.error6: De klacht status voor annuleren kan niet worden bepaald.error7: De bezorgklacht mag niet
     * worden geannuleerd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\CancelBezorgKlachtRequest $request_parameters
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtResponse|bool
     */
    public function cancelBezorgKlacht(\AbonnementApiV6\StructType\CancelBezorgKlachtRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->cancelBezorgKlacht($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\CancelBezorgKlachtResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
