<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wijkCheckResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error256: De propositie is niet gevonden | error188: Teveel parameters tegelijk ingevuld, kies uitgave of abonnementsoort of pakket | error187: Het huisnummer dient geheel te bestaan uit cijfers | error186: De postcode dient te
 * bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletters | error185: De pakketcode is ongeldig of er zijn geen gekoppelde uitgaven | error184: De abonnementsoort code is ongeldig of niet gekoppeld aan een uitgave | error183: De uitgave code is
 * ongeldig | error182: De combinatie postcode/huisnummer is ongeldig
 * @subpackage Structs
 * @date 20240419 package
 */
class WijkCheckResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The leveringMogelijk
     * Meta information extracted from the WSDL
     * - documentation: [0,1,2,3] Indicatie of levering mogelijk is. 0 = geen levering mogelijk, 1 = reguliere bezorging mogelijk, 2 = postbezorging mogelijk, 3 = wordt in toekomst afgeschaald.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $leveringMogelijk;
    /**
     * The afschalenPer
     * Meta information extracted from the WSDL
     * - documentation: Datum per wanneer afgeschaald gaat worden
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afschalenPer;
    /**
     * Constructor method for wijkCheckResponse
     * @uses WijkCheckResponse::setRequestTag()
     * @uses WijkCheckResponse::setLeveringMogelijk()
     * @uses WijkCheckResponse::setAfschalenPer()
     * @param string $requestTag
     * @param float $leveringMogelijk
     * @param string $afschalenPer
     */
    public function __construct($requestTag = null, $leveringMogelijk = null, $afschalenPer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLeveringMogelijk($leveringMogelijk)
            ->setAfschalenPer($afschalenPer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\WijkCheckResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get leveringMogelijk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLeveringMogelijk()
    {
        return isset($this->leveringMogelijk) ? $this->leveringMogelijk : null;
    }
    /**
     * Set leveringMogelijk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $leveringMogelijk
     * @return \AbonnementApiV6\StructType\WijkCheckResponse
     */
    public function setLeveringMogelijk($leveringMogelijk = null)
    {
        // validation for constraint: float
        if (!is_null($leveringMogelijk) && !(is_float($leveringMogelijk) || is_numeric($leveringMogelijk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leveringMogelijk, true), gettype($leveringMogelijk)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($leveringMogelijk) && mb_strlen(preg_replace('/(\D)/', '', $leveringMogelijk)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($leveringMogelijk, true), mb_strlen(preg_replace('/(\D)/', '', $leveringMogelijk))), __LINE__);
        }
        if (is_null($leveringMogelijk) || (is_array($leveringMogelijk) && empty($leveringMogelijk))) {
            unset($this->leveringMogelijk);
        } else {
            $this->leveringMogelijk = $leveringMogelijk;
        }
        return $this;
    }
    /**
     * Get afschalenPer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfschalenPer()
    {
        return isset($this->afschalenPer) ? $this->afschalenPer : null;
    }
    /**
     * Set afschalenPer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afschalenPer
     * @return \AbonnementApiV6\StructType\WijkCheckResponse
     */
    public function setAfschalenPer($afschalenPer = null)
    {
        // validation for constraint: string
        if (!is_null($afschalenPer) && !is_string($afschalenPer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afschalenPer, true), gettype($afschalenPer)), __LINE__);
        }
        if (is_null($afschalenPer) || (is_array($afschalenPer) && empty($afschalenPer))) {
            unset($this->afschalenPer);
        } else {
            $this->afschalenPer = $afschalenPer;
        }
        return $this;
    }
}
