<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for stopGratisAboPerDirectResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error10: De stopreden is niet gevonden. | error9: Het abonnement is reeds gestopt. | error8: De inrichting van de uitgave of abonnementsoort voldoet niet aan de voorwaarden. | error7: Er is geen abonnement gevonden op basis van de
 * opgegeven relNo, uitgaveCode en abosoortCode | error6: De opgegeven abosoortCode hoort niet bij de opgegeven uitgaveCode. | error5: Kan geen abonnementsoort vinden obv de opgegeven abosoortCode. | error4: Kan geen uitgave vinden obv de opgegeven
 * uitgaveCode. | error3: Kan geen relatie vinden obv de opgegeven relNo | error2: Het abonnement is niet gevonden op basis van de opgegeven aboNo. | error1: Ongeldige combinatie van argumenten: geef ofwel een aboNo op, ofwel een combiniatie van een
 * relNo en uitgaveCode met evt. een abosoortCode,
 * @subpackage Structs
 * @date 20240419 package
 */
class StopGratisAboPerDirectResponse extends AbstractStructBase
{
    /**
     * The stopDatum
     * Meta information extracted from the WSDL
     * - documentation: De datum waarop het abonnement is stopgezet
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $stopDatum;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for stopGratisAboPerDirectResponse
     * @uses StopGratisAboPerDirectResponse::setStopDatum()
     * @uses StopGratisAboPerDirectResponse::setRequestTag()
     * @param string $stopDatum
     * @param string $requestTag
     */
    public function __construct($stopDatum = null, $requestTag = null)
    {
        $this
            ->setStopDatum($stopDatum)
            ->setRequestTag($requestTag);
    }
    /**
     * Get stopDatum value
     * @return string
     */
    public function getStopDatum()
    {
        return $this->stopDatum;
    }
    /**
     * Set stopDatum value
     * @param string $stopDatum
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectResponse
     */
    public function setStopDatum($stopDatum = null)
    {
        // validation for constraint: string
        if (!is_null($stopDatum) && !is_string($stopDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopDatum, true), gettype($stopDatum)), __LINE__);
        }
        $this->stopDatum = $stopDatum;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \AbonnementApiV6\StructType\StopGratisAboPerDirectResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
